/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class GroupsPrefsTab
extends JPanel
implements PrefsTab {
    private final JCheckBox showIcons = new JCheckBox(Globals.lang("Show icons for groups"));
    private final JCheckBox showDynamic = new JCheckBox("<html>" + Globals.lang("Show dynamic groups in <i>italics</i>") + "</html>");
    private final JCheckBox expandTree = new JCheckBox(Globals.lang("Initially show groups tree expanded"));
    private final JCheckBox autoShow = new JCheckBox(Globals.lang("Automatically show groups interface when switching to a database that contains groups"));
    private final JCheckBox autoHide = new JCheckBox(Globals.lang("Automatically hide groups interface when switching to a database that contains no groups"));
    private final JCheckBox autoAssignGroup = new JCheckBox(Globals.lang("Automatically assign new entry to selected groups"));
    private final JTextField groupingField = new JTextField(20);
    private final JTextField keywordSeparator = new JTextField(2);
    private final JabRefPreferences prefs;

    public GroupsPrefsTab(JabRefPreferences jabRefPreferences) {
        this.prefs = jabRefPreferences;
        this.keywordSeparator.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GroupsPrefsTab.this.keywordSeparator.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        FormLayout formLayout = new FormLayout("9dlu, pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("View"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.showIcons);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.showDynamic);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.expandTree);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.autoShow);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.autoHide);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.autoAssignGroup);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Dynamic groups"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextLine();
        defaultFormBuilder.nextColumn();
        FormLayout formLayout2 = new FormLayout("left:pref, 2dlu, left:pref", "p, 3dlu, p");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.append(new JLabel(Globals.lang("Default grouping field") + ":"));
        defaultFormBuilder2.append(this.groupingField);
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.nextLine();
        defaultFormBuilder2.append(new JLabel(Globals.lang("When adding/removing keywords, separate them by") + ":"));
        defaultFormBuilder2.append(this.keywordSeparator);
        defaultFormBuilder.append(defaultFormBuilder2.getPanel());
        this.setLayout(new BorderLayout());
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        this.showIcons.setSelected(this.prefs.getBoolean("groupShowIcons"));
        this.showDynamic.setSelected(this.prefs.getBoolean("groupShowDynamic"));
        this.expandTree.setSelected(this.prefs.getBoolean("groupExpandTree"));
        this.groupingField.setText(this.prefs.get("groupsDefaultField"));
        this.autoShow.setSelected(this.prefs.getBoolean("groupAutoShow"));
        this.autoHide.setSelected(this.prefs.getBoolean("groupAutoHide"));
        this.keywordSeparator.setText(this.prefs.get("groupKeywordSeparator"));
        this.autoAssignGroup.setSelected(this.prefs.getBoolean("autoAssignGroup"));
    }

    @Override
    public void storeSettings() {
        this.prefs.putBoolean("groupShowIcons", this.showIcons.isSelected());
        this.prefs.putBoolean("groupShowDynamic", this.showDynamic.isSelected());
        this.prefs.putBoolean("groupExpandTree", this.expandTree.isSelected());
        this.prefs.put("groupsDefaultField", this.groupingField.getText().trim());
        this.prefs.putBoolean("groupAutoShow", this.autoShow.isSelected());
        this.prefs.putBoolean("groupAutoHide", this.autoHide.isSelected());
        this.prefs.putBoolean("autoAssignGroup", this.autoAssignGroup.isSelected());
        this.prefs.put("groupKeywordSeparator", this.keywordSeparator.getText());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Groups");
    }
}

