/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeCellRenderer;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.TransferableEntrySelection;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.UndoableMoveGroup;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.util.Util;

public class GroupsTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static final int dragScrollActivationMargin = 10;
    private static final int dragScrollDistance = 5;
    private static long lastDragAutoscroll = 0L;
    private static final long minAutoscrollInterval = 50L;
    private Point idlePoint;
    private long idleStartTime = 0L;
    private static final int idleMargin = 1;
    private static final long idleTimeToExpandNode = 1000L;
    private final GroupSelector groupSelector;
    private GroupTreeNode dragNode = null;
    private final GroupTreeCellRenderer cellRenderer = new GroupTreeCellRenderer();

    public GroupsTree(GroupSelector groupSelector) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setRowHeight(Math.max(this.getRowHeight(), fontMetrics.getHeight()));
        this.groupSelector = groupSelector;
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 2, this);
        dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        new DropTarget(this, this);
        this.setCellRenderer(this.cellRenderer);
        this.setFocusable(false);
        this.setToggleClickCount(0);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setShowsRootHandles(false);
        this.setVisibleRowCount(Globals.prefs.getInt("groupsVisibleRows"));
        this.getSelectionModel().setSelectionMode(4);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        Point point = dragSourceDragEvent.getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
        if (groupTreeNode == null || this.dragNode.isNodeDescendant(groupTreeNode) || this.dragNode == groupTreeNode) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
            return;
        }
        dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragNode = null;
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl;
        TreePath treePath;
        Point point = dropTargetDragEvent.getLocation();
        long l = System.currentTimeMillis();
        if (this.idlePoint == null) {
            this.idlePoint = point;
        }
        GroupTreeNode groupTreeNode = (treePath = this.getPathForLocation(point.x, point.y)) == null ? null : (GroupTreeNode)treePath.getLastPathComponent();
        this.setHighlight1Cell(groupTreeNode);
        if (dropTargetDragEvent.isDataFlavorSupported(GroupTreeNode.flavor)) {
            dropTargetDragEvent.acceptDrag(2);
        } else if (dropTargetDragEvent.isDataFlavorSupported(TransferableEntrySelection.flavorInternal)) {
            if (treePath == null) {
                dropTargetDragEvent.rejectDrag();
            } else if (groupTreeNode.getGroup().supportsAdd()) {
                dropTargetDragEvent.acceptDrag(0x40000000);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        if (Math.abs(point.x - this.idlePoint.x) < 1 && Math.abs(point.y - this.idlePoint.y) < 1) {
            if (l - this.idleStartTime >= 1000L && treePath != null) {
                this.expandPath(treePath);
            }
        } else {
            this.idlePoint = point;
            this.idleStartTime = l;
        }
        if (l - lastDragAutoscroll < 50L) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        boolean bl2 = point.y - rectangle.y < 10;
        boolean bl3 = rectangle.y + rectangle.height - point.y < 10;
        boolean bl4 = point.x - rectangle.x < 10;
        boolean bl5 = bl = rectangle.x + rectangle.width - point.x < 10;
        if (bl2) {
            rectangle.translate(0, -5);
        } else if (bl3) {
            rectangle.translate(0, 5);
        }
        if (bl4) {
            rectangle.translate(-5, 0);
        } else if (bl) {
            rectangle.translate(5, 0);
        }
        this.scrollRectToVisible(rectangle);
        lastDragAutoscroll = l;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.setHighlight1Cell(null);
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            Point point = dropTargetDropEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
            if (transferable.isDataFlavorSupported(GroupTreeNode.flavor)) {
                GroupTreeNode groupTreeNode2 = (GroupTreeNode)transferable.getTransferData(GroupTreeNode.flavor);
                if (groupTreeNode2 == groupTreeNode) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                if (groupTreeNode2.isNodeDescendant(groupTreeNode)) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                Enumeration<TreePath> enumeration = this.groupSelector.getExpandedPaths();
                UndoableMoveGroup undoableMoveGroup = new UndoableMoveGroup(this.groupSelector, this.groupSelector.getGroupTreeRoot(), groupTreeNode2, groupTreeNode, groupTreeNode.getChildCount());
                groupTreeNode.add(groupTreeNode2);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                this.groupSelector.revalidateGroups(new TreePath[]{new TreePath(groupTreeNode2.getPath())}, this.refreshPaths(enumeration));
                this.groupSelector.concludeMoveGroup(undoableMoveGroup, groupTreeNode2);
            } else if (transferable.isDataFlavorSupported(TransferableEntrySelection.flavorInternal)) {
                AbstractGroup abstractGroup = groupTreeNode.getGroup();
                if (!abstractGroup.supportsAdd()) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                TransferableEntrySelection transferableEntrySelection = (TransferableEntrySelection)transferable.getTransferData(TransferableEntrySelection.flavorInternal);
                BibtexEntry[] bibtexEntryArray = transferableEntrySelection.getSelection();
                int n = 0;
                for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                    if (groupTreeNode.getGroup().contains(bibtexEntry)) continue;
                    ++n;
                }
                if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{abstractGroup}, transferableEntrySelection.getSelection(), this.groupSelector.getActiveBasePanel().getDatabase(), this.groupSelector.frame)) {
                    return;
                }
                this.groupSelector.getActiveBasePanel().storeCurrentEdit();
                AbstractUndoableEdit abstractUndoableEdit = abstractGroup.add(transferableEntrySelection.getSelection());
                if (abstractUndoableEdit instanceof UndoableChangeAssignment) {
                    ((UndoableChangeAssignment)abstractUndoableEdit).setEditedNode(groupTreeNode);
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                this.groupSelector.revalidateGroups();
                this.groupSelector.concludeAssignment(abstractUndoableEdit, groupTreeNode, n);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.setHighlight1Cell(null);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        GroupTreeNode groupTreeNode = this.getSelectedNode();
        if (groupTreeNode == null) {
            return;
        }
        Cursor cursor = DragSource.DefaultMoveDrop;
        this.dragNode = groupTreeNode;
        dragGestureEvent.getDragSource().startDrag(dragGestureEvent, cursor, groupTreeNode, this);
    }

    private GroupTreeNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        return treePath != null ? (GroupTreeNode)treePath.getLastPathComponent() : null;
    }

    public Enumeration<TreePath> refreshPaths(Enumeration<TreePath> enumeration) {
        Vector<TreePath> vector = new Vector<TreePath>();
        while (enumeration.hasMoreElements()) {
            vector.add(new TreePath(((DefaultMutableTreeNode)enumeration.nextElement().getLastPathComponent()).getPath()));
        }
        return vector.elements();
    }

    public TreePath[] refreshPaths(TreePath[] treePathArray) {
        TreePath[] treePathArray2 = new TreePath[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            treePathArray2[i] = new TreePath(((DefaultMutableTreeNode)treePathArray[i].getLastPathComponent()).getPath());
        }
        return treePathArray2;
    }

    private void setHighlight1Cell(Object object) {
        this.cellRenderer.setHighlight1Cell(object);
        this.repaint();
    }

    public void setHighlight2Cells(Object[] objectArray) {
        this.cellRenderer.setHighlight2Cells(objectArray);
        this.repaint();
    }

    public void setHighlight3Cells(Object[] objectArray) {
        this.cellRenderer.setHighlight3Cells(objectArray);
        this.repaint();
    }

    public void setHighlightBorderCell(GroupTreeNode groupTreeNode) {
        this.cellRenderer.setHighlightBorderCell(groupTreeNode);
        this.repaint();
    }

    public void sort(GroupTreeNode groupTreeNode, boolean bl) {
        this.sortWithoutRevalidate(groupTreeNode, bl);
        this.groupSelector.revalidateGroups();
    }

    private void sortWithoutRevalidate(GroupTreeNode groupTreeNode, boolean bl) {
        int n;
        if (groupTreeNode.isLeaf()) {
            return;
        }
        int n2 = groupTreeNode.getChildCount() - 1;
        while (n2 > 0) {
            int n3 = n2 + 1;
            n2 = -1;
            for (n = 1; n < n3; ++n) {
                GroupTreeNode groupTreeNode2 = (GroupTreeNode)groupTreeNode.getChildAt(n - 1);
                GroupTreeNode groupTreeNode3 = (GroupTreeNode)groupTreeNode.getChildAt(n);
                if (groupTreeNode3.getGroup().getName().compareToIgnoreCase(groupTreeNode2.getGroup().getName()) >= 0) continue;
                groupTreeNode.remove(groupTreeNode2);
                groupTreeNode.insert(groupTreeNode2, n);
                n2 = n;
            }
        }
        if (bl) {
            for (n = 0; n < groupTreeNode.getChildCount(); ++n) {
                this.sortWithoutRevalidate((GroupTreeNode)groupTreeNode.getChildAt(n), true);
            }
        }
    }

    public void expandSubtree(GroupTreeNode groupTreeNode) {
        Enumeration<GroupTreeNode> enumeration = groupTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            this.expandPath(new TreePath(enumeration.nextElement().getPath()));
        }
    }

    public void collapseSubtree(GroupTreeNode groupTreeNode) {
        Enumeration<GroupTreeNode> enumeration = groupTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            this.collapsePath(new TreePath(enumeration.nextElement().getPath()));
        }
    }

    public boolean hasExpandedDescendant(TreePath treePath) {
        GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
        Enumeration<GroupTreeNode> enumeration = groupTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2;
            GroupTreeNode groupTreeNode2 = enumeration.nextElement();
            if (groupTreeNode2.isLeaf() || !this.isExpanded(treePath2 = treePath.pathByAddingChild(groupTreeNode2)) && !this.hasExpandedDescendant(treePath2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCollapsedDescendant(TreePath treePath) {
        GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
        Enumeration<GroupTreeNode> enumeration = groupTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2;
            GroupTreeNode groupTreeNode2 = enumeration.nextElement();
            if (groupTreeNode2.isLeaf() || !this.isCollapsed(treePath2 = treePath.pathByAddingChild(groupTreeNode2)) && !this.hasCollapsedDescendant(treePath2)) continue;
            return true;
        }
        return false;
    }
}

