/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.sf.jabref.BibtexEntry;

class TransferableEntrySelection
implements Transferable {
    public static final DataFlavor flavorInternal;
    private static final DataFlavor flavorExternal;
    private static final DataFlavor[] flavors;
    private final BibtexEntry[] selectedEntries;
    private final String selectedEntriesCiteKeys;
    private boolean includeCiteKeyword = false;

    public TransferableEntrySelection(BibtexEntry[] bibtexEntryArray) {
        this.selectedEntries = bibtexEntryArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            stringBuilder.append(bibtexEntryArray[i].getCiteKey());
            if (i + 1 >= bibtexEntryArray.length) continue;
            stringBuilder.append(",");
        }
        this.selectedEntriesCiteKeys = stringBuilder.toString();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(flavorInternal) || dataFlavor.equals(flavorExternal);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.equals(flavorInternal)) {
            return this;
        }
        String string = this.includeCiteKeyword ? "\\cite{" + this.selectedEntriesCiteKeys + "}" : this.selectedEntriesCiteKeys;
        return new ByteArrayInputStream(string.getBytes(flavorExternal.getParameter("charset").trim()));
    }

    public BibtexEntry[] getSelection() {
        return this.selectedEntries;
    }

    public void setIncludeCiteKeyword(boolean bl) {
        this.includeCiteKeyword = bl;
    }

    static {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=net.sf.jabref.groups.TransferableEntrySelection");
            dataFlavor2 = DataFlavor.getTextPlainUnicodeFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        flavorInternal = dataFlavor;
        flavorExternal = dataFlavor2;
        flavors = new DataFlavor[]{flavorInternal, flavorExternal};
    }
}

