/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

class UndoableAddOrRemoveGroup
extends AbstractUndoableEdit {
    private final GroupTreeNode m_groupsRootHandle;
    private final GroupTreeNode m_subtreeBackup;
    private final int m_subtreeRootChildCount;
    private final int[] m_pathToNode;
    private final int m_editType;
    private final GroupSelector m_groupSelector;
    private boolean m_revalidate = true;
    public static final int ADD_NODE = 0;
    public static final int REMOVE_NODE_KEEP_CHILDREN = 1;
    public static final int REMOVE_NODE_AND_CHILDREN = 2;

    public UndoableAddOrRemoveGroup(GroupSelector groupSelector, GroupTreeNode groupTreeNode, GroupTreeNode groupTreeNode2, int n) {
        this.m_groupSelector = groupSelector;
        this.m_groupsRootHandle = groupTreeNode;
        this.m_editType = n;
        this.m_subtreeRootChildCount = groupTreeNode2.getChildCount();
        this.m_subtreeBackup = n != 1 ? groupTreeNode2.deepCopy() : new GroupTreeNode(groupTreeNode2.getGroup().deepCopy());
        this.m_pathToNode = groupTreeNode2.getIndexedPath();
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + this.getName();
    }

    private String getName() {
        switch (this.m_editType) {
            case 0: {
                return Globals.lang("add group");
            }
            case 1: {
                return Globals.lang("remove group (keep subgroups)");
            }
            case 2: {
                return Globals.lang("remove group and subgroups");
            }
        }
        return "? (" + Globals.lang("unknown edit") + ")";
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + this.getName();
    }

    @Override
    public void undo() {
        super.undo();
        this.doOperation(true);
    }

    @Override
    public void redo() {
        super.redo();
        this.doOperation(false);
    }

    private void doOperation(boolean bl) {
        GroupTreeNode groupTreeNode = this.m_groupsRootHandle;
        int n = this.m_pathToNode[this.m_pathToNode.length - 1];
        for (int i = 0; i < this.m_pathToNode.length - 1; ++i) {
            groupTreeNode = (GroupTreeNode)groupTreeNode.getChildAt(this.m_pathToNode[i]);
        }
        if (bl) {
            switch (this.m_editType) {
                case 0: {
                    groupTreeNode.remove(n);
                    break;
                }
                case 1: {
                    GroupTreeNode groupTreeNode2 = this.m_subtreeBackup.deepCopy();
                    for (int i = n; i < n + this.m_subtreeRootChildCount; ++i) {
                        groupTreeNode2.add((GroupTreeNode)groupTreeNode.getChildAt(n));
                    }
                    groupTreeNode.insert(groupTreeNode2, n);
                    break;
                }
                case 2: {
                    groupTreeNode.insert(this.m_subtreeBackup.deepCopy(), n);
                }
            }
        } else {
            switch (this.m_editType) {
                case 0: {
                    groupTreeNode.insert(this.m_subtreeBackup.deepCopy(), n);
                    break;
                }
                case 1: {
                    GroupTreeNode groupTreeNode3 = (GroupTreeNode)groupTreeNode.getChildAt(n);
                    groupTreeNode.remove(n);
                    while (groupTreeNode3.getChildCount() > 0) {
                        groupTreeNode.insert((GroupTreeNode)groupTreeNode3.getFirstChild(), n);
                    }
                    break;
                }
                case 2: {
                    groupTreeNode.remove(n);
                }
            }
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void setRevalidate(boolean bl) {
        this.m_revalidate = bl;
    }
}

