/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups.structure;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.groups.structure.ExplicitGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.KeywordGroup;
import net.sf.jabref.groups.structure.SearchGroup;
import net.sf.jabref.search.SearchRule;

public abstract class AbstractGroup {
    String name;
    GroupHierarchyType context = GroupHierarchyType.INDEPENDENT;
    static final char QUOTE_CHAR = '\\';
    static final String SEPARATOR = ";";

    public abstract String getTypeId();

    AbstractGroup(String string, GroupHierarchyType groupHierarchyType) {
        this.name = string;
        this.setHierarchicalContext(groupHierarchyType);
    }

    public abstract SearchRule getSearchRule();

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (string.startsWith("KeywordGroup:")) {
            return KeywordGroup.fromString(string, bibtexDatabase, n);
        }
        if (string.startsWith("AllEntriesGroup:")) {
            return AllEntriesGroup.fromString(string, bibtexDatabase, n);
        }
        if (string.startsWith("SearchGroup:")) {
            return SearchGroup.fromString(string, bibtexDatabase, n);
        }
        if (string.startsWith("ExplicitGroup:")) {
            return ExplicitGroup.fromString(string, bibtexDatabase, n);
        }
        return null;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public abstract boolean supportsAdd();

    public abstract boolean supportsRemove();

    public abstract AbstractUndoableEdit add(BibtexEntry[] var1);

    public abstract AbstractUndoableEdit remove(BibtexEntry[] var1);

    public abstract boolean contains(String var1, BibtexEntry var2);

    public abstract boolean contains(BibtexEntry var1);

    public boolean containsAny(BibtexEntry[] bibtexEntryArray) {
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            if (!this.contains(bibtexEntry)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BibtexEntry[] bibtexEntryArray) {
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            if (this.contains(bibtexEntry)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDynamic();

    public void setHierarchicalContext(GroupHierarchyType groupHierarchyType) {
        if (groupHierarchyType == null) {
            return;
        }
        this.context = groupHierarchyType;
    }

    public GroupHierarchyType getHierarchicalContext() {
        return this.context;
    }

    public abstract String getDescription();

    public abstract AbstractGroup deepCopy();

    public abstract String getShortDescription();

    public void refreshForNewDatabase(BibtexDatabase bibtexDatabase) {
    }
}

