/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups.structure;

import java.util.regex.Pattern;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.groups.structure.UnsupportedVersionException;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.QuotedStringTokenizer;
import net.sf.jabref.util.StringUtil;

public class KeywordGroup
extends AbstractGroup {
    public static final String ID = "KeywordGroup:";
    private final String searchField;
    private final String searchExpression;
    private final boolean caseSensitive;
    private final boolean regExp;
    private Pattern pattern = null;

    public KeywordGroup(String string, String string2, String string3, boolean bl, boolean bl2, GroupHierarchyType groupHierarchyType) throws IllegalArgumentException {
        super(string, groupHierarchyType);
        this.searchField = string2;
        this.searchExpression = string3;
        this.caseSensitive = bl;
        this.regExp = bl2;
        if (this.regExp) {
            this.compilePattern();
        }
    }

    private void compilePattern() throws IllegalArgumentException {
        this.pattern = this.caseSensitive ? Pattern.compile("\\b" + this.searchExpression + "\\b") : Pattern.compile("\\b" + this.searchExpression + "\\b", 2);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: KeywordGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(ID.length()), ";", '\\');
        switch (n) {
            case 0: {
                String string2 = quotedStringTokenizer.nextToken();
                String string3 = quotedStringTokenizer.nextToken();
                String string4 = quotedStringTokenizer.nextToken();
                return new KeywordGroup(StringUtil.unquote(string2, '\\'), StringUtil.unquote(string3, '\\'), StringUtil.unquote(string4, '\\'), false, true, GroupHierarchyType.INDEPENDENT);
            }
            case 1: 
            case 2: {
                String string5 = quotedStringTokenizer.nextToken();
                String string6 = quotedStringTokenizer.nextToken();
                String string7 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl2 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new KeywordGroup(StringUtil.unquote(string5, '\\'), StringUtil.unquote(string6, '\\'), StringUtil.unquote(string7, '\\'), bl, bl2, GroupHierarchyType.INDEPENDENT);
            }
            case 3: {
                String string8 = quotedStringTokenizer.nextToken();
                int n2 = Integer.parseInt(quotedStringTokenizer.nextToken());
                String string9 = quotedStringTokenizer.nextToken();
                String string10 = quotedStringTokenizer.nextToken();
                boolean bl = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                boolean bl3 = Integer.parseInt(quotedStringTokenizer.nextToken()) == 1;
                return new KeywordGroup(StringUtil.unquote(string8, '\\'), StringUtil.unquote(string9, '\\'), StringUtil.unquote(string10, '\\'), bl, bl3, GroupHierarchyType.getByNumber(n2));
            }
        }
        throw new UnsupportedVersionException("KeywordGroup", n);
    }

    @Override
    public SearchRule getSearchRule() {
        return new SearchRule(){

            @Override
            public boolean applyRule(String string, BibtexEntry bibtexEntry) {
                return KeywordGroup.this.contains(string, bibtexEntry);
            }

            @Override
            public boolean validateSearchStrings(String string) {
                return true;
            }
        };
    }

    public String toString() {
        return ID + StringUtil.quote(this.name, ";", '\\') + ";" + this.context.ordinal() + ";" + StringUtil.quote(this.searchField, ";", '\\') + ";" + StringUtil.quote(this.searchExpression, ";", '\\') + ";" + StringUtil.booleanToBinaryString(this.caseSensitive) + ";" + StringUtil.booleanToBinaryString(this.regExp) + ";";
    }

    @Override
    public boolean supportsAdd() {
        return !this.regExp;
    }

    @Override
    public boolean supportsRemove() {
        return !this.regExp;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        if (!this.supportsAdd()) {
            return null;
        }
        if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("add entries to group"));
            boolean bl = false;
            for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                if (this.getSearchRule().applyRule(SearchRule.NULL_QUERY, bibtexEntry)) continue;
                String string = bibtexEntry.getField(this.searchField);
                String string2 = Globals.prefs.get("groupKeywordSeparator");
                String string3 = (string == null ? "" : string + string2) + this.searchExpression;
                bibtexEntry.setField(this.searchField, string3);
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, this.searchField, string, string3));
                bl = true;
            }
            if (bl) {
                namedCompound.end();
            }
            return bl ? namedCompound : null;
        }
        return null;
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        if (!this.supportsRemove()) {
            return null;
        }
        if (bibtexEntryArray != null && bibtexEntryArray.length > 0) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("remove from group"));
            boolean bl = false;
            for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                if (!this.getSearchRule().applyRule(SearchRule.NULL_QUERY, bibtexEntry)) continue;
                String string = bibtexEntry.getField(this.searchField);
                this.removeMatches(bibtexEntry);
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, this.searchField, string, bibtexEntry.getField(this.searchField)));
                bl = true;
            }
            if (bl) {
                namedCompound.end();
            }
            return bl ? namedCompound : null;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeywordGroup)) {
            return false;
        }
        KeywordGroup keywordGroup = (KeywordGroup)object;
        return this.name.equals(keywordGroup.name) && this.searchField.equals(keywordGroup.searchField) && this.searchExpression.equals(keywordGroup.searchExpression) && this.caseSensitive == keywordGroup.caseSensitive && this.regExp == keywordGroup.regExp && this.getHierarchicalContext() == keywordGroup.getHierarchicalContext();
    }

    @Override
    public boolean contains(String string, BibtexEntry bibtexEntry) {
        return this.contains(bibtexEntry);
    }

    @Override
    public boolean contains(BibtexEntry bibtexEntry) {
        String string = bibtexEntry.getField(this.searchField);
        if (string == null) {
            return false;
        }
        if (this.regExp) {
            return this.pattern.matcher(string).find();
        }
        if (this.caseSensitive) {
            return KeywordGroup.containsWord(this.searchExpression, string);
        }
        return KeywordGroup.containsWord(this.searchExpression.toLowerCase(), string.toLowerCase());
    }

    private static boolean containsWord(String string, String string2) {
        int n = 0;
        while (n < string2.length()) {
            int n2 = string2.indexOf(string, n);
            if (n2 < 0) {
                return false;
            }
            if (!(n2 != 0 && Character.isLetterOrDigit(string2.charAt(n2 - 1)) || n2 + string.length() != string2.length() && Character.isLetterOrDigit(string2.charAt(n2 + string.length())))) {
                return true;
            }
            n = n2 + 1;
        }
        return false;
    }

    private void removeMatches(BibtexEntry bibtexEntry) {
        int n;
        String string = bibtexEntry.getField(this.searchField);
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string.toLowerCase());
        StringBuffer stringBuffer3 = this.caseSensitive ? stringBuffer : stringBuffer2;
        String string2 = this.caseSensitive ? this.searchExpression : this.searchExpression.toLowerCase();
        String string3 = Globals.prefs.get("groupKeywordSeparator");
        while ((n = stringBuffer3.indexOf(string2)) >= 0) {
            stringBuffer.replace(n, n + string2.length(), "");
            stringBuffer2.replace(n, n + string2.length(), "");
            int n2 = n;
            int n3 = n;
            while (n2 - 1 >= 0 && string3.indexOf(stringBuffer3.charAt(n2 - 1)) >= 0) {
                --n2;
            }
            while (n3 < stringBuffer3.length() && string3.indexOf(stringBuffer3.charAt(n3)) >= 0) {
                ++n3;
            }
            stringBuffer.replace(n2, n3, n2 >= 0 && n3 < stringBuffer.length() ? string3 : "");
            stringBuffer2.replace(n2, n3, n2 >= 0 && n3 < stringBuffer.length() ? string3 : "");
        }
        String string4 = stringBuffer.toString().trim();
        bibtexEntry.setField(this.searchField, !string4.isEmpty() ? string4 : null);
    }

    @Override
    public AbstractGroup deepCopy() {
        try {
            return new KeywordGroup(this.name, this.searchField, this.searchExpression, this.caseSensitive, this.regExp, this.context);
        }
        catch (Throwable throwable) {
            System.err.println("Internal error: Exception " + throwable + " in KeywordGroup.deepCopy(). " + "Please report this on www.sf.net/projects/jabref");
            return null;
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegExp() {
        return this.regExp;
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public String getSearchField() {
        return this.searchField;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String getDescription() {
        return KeywordGroup.getDescriptionForPreview(this.searchField, this.searchExpression, this.caseSensitive, this.regExp);
    }

    public static String getDescriptionForPreview(String string, String string2, boolean bl, boolean bl2) {
        String string3 = bl2 ? Globals.lang("This group contains entries whose <b>%0</b> field contains the regular expression <b>%1</b>", string, StringUtil.quoteForHTML(string2)) : Globals.lang("This group contains entries whose <b>%0</b> field contains the keyword <b>%1</b>", string, StringUtil.quoteForHTML(string2));
        String string4 = bl ? Globals.lang("case sensitive") : Globals.lang("case insensitive");
        String string5 = bl2 ? Globals.lang("Entries cannot be manually assigned to or removed from this group.") : Globals.lang("Additionally, entries whose <b>%0</b> field does not contain <b>%1</b> can be assigned manually to this group by selecting them then using either drag and drop or the context menu. This process adds the term <b>%1</b> to each entry's <b>%0</b> field. Entries can be removed manually from this group by selecting them then using the context menu. This process removes the term <b>%1</b> from each entry's <b>%0</b> field.", string, StringUtil.quoteForHTML(string2));
        return String.format("%s (%s). %s", string3, string4, string5);
    }

    @Override
    public String getShortDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>");
        if (Globals.prefs.getBoolean("groupShowDynamic")) {
            stringBuilder.append("<i>").append(StringUtil.quoteForHTML(this.getName())).append("</i>");
        } else {
            stringBuilder.append(StringUtil.quoteForHTML(this.getName()));
        }
        stringBuilder.append("</b> - ");
        stringBuilder.append(Globals.lang("dynamic group"));
        stringBuilder.append("<b>");
        stringBuilder.append(this.searchField);
        stringBuilder.append("</b>");
        stringBuilder.append(Globals.lang("contains"));
        stringBuilder.append(" <b>");
        stringBuilder.append(StringUtil.quoteForHTML(this.searchExpression));
        stringBuilder.append("</b>)");
        switch (this.getHierarchicalContext()) {
            case INCLUDING: {
                stringBuilder.append(", ").append(Globals.lang("includes subgroups"));
                break;
            }
            case REFINING: {
                stringBuilder.append(", ").append(Globals.lang("refines supergroup"));
                break;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getTypeId() {
        return ID;
    }
}

