/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class AttachFileDialog
extends JDialog {
    private final AttachFileDialog ths = this;
    private final FieldEditor editor;
    private final String fieldName;
    private final JButton browse = new JButton(Globals.lang("Browse"));
    private final JButton download = new JButton(Globals.lang("Download"));
    private final JButton auto = new JButton(Globals.lang("Auto"));
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));
    private final BibtexEntry entry;
    private final MetaData metaData;
    private boolean cancelled = true;

    public AttachFileDialog(Frame frame, MetaData metaData, BibtexEntry bibtexEntry, String string) {
        super(frame, true);
        this.metaData = metaData;
        this.entry = bibtexEntry;
        this.fieldName = string;
        this.editor = new FieldTextField(string, bibtexEntry.getField(string), false);
        this.initGui();
    }

    public AttachFileDialog(Dialog dialog, MetaData metaData, BibtexEntry bibtexEntry, String string) {
        super(dialog, true);
        this.metaData = metaData;
        this.entry = bibtexEntry;
        this.fieldName = string;
        this.editor = new FieldTextField(string, bibtexEntry.getField(string), false);
        this.initGui();
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public String getValue() {
        return this.editor.getText();
    }

    private void initGui() {
        final ExternalFilePanel externalFilePanel = new ExternalFilePanel(this.fieldName, this.metaData, this.entry, this.editor, Util.getFileFilterForField(this.fieldName));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                externalFilePanel.browseFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor);
            }
        });
        this.download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                externalFilePanel.downLoadFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor, AttachFileDialog.this.ths);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JabRefExecutorService.INSTANCE.execute(externalFilePanel.autoSetFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor));
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttachFileDialog.this.cancelled = false;
                AttachFileDialog.this.dispose();
            }
        };
        this.ok.addActionListener(actionListener);
        ((JTextField)this.editor.getTextComponent()).addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttachFileDialog.this.cancelled = true;
                AttachFileDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction);
        this.editor.getTextComponent().getInputMap().put(Globals.prefs.getKey("Close dialog"), "close");
        this.editor.getTextComponent().getActionMap().put("close", abstractAction);
        FormLayout formLayout = new FormLayout("fill:160dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(StringUtil.nCase(this.fieldName));
        defaultFormBuilder.append(this.editor.getTextComponent());
        defaultFormBuilder.append(this.browse);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addButton((JComponent)this.download);
        buttonBarBuilder.addButton((JComponent)this.auto);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(buttonBarBuilder.getPanel());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator();
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
    }
}

