/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.labelPattern.LabelPatternPanel;
import net.sf.jabref.util.Util;

public class BibtexKeyPatternDialog
extends JDialog {
    private MetaData metaData;
    private BasePanel panel;
    private final LabelPatternPanel labelPatternPanel;

    public BibtexKeyPatternDialog(JabRefFrame jabRefFrame, BasePanel basePanel) {
        super(jabRefFrame, Globals.lang("Bibtex key patterns"), true);
        this.labelPatternPanel = new LabelPatternPanel(jabRefFrame.helpDiag);
        this.setPanel(basePanel);
        this.init();
    }

    public void setPanel(BasePanel basePanel) {
        this.panel = basePanel;
        this.metaData = basePanel.metaData();
        LabelPattern labelPattern = this.metaData.getLabelPattern();
        this.labelPatternPanel.setValues(labelPattern);
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.labelPatternPanel, "Center");
        JButton jButton = new JButton(Globals.lang("Ok"));
        JButton jButton2 = new JButton();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)jPanel, "South");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setPreferredSize(new Dimension(500, 600));
        this.pack();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BibtexKeyPatternDialog.this.metaData.setLabelPattern(BibtexKeyPatternDialog.this.labelPatternPanel.getLabelPattern());
                BibtexKeyPatternDialog.this.panel.markNonUndoableBaseChanged();
                BibtexKeyPatternDialog.this.dispose();
            }
        });
        final BibtexKeyPatternDialog bibtexKeyPatternDialog = this;
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                bibtexKeyPatternDialog.dispatchEvent(new WindowEvent(bibtexKeyPatternDialog, 201));
            }
        };
        jButton2.setAction(abstractAction);
        jButton2.setText(Globals.lang("Cancel"));
        Util.bindCloseDialogKeyToCancelAction(this.getRootPane(), abstractAction);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            super.setVisible(bl);
        }
    }
}

