/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.config.SaveOrderConfig;

public class DatabasePropertiesDialog
extends JDialog {
    private MetaData metaData;
    private BasePanel panel = null;
    private final JComboBox encoding;
    private final JButton ok;
    private final JButton cancel;
    private final JTextField fileDir = new JTextField(40);
    private final JTextField fileDirIndv = new JTextField(40);
    private final JTextField pdfDir = new JTextField(40);
    private final JTextField psDir = new JTextField(40);
    private String oldFileVal = "";
    private String oldFileIndvVal = "";
    private String oldPdfVal = "";
    private String oldPsVal = "";
    private SaveOrderConfig oldSaveOrderConfig;
    private JRadioButton saveAsConfiguredGlobally;
    private JRadioButton saveInOriginalOrder;
    private JRadioButton saveInSpecifiedOrder;
    private JComboBox savePriSort;
    private JComboBox saveSecSort;
    private JComboBox saveTerSort;
    private JTextField savePriField;
    private JTextField saveSecField;
    private JTextField saveTerField;
    private JCheckBox savePriDesc;
    private JCheckBox saveSecDesc;
    private JCheckBox saveTerDesc;
    public static final String SAVE_ORDER_CONFIG = "saveOrderConfig";
    private final JCheckBox protect = new JCheckBox(Globals.lang("Refuse to save the database before external changes have been reviewed."));
    private boolean oldProtectVal = false;

    public DatabasePropertiesDialog(JFrame jFrame) {
        super(jFrame, Globals.lang("Database properties"), true);
        this.encoding = new JComboBox<String>(Globals.ENCODINGS);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.init(jFrame);
    }

    public void setPanel(BasePanel basePanel) {
        this.panel = basePanel;
        this.metaData = basePanel.metaData();
    }

    private void init(JFrame jFrame) {
        JButton jButton = new JButton(Globals.lang("Browse"));
        JButton jButton2 = new JButton(Globals.lang("Browse"));
        JButton jButton3 = new JButton(Globals.lang("Browse"));
        JButton jButton4 = new JButton(Globals.lang("Browse"));
        jButton.addActionListener(BrowseAction.buildForDir(jFrame, this.fileDir));
        jButton2.addActionListener(BrowseAction.buildForDir(jFrame, this.fileDirIndv));
        jButton3.addActionListener(BrowseAction.buildForDir(jFrame, this.pdfDir));
        jButton4.addActionListener(BrowseAction.buildForDir(jFrame, this.psDir));
        this.setupSortOrderConfiguration();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, left:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder.append(Globals.lang("Database encoding"));
        defaultFormBuilder.append(this.encoding);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Override default file directories"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("General file directory"));
        defaultFormBuilder.append(this.fileDir);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("User-specific file directory"));
        defaultFormBuilder.append(this.fileDirIndv);
        defaultFormBuilder.append(jButton2);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("PDF directory"));
        defaultFormBuilder.append(this.pdfDir);
        defaultFormBuilder.append(jButton3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("PS directory"));
        defaultFormBuilder.append(this.psDir);
        defaultFormBuilder.append(jButton4);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Save sort order"));
        defaultFormBuilder.append((Component)this.saveAsConfiguredGlobally, 1);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.saveInOriginalOrder, 1);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.saveInSpecifiedOrder, 1);
        defaultFormBuilder.nextLine();
        FormLayout formLayout = new FormLayout("right:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout);
        JLabel jLabel = new JLabel(Globals.lang("Primary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.savePriSort);
        defaultFormBuilder2.append(this.savePriField);
        defaultFormBuilder2.append(this.savePriDesc);
        defaultFormBuilder2.nextLine();
        jLabel = new JLabel(Globals.lang("Secondary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.saveSecSort);
        defaultFormBuilder2.append(this.saveSecField);
        defaultFormBuilder2.append(this.saveSecDesc);
        defaultFormBuilder2.nextLine();
        jLabel = new JLabel(Globals.lang("Tertiary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.saveTerSort);
        defaultFormBuilder2.append(this.saveTerField);
        defaultFormBuilder2.append(this.saveTerDesc);
        JPanel jPanel = defaultFormBuilder2.getPanel();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Database protection"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.protect, 3);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesDialog.this.dispose();
            }
        };
        ActionMap actionMap = defaultFormBuilder.getPanel().getActionMap();
        InputMap inputMap = defaultFormBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesDialog.this.storeSettings();
                DatabasePropertiesDialog.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesDialog.this.dispose();
            }
        });
    }

    private void setupSortOrderConfiguration() {
        this.saveAsConfiguredGlobally = new JRadioButton(Globals.lang("Save entries as configured globally"));
        this.saveInOriginalOrder = new JRadioButton(Globals.lang("Save entries in their original order"));
        this.saveInSpecifiedOrder = new JRadioButton(Globals.lang("Save entries ordered as specified"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.saveAsConfiguredGlobally);
        buttonGroup.add(this.saveInOriginalOrder);
        buttonGroup.add(this.saveInSpecifiedOrder);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource() == DatabasePropertiesDialog.this.saveInSpecifiedOrder;
                DatabasePropertiesDialog.this.savePriSort.setEnabled(bl);
                DatabasePropertiesDialog.this.savePriField.setEnabled(bl);
                DatabasePropertiesDialog.this.savePriDesc.setEnabled(bl);
                DatabasePropertiesDialog.this.saveSecSort.setEnabled(bl);
                DatabasePropertiesDialog.this.saveSecField.setEnabled(bl);
                DatabasePropertiesDialog.this.saveSecDesc.setEnabled(bl);
                DatabasePropertiesDialog.this.saveTerSort.setEnabled(bl);
                DatabasePropertiesDialog.this.saveTerField.setEnabled(bl);
                DatabasePropertiesDialog.this.saveTerDesc.setEnabled(bl);
            }
        };
        this.saveAsConfiguredGlobally.addActionListener(actionListener);
        this.saveInOriginalOrder.addActionListener(actionListener);
        this.saveInSpecifiedOrder.addActionListener(actionListener);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(BibtexFields.getAllFieldNames()));
        arrayList.add("bibtexkey");
        Collections.sort(arrayList);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.savePriSort = new JComboBox<String>(stringArray);
        this.saveSecSort = new JComboBox<String>(stringArray);
        this.saveTerSort = new JComboBox<String>(stringArray);
        this.savePriSort.insertItemAt(Globals.lang("<select>"), 0);
        this.saveSecSort.insertItemAt(Globals.lang("<select>"), 0);
        this.saveTerSort.insertItemAt(Globals.lang("<select>"), 0);
        this.savePriField = new JTextField(10);
        this.saveSecField = new JTextField(10);
        this.saveTerField = new JTextField(10);
        this.savePriSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabasePropertiesDialog.this.savePriSort.getSelectedIndex() > 0) {
                    DatabasePropertiesDialog.this.savePriField.setText(DatabasePropertiesDialog.this.savePriSort.getSelectedItem().toString());
                    DatabasePropertiesDialog.this.savePriSort.setSelectedIndex(0);
                }
            }
        });
        this.saveSecSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabasePropertiesDialog.this.saveSecSort.getSelectedIndex() > 0) {
                    DatabasePropertiesDialog.this.saveSecField.setText(DatabasePropertiesDialog.this.saveSecSort.getSelectedItem().toString());
                    DatabasePropertiesDialog.this.saveSecSort.setSelectedIndex(0);
                }
            }
        });
        this.saveTerSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabasePropertiesDialog.this.saveTerSort.getSelectedIndex() > 0) {
                    DatabasePropertiesDialog.this.saveTerField.setText(DatabasePropertiesDialog.this.saveTerSort.getSelectedItem().toString());
                    DatabasePropertiesDialog.this.saveTerSort.setSelectedIndex(0);
                }
            }
        });
        this.savePriDesc = new JCheckBox(Globals.lang("Descending"));
        this.saveSecDesc = new JCheckBox(Globals.lang("Descending"));
        this.saveTerDesc = new JCheckBox(Globals.lang("Descending"));
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setValues();
        }
        super.setVisible(bl);
    }

    private void setValues() {
        Object object;
        boolean bl;
        this.encoding.setSelectedItem(this.panel.getEncoding());
        Vector<String> vector = this.metaData.getData(SAVE_ORDER_CONFIG);
        if (vector == null) {
            this.saveAsConfiguredGlobally.setSelected(true);
            this.oldSaveOrderConfig = null;
            bl = false;
        } else {
            object = new SaveOrderConfig(vector);
            this.oldSaveOrderConfig = object;
            if (((SaveOrderConfig)object).saveInOriginalOrder) {
                this.saveInOriginalOrder.setSelected(true);
                bl = false;
            } else {
                assert (((SaveOrderConfig)object).saveInSpecifiedOrder);
                this.saveInSpecifiedOrder.setSelected(true);
                bl = true;
            }
            this.savePriField.setText(((SaveOrderConfig)object).sortCriteria[0].field);
            this.savePriDesc.setSelected(((SaveOrderConfig)object).sortCriteria[0].descending);
            this.saveSecField.setText(((SaveOrderConfig)object).sortCriteria[1].field);
            this.saveSecDesc.setSelected(((SaveOrderConfig)object).sortCriteria[1].descending);
            this.saveTerField.setText(((SaveOrderConfig)object).sortCriteria[2].field);
            this.saveTerDesc.setSelected(((SaveOrderConfig)object).sortCriteria[2].descending);
        }
        this.savePriSort.setEnabled(bl);
        this.savePriField.setEnabled(bl);
        this.savePriDesc.setEnabled(bl);
        this.saveSecSort.setEnabled(bl);
        this.saveSecField.setEnabled(bl);
        this.saveSecDesc.setEnabled(bl);
        this.saveTerSort.setEnabled(bl);
        this.saveTerField.setEnabled(bl);
        this.saveTerDesc.setEnabled(bl);
        object = this.metaData.getData(Globals.prefs.get("userFileDir"));
        if (object == null) {
            this.fileDir.setText("");
        } else if (((Vector)object).size() >= 1) {
            this.fileDir.setText(((String)((Vector)object).get(0)).trim());
        }
        Vector<String> vector2 = this.metaData.getData(Globals.prefs.get("userFileDirIndividual"));
        Vector<String> vector3 = this.metaData.getData(Globals.prefs.get("userFileDirInd_Legacy"));
        if (vector2 == null) {
            this.oldFileIndvVal = this.fileDirIndv.getText();
            if (vector3 == null) {
                this.fileDirIndv.setText("");
            } else if (vector3.size() >= 1) {
                this.fileDirIndv.setText(vector3.get(0).trim());
            }
        } else {
            if (vector2.size() >= 1) {
                this.fileDirIndv.setText(vector2.get(0).trim());
            }
            this.oldFileIndvVal = this.fileDirIndv.getText();
        }
        Vector<String> vector4 = this.metaData.getData("pdfDirectory");
        if (vector4 == null) {
            this.pdfDir.setText("");
        } else if (vector4.size() >= 1) {
            this.pdfDir.setText(vector4.get(0).trim());
        }
        Vector<String> vector5 = this.metaData.getData("psDirectory");
        if (vector5 == null) {
            this.psDir.setText("");
        } else if (vector5.size() >= 1) {
            this.psDir.setText(vector5.get(0).trim());
        }
        Vector<String> vector6 = this.metaData.getData("protectedFlag");
        if (vector6 == null) {
            this.protect.setSelected(false);
        } else if (vector6.size() >= 1) {
            this.protect.setSelected(Boolean.parseBoolean(vector6.get(0)));
        }
        this.oldFileVal = this.fileDir.getText();
        this.oldPdfVal = this.pdfDir.getText();
        this.oldPsVal = this.psDir.getText();
        this.oldProtectVal = this.protect.isSelected();
    }

    private void storeSettings() {
        boolean bl;
        Object object;
        Object object2;
        SaveOrderConfig saveOrderConfig;
        if (this.saveAsConfiguredGlobally.isSelected()) {
            this.metaData.remove(SAVE_ORDER_CONFIG);
            saveOrderConfig = null;
        } else {
            object2 = new SaveOrderConfig();
            saveOrderConfig = object2;
            if (this.saveInOriginalOrder.isSelected()) {
                ((SaveOrderConfig)object2).setSaveInOriginalOrder();
            } else {
                ((SaveOrderConfig)object2).setSaveInSpecifiedOrder();
            }
            ((SaveOrderConfig)object2).sortCriteria[0].field = this.savePriField.getText();
            ((SaveOrderConfig)object2).sortCriteria[0].descending = this.savePriDesc.isSelected();
            ((SaveOrderConfig)object2).sortCriteria[1].field = this.saveSecField.getText();
            ((SaveOrderConfig)object2).sortCriteria[1].descending = this.saveSecDesc.isSelected();
            ((SaveOrderConfig)object2).sortCriteria[2].field = this.saveTerField.getText();
            ((SaveOrderConfig)object2).sortCriteria[2].descending = this.saveTerDesc.isSelected();
            object = ((SaveOrderConfig)object2).getVector();
            this.metaData.putData(SAVE_ORDER_CONFIG, (Vector<String>)object);
        }
        object2 = this.panel.getEncoding();
        object = (String)this.encoding.getSelectedItem();
        this.panel.setEncoding((String)object);
        Vector<String> vector = new Vector<String>(1);
        String string = this.fileDir.getText().trim();
        if (!string.isEmpty()) {
            vector.add(string);
            this.metaData.putData(Globals.prefs.get("userFileDir"), vector);
        } else {
            this.metaData.remove(Globals.prefs.get("userFileDir"));
        }
        vector = new Vector(1);
        string = this.fileDirIndv.getText().trim();
        if (!string.isEmpty()) {
            vector.add(string);
            this.metaData.putData(Globals.prefs.get("userFileDirIndividual"), vector);
        } else {
            this.metaData.remove(Globals.prefs.get("userFileDirIndividual"));
        }
        vector = new Vector(1);
        string = this.pdfDir.getText().trim();
        if (!string.isEmpty()) {
            vector.add(string);
            this.metaData.putData("pdfDirectory", vector);
        } else {
            this.metaData.remove("pdfDirectory");
        }
        vector = new Vector(1);
        string = this.psDir.getText().trim();
        if (!string.isEmpty()) {
            vector.add(string);
            this.metaData.putData("psDirectory", vector);
        } else {
            this.metaData.remove("psDirectory");
        }
        if (this.protect.isSelected()) {
            vector = new Vector(1);
            vector.add("true");
            this.metaData.putData("protectedFlag", vector);
        } else {
            this.metaData.remove("protectedFlag");
        }
        boolean bl2 = this.oldSaveOrderConfig == saveOrderConfig ? false : (this.oldSaveOrderConfig == null || saveOrderConfig == null ? true : !this.oldSaveOrderConfig.getVector().equals(saveOrderConfig.getVector()));
        boolean bl3 = bl = bl2 || !((String)object).equals(object2) || !this.oldFileVal.equals(this.fileDir.getText()) || !this.oldFileIndvVal.equals(this.fileDirIndv.getText()) || !this.oldPdfVal.equals(this.pdfDir.getText()) || !this.oldPsVal.equals(this.psDir.getText()) || this.oldProtectVal != this.protect.isSelected();
        if (bl) {
            this.panel.markNonUndoableBaseChanged();
        }
    }
}

