/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.OutputPrinter;

public class FetcherPreviewDialog
extends JDialog
implements OutputPrinter {
    private final EventList<TableEntry> entries = new BasicEventList<TableEntry>();
    private final JTable glTable;
    private boolean okPressed = false;
    private final JabRefFrame frame;
    private final int warningLimit;

    public FetcherPreviewDialog(JabRefFrame jabRefFrame, int n, int n2) {
        super(jabRefFrame, Globals.lang("Title"), true);
        this.frame = jabRefFrame;
        this.warningLimit = n;
        JButton jButton = new JButton(Globals.lang("Ok"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FetcherPreviewDialog.this.verifySelection()) {
                    FetcherPreviewDialog.this.okPressed = true;
                    FetcherPreviewDialog.this.dispose();
                }
            }
        });
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FetcherPreviewDialog.this.okPressed = false;
                FetcherPreviewDialog.this.dispose();
            }
        });
        JButton jButton3 = new JButton(Globals.lang("Select all"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FetcherPreviewDialog.this.setSelectionAll(true);
            }
        });
        JButton jButton4 = new JButton(Globals.lang("Deselect all"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FetcherPreviewDialog.this.setSelectionAll(false);
            }
        });
        EventTableModel<TableEntry> eventTableModel = new EventTableModel<TableEntry>(this.entries, new EntryTableFormat());
        this.glTable = new EntryTable(eventTableModel);
        this.glTable.setRowHeight(n2);
        this.glTable.getColumnModel().getColumn(0).setMaxWidth(45);
        this.glTable.setPreferredScrollableViewportSize(new Dimension(1100, 600));
        EventSelectionModel<TableEntry> eventSelectionModel = new EventSelectionModel<TableEntry>(this.entries);
        this.glTable.setSelectionModel(eventSelectionModel);
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButton((JComponent)jButton3);
        buttonStackBuilder.addButton((JComponent)jButton4);
        buttonStackBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.glTable), "Center");
        jPanel.add((Component)buttonStackBuilder.getPanel(), "West");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FetcherPreviewDialog.this.dispose();
            }
        };
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.pack();
    }

    private boolean verifySelection() {
        int n = 0;
        for (TableEntry tableEntry : this.entries) {
            if (!tableEntry.isWanted()) continue;
            ++n;
        }
        if (n > this.warningLimit) {
            int n2 = JOptionPane.showConfirmDialog(this, Globals.lang("You have selected more than %0 entries for download. Some web sites might block you if you make too many rapid downloads. Do you want to continue?", String.valueOf(this.warningLimit)), Globals.lang("Confirm selection"), 0, 2);
            return n2 == 0;
        }
        return true;
    }

    public Map<String, Boolean> getSelection() {
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        for (TableEntry tableEntry : this.entries) {
            linkedHashMap.put(tableEntry.id, tableEntry.isWanted());
        }
        return linkedHashMap;
    }

    public void addEntry(String string, JLabel jLabel) {
        TableEntry tableEntry = new TableEntry(string, jLabel);
        this.entries.getReadWriteLock().writeLock().lock();
        this.entries.add(tableEntry);
        this.entries.getReadWriteLock().writeLock().unlock();
        this.glTable.repaint();
    }

    private void setSelectionAll(boolean bl) {
        for (int i = 0; i < this.glTable.getRowCount(); ++i) {
            this.glTable.setValueAt(bl, i, 0);
        }
        this.glTable.repaint();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    @Override
    public void setStatus(String string) {
        this.frame.setStatus(string);
    }

    @Override
    public void showMessage(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this, object, string, n);
    }

    @Override
    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private static class EntryTableFormat
    implements TableFormat<TableEntry> {
        private EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Globals.lang("Keep");
            }
            return Globals.lang("Preview");
        }

        @Override
        public Object getColumnValue(TableEntry tableEntry, int n) {
            if (n == 0) {
                return tableEntry.isWanted() ? Boolean.TRUE : Boolean.FALSE;
            }
            return tableEntry.getPreview();
        }
    }

    class EntryTable
    extends JTable {
        final PreviewRenderer renderer;

        public EntryTable(TableModel tableModel) {
            super(tableModel);
            this.renderer = new PreviewRenderer();
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return n2 == 0 ? this.getDefaultRenderer(Boolean.class) : this.renderer;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return JLabel.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            FetcherPreviewDialog.this.entries.getReadWriteLock().writeLock().lock();
            TableEntry tableEntry = (TableEntry)FetcherPreviewDialog.this.entries.get(n);
            tableEntry.setWanted((Boolean)object);
            FetcherPreviewDialog.this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    static class PreviewRenderer
    implements TableCellRenderer {
        final JLabel label = new JLabel();

        PreviewRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)object;
            this.label.setText(jLabel.getText());
            return this.label;
        }
    }

    static class TableEntry {
        private final String id;
        private final JLabel preview;
        private boolean wanted = false;

        public TableEntry(String string, JLabel jLabel) {
            this.id = string;
            this.preview = jLabel;
        }

        public boolean isWanted() {
            return this.wanted;
        }

        public void setWanted(boolean bl) {
            this.wanted = bl;
        }

        public JLabel getPreview() {
            return this.preview;
        }
    }
}

