/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.util.Util;

class FieldSetComponent
extends JPanel
implements ActionListener {
    private final Set<ActionListener> additionListeners = new HashSet<ActionListener>();
    final JList list;
    private JScrollPane sp = null;
    DefaultListModel listModel;
    private JComboBox sel;
    private JTextField input;
    private final JButton add;
    final JButton remove;
    private JButton up = null;
    private JButton down = null;
    final GridBagLayout gbl = new GridBagLayout();
    final GridBagConstraints con = new GridBagConstraints();
    final boolean forceLowerCase;
    boolean changesMade = false;
    private final Set<ListDataListener> modelListeners = new HashSet<ListDataListener>();

    public FieldSetComponent(String string, List<String> list, List<String> list2, boolean bl, boolean bl2) {
        this(string, list, list2, "Add", "Remove", bl, bl2);
    }

    FieldSetComponent(String string, List<String> list, boolean bl, boolean bl2) {
        this(string, list, null, "Add", "Remove", bl, bl2);
    }

    private FieldSetComponent(String string, List<String> list, List<String> list2, String string2, String string3, boolean bl, boolean bl2) {
        this.forceLowerCase = bl2;
        this.add = new JButton(Globals.lang(string2));
        this.remove = new JButton(Globals.lang(string3));
        this.listModel = new DefaultListModel();
        JLabel jLabel = null;
        if (string != null) {
            jLabel = new JLabel(string);
        }
        for (String string4 : list) {
            this.listModel.addElement(string4);
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.setLayout(this.gbl);
        this.con.insets = new Insets(1, 1, 1, 1);
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        if (jLabel != null) {
            this.gbl.setConstraints(jLabel, this.con);
            this.add(jLabel);
        }
        this.con.weighty = 1.0;
        this.sp = new JScrollPane(this.list, 20, 31);
        this.gbl.setConstraints(this.sp, this.con);
        this.add(this.sp);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        if (bl) {
            this.con.weightx = 0.0;
            this.up = new JButton(GUIGlobals.getImage("up"));
            this.down = new JButton(GUIGlobals.getImage("down"));
            this.up.addActionListener(this);
            this.down.addActionListener(this);
            this.up.setToolTipText(Globals.lang("Move up"));
            this.down.setToolTipText(Globals.lang("Move down"));
            this.gbl.setConstraints(this.up, this.con);
            this.add(this.up);
            this.gbl.setConstraints(this.down, this.con);
            this.add(this.down);
            this.con.weightx = 0.0;
        }
        Component component = Box.createHorizontalStrut(5);
        this.gbl.setConstraints(component, this.con);
        this.add(component);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.remove, this.con);
        this.add(this.remove);
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        if (list2 != null) {
            this.sel = new JComboBox<String>(list2.toArray(new String[list2.size()]));
            this.sel.setEditable(true);
            this.gbl.setConstraints(this.sel, this.con);
            this.add(this.sel);
        } else {
            this.input = new JTextField(20);
            this.input.addActionListener(this);
            this.gbl.setConstraints(this.input, this.con);
            this.add(this.input);
        }
        this.con.gridwidth = 0;
        this.con.weighty = 0.0;
        this.con.weightx = 0.5;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.add, this.con);
        this.add(this.add);
    }

    public void setListSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public void selectField(String string) {
        int n = this.listModel.indexOf(string);
        if (n >= 0) {
            this.list.setSelectedIndex(n);
        }
        JViewport jViewport = this.sp.getViewport();
        jViewport.scrollRectToVisible(this.list.getCellBounds(n, n));
    }

    public String getFirstSelected() {
        Object e = this.list.getSelectedValue();
        if (e == null) {
            return null;
        }
        return (String)e;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.input != null) {
            this.input.setEnabled(bl);
        }
        if (this.sel != null) {
            this.sel.setEnabled(bl);
        }
        if (this.up != null) {
            this.up.setEnabled(bl);
            this.down.setEnabled(bl);
        }
        this.add.setEnabled(bl);
        this.remove.setEnabled(bl);
    }

    public void setFields(List<String> list) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String object : list) {
            defaultListModel.addElement(object);
        }
        this.listModel = defaultListModel;
        for (ListDataListener listDataListener : this.modelListeners) {
            defaultListModel.addListDataListener(listDataListener);
        }
        this.list.setModel(defaultListModel);
    }

    void addField(String string) {
        string = string.trim();
        if (this.forceLowerCase) {
            string = string.toLowerCase();
        }
        if (string.equals("") || this.listModel.contains(string)) {
            return;
        }
        String string2 = Util.checkLegalKey(string);
        if (!string2.equals(string) || string.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Globals.lang("Field names are not allowed to contain white space or the following characters") + ": # { } ~ , ^ &", Globals.lang("Error"), 0);
            return;
        }
        this.addFieldUncritically(string);
    }

    void addFieldUncritically(String string) {
        this.listModel.addElement(string);
        this.changesMade = true;
        for (ActionListener actionListener : this.additionListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 0, string));
        }
    }

    void removeSelected() {
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.listModel.removeElementAt(nArray[nArray.length - 1 - i]);
        }
    }

    public void activate() {
        this.sel.requestFocus();
    }

    public boolean changesMade() {
        return this.changesMade;
    }

    public List<String> getFields() {
        ArrayList<String> arrayList = new ArrayList<String>(this.listModel.getSize());
        Enumeration enumeration = this.listModel.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        return arrayList;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public void addAdditionActionListener(ActionListener actionListener) {
        this.additionListeners.add(actionListener);
    }

    public void removeAdditionActionListener(ActionListener actionListener) {
        this.additionListeners.remove(actionListener);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listModel.addListDataListener(listDataListener);
        this.modelListeners.add(listDataListener);
    }

    private void move(int n) {
        int n2 = this.list.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        String string = (String)this.listModel.get(n2);
        int n3 = Math.max(0, Math.min(this.listModel.size() - 1, n2 + n));
        this.listModel.remove(n2);
        this.listModel.add(n3, string);
        this.list.setSelectedIndex(n3);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.add) {
            if (this.sel != null && this.sel.getSelectedItem() != null) {
                String string = this.sel.getSelectedItem().toString();
                this.addField(string);
            } else if (this.input != null && !this.input.getText().equals("")) {
                this.addField(this.input.getText());
            }
        } else if (object == this.input) {
            this.addField(this.input.getText());
        } else if (object == this.remove) {
            this.removeSelected();
        } else if (object == this.sel) {
            if (actionEvent.getActionCommand().equals("comboBoxChanged") && actionEvent.getModifiers() == 0) {
                return;
            }
            String string = this.sel.getSelectedItem().toString();
            this.addField(string);
            this.sel.getEditor().selectAll();
        } else if (object == this.up) {
            this.move(-1);
        } else if (object == this.down) {
            this.move(1);
        }
    }
}

