/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import net.sf.jabref.Globals;
import net.sf.jabref.OpenFileFilter;

public class FileDialogs {
    public static String[] getMultipleFiles(JFrame jFrame, File file, String string, boolean bl) {
        OpenFileFilter openFileFilter = null;
        if (string == null) {
            openFileFilter = new OpenFileFilter();
        } else if (!string.equals("_non__")) {
            openFileFilter = new OpenFileFilter(string);
        }
        Object object = FileDialogs.getNewFileImpl(jFrame, file, string, null, openFileFilter, 0, bl, false, true, null);
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object != null) {
            return new String[]{(String)object};
        }
        return new String[0];
    }

    public static String getNewFile(JFrame jFrame, File file, String string, int n, boolean bl) {
        return FileDialogs.getNewFile(jFrame, file, string, null, n, bl, false, null);
    }

    public static String getNewFile(JFrame jFrame, File file, String string, int n, boolean bl, JComponent jComponent) {
        return FileDialogs.getNewFile(jFrame, file, string, null, n, bl, false, jComponent);
    }

    public static String getNewFile(JFrame jFrame, File file, String string, String string2, int n, boolean bl) {
        return FileDialogs.getNewFile(jFrame, file, string, string2, n, bl, false, null);
    }

    public static String getNewDir(JFrame jFrame, File file, String string, int n, boolean bl) {
        return FileDialogs.getNewFile(jFrame, file, string, null, n, bl, true, null);
    }

    public static String getNewDir(JFrame jFrame, File file, String string, String string2, int n, boolean bl) {
        return FileDialogs.getNewFile(jFrame, file, string, string2, n, bl, true, null);
    }

    private static String getNewFile(JFrame jFrame, File file, String string, String string2, int n, boolean bl, boolean bl2, JComponent jComponent) {
        OpenFileFilter openFileFilter = null;
        if (string == null) {
            openFileFilter = new OpenFileFilter();
        } else if (!string.equals("_non__")) {
            openFileFilter = new OpenFileFilter(string);
        }
        return (String)FileDialogs.getNewFileImpl(jFrame, file, string, string2, openFileFilter, n, bl, bl2, false, jComponent);
    }

    private static Object getNewFileImpl(JFrame jFrame, File file, String string, String string2, OpenFileFilter openFileFilter, int n, boolean bl, boolean bl2, boolean bl3, JComponent jComponent) {
        JFileChooser jFileChooser;
        if (!bl2 && Globals.prefs.getBoolean("useNativeFileDialogOnMac")) {
            return FileDialogs.getNewFileForMac(jFrame, file, string, n, bl, bl2, openFileFilter);
        }
        try {
            jFileChooser = new JFileChooser(file);
            if (jComponent != null) {
                jFileChooser.setAccessory(jComponent);
            }
        }
        catch (InternalError internalError) {
            return FileDialogs.getNewFileForMac(jFrame, file, string, n, bl, bl2, openFileFilter);
        }
        if (bl2) {
            jFileChooser.setFileSelectionMode(1);
        }
        jFileChooser.setMultiSelectionEnabled(bl3);
        jFileChooser.addChoosableFileFilter(openFileFilter);
        jFileChooser.setDialogType(n);
        int n2 = n == 0 ? jFileChooser.showOpenDialog(jFrame) : (n == 1 ? jFileChooser.showSaveDialog(jFrame) : jFileChooser.showDialog(jFrame, string2));
        if (n2 != 0) {
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            return null;
        }
        if (string != null && n == 1 && jFileChooser.getFileFilter() == openFileFilter && !openFileFilter.accept(file2)) {
            file2 = new File(file2.getPath() + string.split("[, ]+", 0)[0]);
        }
        if (bl) {
            Globals.prefs.put("workingDirectory", file2.getPath());
        }
        if (!bl3) {
            return file2.getAbsolutePath();
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getAbsolutePath();
        }
        return stringArray;
    }

    private static String getNewFileForMac(JFrame jFrame, File file, String string, int n, boolean bl, boolean bl2, FilenameFilter filenameFilter) {
        FileDialog fileDialog = new FileDialog(jFrame);
        if (file != null) {
            fileDialog.setDirectory(file.getParent());
        }
        if (n == 0) {
            fileDialog.setMode(0);
        } else {
            fileDialog.setMode(1);
        }
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            if (bl) {
                Globals.prefs.put("workingDirectory", fileDialog.getDirectory() + fileDialog.getFile());
            }
            return fileDialog.getDirectory() + fileDialog.getFile();
        }
        return null;
    }
}

