/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditListener;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.DownloadExternalFile;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.MoveFileAction;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.FileListEditorTransferHandler;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileListEditor
extends JTable
implements FieldEditor,
DownloadExternalFile.DownloadCallback {
    private static final Log LOGGER = LogFactory.getLog(FileListEditor.class);
    private final FieldNameLabel label;
    private FileListEntryEditor editor = null;
    private final JabRefFrame frame;
    private final MetaData metaData;
    private final String fieldName;
    private final EntryEditor entryEditor;
    private final JPanel panel;
    private final FileListTableModel tableModel;
    private final JButton auto;
    private final JPopupMenu menu = new JPopupMenu();

    public FileListEditor(JabRefFrame jabRefFrame, MetaData metaData, String string, String string2, EntryEditor entryEditor) {
        this.frame = jabRefFrame;
        this.metaData = metaData;
        this.fieldName = string;
        this.entryEditor = entryEditor;
        this.label = new FieldNameLabel(" " + StringUtil.nCase(string) + " ");
        this.tableModel = new FileListTableModel();
        this.setText(string2);
        this.setModel(this.tableModel);
        JScrollPane jScrollPane = new JScrollPane(this);
        this.setTableHeader(null);
        this.addMouseListener(new TableClickListener());
        JButton jButton = new JButton(GUIGlobals.getImage("add"));
        jButton.setToolTipText(Globals.lang("New file link (INSERT)"));
        JButton jButton2 = new JButton(GUIGlobals.getImage("remove"));
        jButton2.setToolTipText(Globals.lang("Remove file link (DELETE)"));
        JButton jButton3 = new JButton(GUIGlobals.getImage("up"));
        JButton jButton4 = new JButton(GUIGlobals.getImage("down"));
        this.auto = new JButton(Globals.lang("Auto"));
        JButton jButton5 = new JButton(Globals.lang("Download"));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.addEntry();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.removeEntries();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.moveEntry(-1);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.moveEntry(1);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.autoSetLinks();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.downloadFile();
            }
        });
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref,1dlu,fill:pref,1dlu,fill:pref", "fill:pref,fill:pref"));
        defaultFormBuilder.append(jButton3);
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.append(this.auto);
        defaultFormBuilder.append(jButton4);
        defaultFormBuilder.append(jButton2);
        defaultFormBuilder.append(jButton5);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)jScrollPane, "Center");
        this.panel.add((Component)defaultFormBuilder.getPanel(), "East");
        FileListEditorTransferHandler fileListEditorTransferHandler = new FileListEditorTransferHandler(jabRefFrame, entryEditor, null);
        this.setTransferHandler(fileListEditorTransferHandler);
        this.panel.setTransferHandler(fileListEditorTransferHandler);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileListEditor.this.getSelectedRow();
                FileListEditor.this.removeEntries();
                n = Math.min(n, FileListEditor.this.getRowCount() - 1);
                if (n >= 0) {
                    FileListEditor.this.setRowSelectionInterval(n, n);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "insert");
        this.getActionMap().put("insert", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.addEntry();
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("File list editor, move entry up"), "move up");
        this.getActionMap().put("move up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.moveEntry(-1);
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("File list editor, move entry down"), "move down");
        this.getActionMap().put("move down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.moveEntry(1);
            }
        });
        JMenuItem jMenuItem = new JMenuItem(Globals.lang("Open"));
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.openSelectedFile();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Globals.lang("Open folder"));
        this.menu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileListEditor.this.getSelectedRow();
                if (n >= 0) {
                    FileListEntry fileListEntry = FileListEditor.this.tableModel.getEntry(n);
                    try {
                        Util.openFolderAndSelectFile(fileListEntry.getLink());
                    }
                    catch (IOException iOException) {
                        LOGGER.debug("Cannot open folder", iOException);
                    }
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(Globals.lang("Move/Rename file"));
        this.menu.add(jMenuItem3);
        jMenuItem3.addActionListener(new MoveFileAction(jabRefFrame, entryEditor, this, false));
        JMenuItem jMenuItem4 = new JMenuItem(Globals.lang("Move to file directory"));
        this.menu.add(jMenuItem4);
        jMenuItem4.addActionListener(new MoveFileAction(jabRefFrame, entryEditor, this, true));
    }

    private void openSelectedFile() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            FileListEntry fileListEntry = this.tableModel.getEntry(n);
            try {
                ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeByName(fileListEntry.getType().getName());
                Util.openExternalFileAnyFormat(this.metaData, fileListEntry.getLink(), externalFileType != null ? externalFileType : fileListEntry.getType());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public FileListTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JComponent getPane() {
        return this.panel;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    @Override
    public String getText() {
        return this.tableModel.getStringRepresentation();
    }

    @Override
    public void setText(String string) {
        this.tableModel.setContent(string);
    }

    @Override
    public void append(String string) {
    }

    @Override
    public void updateFont() {
    }

    @Override
    public void paste(String string) {
    }

    @Override
    public String getSelectedText() {
        return null;
    }

    private void addEntry(String string) {
        FileListEntry fileListEntry;
        int n = this.getSelectedRow();
        if (n == -1) {
            n = 0;
        }
        if (this.editListEntry(fileListEntry = new FileListEntry("", string, null), true)) {
            this.tableModel.addEntry(n, fileListEntry);
        }
        this.entryEditor.updateField(this);
    }

    private void addEntry() {
        this.addEntry("");
    }

    private void removeEntries() {
        int[] nArray = this.getSelectedRows();
        if (nArray != null) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.tableModel.removeEntry(nArray[i]);
            }
        }
        this.entryEditor.updateField(this);
    }

    private void moveEntry(int n) {
        int[] nArray = this.getSelectedRows();
        if (nArray.length != 1 || this.tableModel.getRowCount() < 2) {
            return;
        }
        int n2 = nArray[0] + n;
        if (n2 >= this.tableModel.getRowCount()) {
            n2 -= this.tableModel.getRowCount();
        }
        if (n2 < 0) {
            n2 += this.tableModel.getRowCount();
        }
        FileListEntry fileListEntry = this.tableModel.getEntry(nArray[0]);
        this.tableModel.removeEntry(nArray[0]);
        this.tableModel.addEntry(n2, fileListEntry);
        this.entryEditor.updateField(this);
        this.setRowSelectionInterval(n2, n2);
    }

    private boolean editListEntry(FileListEntry fileListEntry, boolean bl) {
        if (this.editor == null) {
            this.editor = new FileListEntryEditor(this.frame, fileListEntry, false, true, this.metaData);
        } else {
            this.editor.setEntry(fileListEntry);
        }
        this.editor.setVisible(true, bl);
        if (this.editor.okPressed()) {
            this.tableModel.fireTableDataChanged();
        }
        this.entryEditor.updateField(this);
        return this.editor.okPressed();
    }

    public void autoSetLinks() {
        this.auto.setEnabled(false);
        BibtexEntry bibtexEntry = this.entryEditor.getEntry();
        JDialog jDialog = new JDialog((Frame)this.frame, true);
        JabRefExecutorService.INSTANCE.execute(Util.autoSetLinks(bibtexEntry, this.tableModel, this.metaData, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEditor.this.auto.setEnabled(true);
                if (actionEvent.getID() > 0) {
                    FileListEditor.this.entryEditor.updateField(FileListEditor.this);
                    FileListEditor.this.frame.output(Globals.lang("Finished autosetting external links."));
                } else {
                    FileListEditor.this.frame.output(Globals.lang("Finished autosetting external links.") + " " + Globals.lang("No files found."));
                }
            }
        }, jDialog));
    }

    private void downloadFile() {
        int n;
        String string = this.entryEditor.getEntry().getCiteKey();
        if (string == null && (n = JOptionPane.showConfirmDialog(this.frame, Globals.lang("This entry has no BibTeX key. Generate key now?"), Globals.lang("Download file"), 2, 3)) == 0) {
            EntryEditor.GenerateKeyAction generateKeyAction = this.entryEditor.generateKeyAction;
            generateKeyAction.actionPerformed(null);
            string = this.entryEditor.getEntry().getCiteKey();
        }
        DownloadExternalFile downloadExternalFile = new DownloadExternalFile(this.frame, this.frame.basePanel().metaData(), string);
        try {
            downloadExternalFile.download(this);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void downloadComplete(FileListEntry fileListEntry) {
        this.tableModel.addEntry(this.tableModel.getRowCount(), fileListEntry);
        this.entryEditor.updateField(this);
    }

    @Override
    public boolean hasUndoInformation() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean hasRedoInformation() {
        return false;
    }

    @Override
    public void redo() {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener autoCompleteListener) {
    }

    @Override
    public void clearAutoCompleteSuggestion() {
    }

    @Override
    public void setActiveBackgroundColor() {
    }

    @Override
    public void setValidBackgroundColor() {
    }

    @Override
    public void setInvalidBackgroundColor() {
    }

    @Override
    public void updateFontColor() {
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                int n = FileListEditor.this.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    FileListEntry fileListEntry = FileListEditor.this.tableModel.getEntry(n);
                    FileListEditor.this.editListEntry(fileListEntry, false);
                }
            } else if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        private void processPopupTrigger(MouseEvent mouseEvent) {
            int n = FileListEditor.this.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0) {
                FileListEditor.this.setRowSelectionInterval(n, n);
                FileListEditor.this.menu.show(FileListEditor.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

