/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.util.Util;

public class FileListTableModel
extends AbstractTableModel {
    private final ArrayList<FileListEntry> list = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.size();
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public Class<String> getColumnClass(int n) {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            FileListEntry fileListEntry = this.list.get(n);
            switch (n2) {
                case 0: {
                    return fileListEntry.getDescription();
                }
                case 1: {
                    return fileListEntry.getLink();
                }
            }
            return fileListEntry.getType() != null ? fileListEntry.getType().getName() : "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListEntry getEntry(int n) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(int n) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            this.list.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(final int n, FileListEntry fileListEntry) {
        ArrayList<FileListEntry> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(n, fileListEntry);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileListTableModel.this.fireTableRowsInserted(n, n);
                    }
                });
            } else {
                this.fireTableRowsInserted(n, n);
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public void setContent(String string) {
        this.setContent(string, false, true);
    }

    public void setContentDontGuessTypes(String string) {
        this.setContent(string, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileListEntry setContent(String string, boolean bl, boolean bl2) {
        if (string == null) {
            string = "";
        }
        ArrayList<FileListEntry> arrayList = new ArrayList<FileListEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl4 && c == '\\') {
                bl4 = true;
                continue;
            }
            if (!bl4 && c == '&' && !bl3) {
                stringBuilder.append(c);
                if (string.length() > i + 1 && string.charAt(i + 1) == '#') {
                    bl3 = true;
                }
            } else if (!bl4 && bl3 && c == ';') {
                stringBuilder.append(c);
                bl3 = false;
            } else if (!bl4 && c == ':') {
                arrayList2.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            } else if (!bl4 && c == ';' && !bl3) {
                arrayList2.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                if (bl) {
                    return this.decodeEntry(arrayList2, bl2);
                }
                arrayList.add(this.decodeEntry(arrayList2, bl2));
                arrayList2.clear();
            } else {
                stringBuilder.append(c);
            }
            bl4 = false;
        }
        if (stringBuilder.length() > 0) {
            arrayList2.add(stringBuilder.toString());
        }
        if (!arrayList2.isEmpty()) {
            if (bl) {
                return this.decodeEntry(arrayList2, bl2);
            }
            arrayList.add(this.decodeEntry(arrayList2, bl2));
        }
        ArrayList<FileListEntry> arrayList3 = this.list;
        synchronized (arrayList3) {
            this.list.clear();
            this.list.addAll(arrayList);
        }
        this.fireTableChanged(new TableModelEvent(this));
        return null;
    }

    public static JLabel getFirstLabel(String string) {
        FileListTableModel fileListTableModel = new FileListTableModel();
        FileListEntry fileListEntry = fileListTableModel.setContent(string, true, true);
        if (fileListEntry == null || fileListEntry.getType() == null) {
            return null;
        }
        return fileListEntry.getType().getIconLabel();
    }

    private FileListEntry decodeEntry(ArrayList<String> arrayList, boolean bl) {
        ExternalFileType externalFileType = Globals.prefs.getExternalFileTypeByName(this.getElementIfAvailable(arrayList, 2));
        if (bl && externalFileType instanceof UnknownExternalFileType && (externalFileType = Globals.prefs.getExternalFileTypeByMimeType(this.getElementIfAvailable(arrayList, 2))) == null) {
            ExternalFileType externalFileType2 = null;
            String string = this.getElementIfAvailable(arrayList, 1);
            int n = string.lastIndexOf(46);
            if (n >= 0 && n < string.length() - 1) {
                String string2 = string.substring(n + 1);
                externalFileType2 = Globals.prefs.getExternalFileTypeByExt(string2);
            }
            if (externalFileType2 != null) {
                externalFileType = externalFileType2;
            }
        }
        return new FileListEntry(this.getElementIfAvailable(arrayList, 0), this.getElementIfAvailable(arrayList, 1), externalFileType);
    }

    private String getElementIfAvailable(ArrayList<String> arrayList, int n) {
        if (n < arrayList.size()) {
            return arrayList.get(n);
        }
        return "";
    }

    public String getStringRepresentation() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<FileListEntry> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            FileListEntry fileListEntry = iterator.next();
            stringBuilder.append(this.encodeEntry(fileListEntry));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getToolTipHTMLRepresentation() {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        Iterator<FileListEntry> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            FileListEntry fileListEntry = iterator.next();
            stringBuilder.append(fileListEntry.getDescription()).append(" (").append(fileListEntry.getLink()).append(')');
            if (!iterator.hasNext()) continue;
            stringBuilder.append("<br>");
        }
        return stringBuilder.append("</html>").toString();
    }

    private String encodeEntry(FileListEntry fileListEntry) {
        String string = fileListEntry.getType() != null ? fileListEntry.getType().getName() : "";
        return Util.encodeString(fileListEntry.getDescription()) + ':' + Util.encodeString(fileListEntry.getLink()) + ':' + Util.encodeString(string);
    }

    public void print() {
        System.out.println("----");
        for (FileListEntry fileListEntry : this.list) {
            System.out.println(fileListEntry);
        }
        System.out.println("----");
    }
}

