/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.GroupTreeCellRenderer;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.RemoveFromGroupAction;
import net.sf.jabref.groups.structure.AbstractGroup;

public class GroupAddRemoveDialog
implements BaseAction {
    private final BasePanel panel;
    private final boolean add;
    private boolean move = false;
    private BibtexEntry[] selection = null;
    private JTree tree;
    private JButton ok;

    public GroupAddRemoveDialog(BasePanel basePanel, boolean bl, boolean bl2) {
        this.panel = basePanel;
        this.add = bl;
        this.move = bl2;
    }

    @Override
    public void action() throws Throwable {
        GroupTreeNode groupTreeNode = this.panel.metaData().getGroups();
        if (groupTreeNode == null) {
            return;
        }
        this.selection = this.panel.getSelectedEntries();
        final JDialog jDialog = new JDialog(this.panel.frame(), Globals.lang(this.add ? (this.move ? "Move to group" : "Add to group") : "Remove from group"), true);
        this.ok = new JButton(Globals.lang("Ok"));
        JButton jButton = new JButton(Globals.lang("Cancel"));
        this.tree = new JTree(groupTreeNode);
        this.tree.setCellRenderer(new AddRemoveGroupTreeCellRenderer());
        this.tree.setVisibleRowCount(22);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new SelectionListener());
        JButton jButton2 = new JButton("Expand All");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupAddRemoveDialog.this.expandAll(GroupAddRemoveDialog.this.tree, true);
            }
        });
        JButton jButton3 = new JButton("Collapse All");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupAddRemoveDialog.this.expandAll(GroupAddRemoveDialog.this.tree, false);
            }
        });
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addButton((JComponent)jButton3);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GroupAddRemoveDialog.this.doAddOrRemove()) {
                    jDialog.dispose();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        this.ok.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        ActionMap actionMap = jScrollPane.getActionMap();
        InputMap inputMap = jScrollPane.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add((Component)jScrollPane, "Center");
        jDialog.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(this.panel.frame());
        jDialog.setVisible(true);
    }

    private void expandAll(final JTree jTree, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
                GroupAddRemoveDialog.this.expandAll(jTree, new TreePath(((DefaultTreeModel)jTree.getModel()).getPathToRoot(treeNode)), bl);
                jTree.requestFocusInWindow();
            }
        });
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    private boolean doAddOrRemove() {
        GroupTreeNode groupTreeNode = (GroupTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        if (this.checkGroupEnable(abstractGroup)) {
            if (this.add) {
                AddToGroupAction addToGroupAction = new AddToGroupAction(groupTreeNode, this.move, this.panel);
                addToGroupAction.actionPerformed(new ActionEvent(groupTreeNode, 0, "add"));
            } else {
                RemoveFromGroupAction removeFromGroupAction = new RemoveFromGroupAction(groupTreeNode, this.panel);
                removeFromGroupAction.actionPerformed(new ActionEvent(groupTreeNode, 0, "remove"));
            }
            return true;
        }
        return false;
    }

    private boolean checkGroupEnable(AbstractGroup abstractGroup) {
        return this.add ? abstractGroup.supportsAdd() && !abstractGroup.containsAll(this.selection) : abstractGroup.supportsRemove() && abstractGroup.containsAny(this.selection);
    }

    class AddRemoveGroupTreeCellRenderer
    extends GroupTreeCellRenderer {
        AddRemoveGroupTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            GroupTreeNode groupTreeNode = (GroupTreeNode)object;
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            if (GroupAddRemoveDialog.this.checkGroupEnable(abstractGroup)) {
                component.setForeground(Color.black);
            } else {
                component.setForeground(Color.gray);
            }
            return component;
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            GroupTreeNode groupTreeNode = (GroupTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            GroupAddRemoveDialog.this.ok.setEnabled(GroupAddRemoveDialog.this.checkGroupEnable(abstractGroup));
        }
    }
}

