/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.EntryMarker;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.gui.FirstColumnComparator;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.gui.IsMarkedComparator;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.gui.PersistenceTableColumnListener;
import net.sf.jabref.gui.PreventDraggingJTableHeader;
import net.sf.jabref.gui.RankingFieldComparator;
import net.sf.jabref.search.HitOrMissComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final MainTableFormat tableFormat;
    private final BasePanel panel;
    private final SortedList<BibtexEntry> sortedForMarking;
    private final SortedList<BibtexEntry> sortedForTable;
    private final SortedList<BibtexEntry> sortedForSearch;
    private final SortedList<BibtexEntry> sortedForGrouping;
    private final boolean tableColorCodes;
    private boolean showingFloatSearch = false;
    private boolean showingFloatGrouping = false;
    private final EventSelectionModel<BibtexEntry> selectionModel;
    private final TableComparatorChooser<BibtexEntry> comparatorChooser;
    private final JScrollPane pane;
    private Comparator<BibtexEntry> searchComparator;
    private Comparator<BibtexEntry> groupComparator;
    private final Comparator<BibtexEntry> markingComparator = new IsMarkedComparator();
    private Matcher<BibtexEntry> searchMatcher;
    private Matcher<BibtexEntry> groupMatcher;
    private final PersistenceTableColumnListener tableColumnListener;
    private static final int REQUIRED = 1;
    private static final int OPTIONAL = 2;
    public static final int REQ_STRING = 1;
    public static final int REQ_NUMBER = 2;
    public static final int OPT_STRING = 3;
    private static final int OTHER = 3;
    private static final int BOOLEAN = 4;
    public static final int ICON_COL = 8;
    private static final Log LOGGER = LogFactory.getLog(MainTable.class);
    private static GeneralRenderer defRenderer;
    private static GeneralRenderer reqRenderer;
    private static GeneralRenderer optRenderer;
    private static GeneralRenderer grayedOutRenderer;
    private static GeneralRenderer veryGrayedOutRenderer;
    private static GeneralRenderer[] markedRenderers;
    private static IncompleteRenderer incRenderer;
    private static CompleteRenderer compRenderer;
    private static CompleteRenderer grayedOutNumberRenderer;
    private static CompleteRenderer veryGrayedOutNumberRenderer;
    private static CompleteRenderer[] markedNumberRenderers;

    public MainTable(MainTableFormat mainTableFormat, EventList<BibtexEntry> eventList, JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.addFocusListener(Globals.focusListener);
        this.setAutoResizeMode(Globals.prefs.getInt("autoResizeMode"));
        this.tableFormat = mainTableFormat;
        this.panel = basePanel;
        this.sortedForTable = new SortedList<BibtexEntry>(eventList, null);
        this.sortedForMarking = new SortedList<BibtexEntry>(this.sortedForTable, null);
        this.sortedForSearch = new SortedList<BibtexEntry>(this.sortedForMarking, null);
        this.sortedForGrouping = new SortedList<BibtexEntry>(this.sortedForSearch, null);
        this.searchMatcher = null;
        this.groupMatcher = null;
        this.searchComparator = null;
        this.groupComparator = null;
        EventTableModel<BibtexEntry> eventTableModel = new EventTableModel<BibtexEntry>(this.sortedForGrouping, mainTableFormat);
        this.setModel(eventTableModel);
        this.tableColorCodes = Globals.prefs.getBoolean("tableColorCodesOn");
        this.selectionModel = new EventSelectionModel<BibtexEntry>(this.sortedForGrouping);
        this.setSelectionModel(this.selectionModel);
        this.pane = new JScrollPane(this);
        this.pane.setBorder(BorderFactory.createEmptyBorder());
        this.pane.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
        this.setGridColor(Globals.prefs.getColor("gridColor"));
        if (Globals.prefs.getBoolean("tableShowGrid")) {
            this.setShowGrid(true);
        } else {
            this.setShowGrid(false);
            this.setIntercellSpacing(new Dimension(0, 0));
        }
        this.setTableHeader(new PreventDraggingJTableHeader(this.getColumnModel()));
        this.comparatorChooser = this.createTableComparatorChooser(this, this.sortedForTable, TableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.tableColumnListener = new PersistenceTableColumnListener(this);
        this.getSelected();
        this.setDragEnabled(true);
        EntryTableTransferHandler entryTableTransferHandler = new EntryTableTransferHandler(this, jabRefFrame, basePanel);
        this.setTransferHandler(entryTableTransferHandler);
        this.pane.setTransferHandler(entryTableTransferHandler);
        this.setupComparatorChooser();
        this.refreshSorting();
        this.setWidths();
    }

    public void refreshSorting() {
        this.sortedForMarking.getReadWriteLock().writeLock().lock();
        if (Globals.prefs.getBoolean("floatMarkedEntries")) {
            this.sortedForMarking.setComparator(this.markingComparator);
        } else {
            this.sortedForMarking.setComparator(null);
        }
        this.sortedForMarking.getReadWriteLock().writeLock().unlock();
        this.sortedForSearch.getReadWriteLock().writeLock().lock();
        this.sortedForSearch.setComparator(this.searchComparator);
        this.sortedForSearch.getReadWriteLock().writeLock().unlock();
        this.sortedForGrouping.getReadWriteLock().writeLock().lock();
        this.sortedForGrouping.setComparator(this.groupComparator);
        this.sortedForGrouping.getReadWriteLock().writeLock().unlock();
    }

    public void showFloatSearch(Matcher<BibtexEntry> matcher) {
        this.showingFloatSearch = true;
        this.searchMatcher = matcher;
        this.searchComparator = new HitOrMissComparator(matcher);
        this.refreshSorting();
        this.scrollTo(0);
    }

    public void stopShowingFloatSearch() {
        this.showingFloatSearch = false;
        this.searchMatcher = null;
        this.searchComparator = null;
        this.refreshSorting();
    }

    public void showFloatGrouping(Matcher<BibtexEntry> matcher) {
        this.showingFloatGrouping = true;
        this.groupMatcher = matcher;
        this.groupComparator = new HitOrMissComparator(matcher);
        this.refreshSorting();
    }

    public boolean isShowingFloatSearch() {
        return this.showingFloatSearch;
    }

    public void stopShowingFloatGrouping() {
        this.showingFloatGrouping = false;
        this.groupMatcher = null;
        this.groupComparator = null;
        this.refreshSorting();
    }

    public EventList<BibtexEntry> getTableRows() {
        return this.sortedForGrouping;
    }

    public void addSelectionListener(ListEventListener<BibtexEntry> listEventListener) {
        this.getSelected().addListEventListener(listEventListener);
    }

    public JScrollPane getPane() {
        return this.pane;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3;
        int n4 = -3;
        DefaultTableCellRenderer defaultTableCellRenderer = defRenderer;
        int n5 = this.getCellStatus(n, n2);
        if (!this.showingFloatSearch || this.matches(n, this.searchMatcher)) {
            ++n4;
        }
        if (!this.showingFloatGrouping || this.matches(n, this.groupMatcher)) {
            n4 += 2;
        }
        if (n4 < -1) {
            if (n2 == 0) {
                veryGrayedOutNumberRenderer.setNumber(n);
                defaultTableCellRenderer = veryGrayedOutNumberRenderer;
            } else {
                defaultTableCellRenderer = veryGrayedOutRenderer;
            }
        } else if (n4 == -1) {
            if (n2 == 0) {
                grayedOutNumberRenderer.setNumber(n);
                defaultTableCellRenderer = grayedOutNumberRenderer;
            } else {
                defaultTableCellRenderer = grayedOutRenderer;
            }
        } else if (n2 == 0) {
            if (!this.isComplete(n)) {
                incRenderer.setNumber(n);
                defaultTableCellRenderer = incRenderer;
            } else {
                compRenderer.setNumber(n);
                n3 = this.isMarked(n);
                if (n3 > 0) {
                    n3 = Math.min(n3, 6);
                    defaultTableCellRenderer = markedNumberRenderers[n3 - 1];
                    markedNumberRenderers[n3 - 1].setNumber(n);
                } else {
                    defaultTableCellRenderer = compRenderer;
                }
            }
            defaultTableCellRenderer.setHorizontalAlignment(0);
        } else if (this.tableColorCodes) {
            if (n5 == 1) {
                defaultTableCellRenderer = reqRenderer;
            } else if (n5 == 2) {
                defaultTableCellRenderer = optRenderer;
            } else if (n5 == 4) {
                defaultTableCellRenderer = (DefaultTableCellRenderer)this.getDefaultRenderer(Boolean.class);
            }
        }
        n3 = this.isMarked(n);
        if (n2 != 0 && n3 > 0) {
            n3 = Math.min(n3, 6);
            defaultTableCellRenderer = markedRenderers[n3 - 1];
        }
        return defaultTableCellRenderer;
    }

    private void setWidths() {
        int n;
        int n2 = Globals.prefs.getInt("numberColWidth");
        String[] stringArray = Globals.prefs.getStringArray("columnWidths");
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(n2);
        for (n = 1; n < this.tableFormat.padleft; ++n) {
            if (this.tableFormat.isRankingColumn(n) && !Globals.prefs.getBoolean("compactRankingColumn")) {
                tableColumnModel.getColumn(n).setPreferredWidth(35);
                tableColumnModel.getColumn(n).setMinWidth(35);
                tableColumnModel.getColumn(n).setMaxWidth(35);
                continue;
            }
            tableColumnModel.getColumn(n).setPreferredWidth(19);
            tableColumnModel.getColumn(n).setMinWidth(19);
            tableColumnModel.getColumn(n).setMaxWidth(19);
        }
        for (n = this.tableFormat.padleft; n < this.getModel().getColumnCount(); ++n) {
            try {
                tableColumnModel.getColumn(n).setPreferredWidth(Integer.parseInt(stringArray[n - this.tableFormat.padleft]));
                continue;
            }
            catch (Throwable throwable) {
                LOGGER.info("Exception while setting column widths. Choosing default.", throwable);
                tableColumnModel.getColumn(n).setPreferredWidth(100);
            }
        }
    }

    public BibtexEntry getEntryAt(int n) {
        return (BibtexEntry)this.sortedForGrouping.get(n);
    }

    public BibtexEntry[] getSelectedEntries() {
        BibtexEntry[] bibtexEntryArray = new BibtexEntry[]{};
        return this.getSelected().toArray(bibtexEntryArray);
    }

    private List<Boolean> getCurrentSortOrder() {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        List<Integer> list = this.comparatorChooser.getSortingColumns();
        for (Integer n : list) {
            arrayList.add(this.comparatorChooser.isColumnReverse(n));
        }
        return arrayList;
    }

    private List<String> getCurrentSortFields() {
        List<Integer> list = this.comparatorChooser.getSortingColumns();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : list) {
            String string = this.tableFormat.getColumnType(n);
            if (string == null) continue;
            arrayList.add(string.toLowerCase());
        }
        return arrayList;
    }

    private void setupComparatorChooser() {
        Object[] objectArray;
        int n;
        List<Comparator> list = this.comparatorChooser.getComparatorsForColumn(0);
        list.clear();
        list.add(new FirstColumnComparator(this.panel.database()));
        for (n = 1; n < this.tableFormat.padleft; ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            objectArray = this.tableFormat.getIconTypeForColumn(n);
            if (objectArray[0].equals("ranking")) {
                list.add(new RankingFieldComparator());
                continue;
            }
            list.add(new IconComparator((String[])objectArray));
        }
        for (n = this.tableFormat.padleft; n < this.tableFormat.getColumnCount(); ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            list.add(new FieldComparator(this.tableFormat.getColumnName(n).toLowerCase()));
        }
        String[] stringArray = new String[]{Globals.prefs.get("priSort"), Globals.prefs.get("secSort"), Globals.prefs.get("terSort")};
        objectArray = new boolean[]{Globals.prefs.getBoolean("priDescending"), Globals.prefs.getBoolean("secDescending"), Globals.prefs.getBoolean("terDescending")};
        this.sortedForTable.getReadWriteLock().writeLock().lock();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = -1;
            if (!stringArray[i].startsWith("iconcol:")) {
                n2 = this.tableFormat.getColumnIndex(stringArray[i]);
            } else {
                for (int j = 0; j < this.tableFormat.getColumnCount(); ++j) {
                    if (!stringArray[i].equals(this.tableFormat.getColumnType(j))) continue;
                    n2 = j;
                    break;
                }
            }
            if (n2 < 0) continue;
            this.comparatorChooser.appendComparator(n2, 0, (boolean)objectArray[i]);
        }
        this.sortedForTable.getReadWriteLock().writeLock().unlock();
        this.comparatorChooser.addSortActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = MainTable.this.getCurrentSortFields();
                List list2 = MainTable.this.getCurrentSortOrder();
                int n = Math.min(list.size(), list2.size());
                if (n >= 1) {
                    Globals.prefs.put("priSort", (String)list.get(0));
                    Globals.prefs.putBoolean("priDescending", (Boolean)list2.get(0));
                }
                if (n >= 2) {
                    Globals.prefs.put("secSort", (String)list.get(1));
                    Globals.prefs.putBoolean("secDescending", (Boolean)list2.get(1));
                } else {
                    Globals.prefs.put("secSort", "");
                    Globals.prefs.putBoolean("secDescending", false);
                }
                if (n >= 3) {
                    Globals.prefs.put("terSort", (String)list.get(2));
                    Globals.prefs.putBoolean("terDescending", (Boolean)list2.get(2));
                } else {
                    Globals.prefs.put("terSort", "");
                    Globals.prefs.putBoolean("terDescending", false);
                }
            }
        });
    }

    private int getCellStatus(int n, int n2) {
        try {
            BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
            BibtexEntryType bibtexEntryType = bibtexEntry.getType();
            String string = this.getColumnName(n2).toLowerCase();
            if (string.equals("bibtexkey") || bibtexEntryType.isRequired(string)) {
                return 1;
            }
            if (bibtexEntryType.isOptional(string)) {
                return 2;
            }
            return 3;
        }
        catch (NullPointerException nullPointerException) {
            return 3;
        }
    }

    public EventList<BibtexEntry> getSelected() {
        return this.selectionModel.getSelected();
    }

    public void setSelected(int n) {
        this.selectionModel.setSelectionInterval(n, n);
    }

    public void addSelection(int n) {
        this.selectionModel.addSelectionInterval(n, n);
    }

    public int findEntry(BibtexEntry bibtexEntry) {
        return this.sortedForGrouping.indexOf(bibtexEntry);
    }

    public String[] getIconTypeForColumn(int n) {
        return this.tableFormat.getIconTypeForColumn(n);
    }

    private boolean matches(int n, Matcher<BibtexEntry> matcher) {
        return matcher.matches((BibtexEntry)this.sortedForGrouping.get(n));
    }

    private boolean isComplete(int n) {
        try {
            BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
            return bibtexEntry.hasAllRequiredFields(this.panel.database());
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    private int isMarked(int n) {
        try {
            BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
            return EntryMarker.isMarked(bibtexEntry);
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public void scrollTo(int n) {
        JScrollBar jScrollBar = this.pane.getVerticalScrollBar();
        jScrollBar.setValue(n * jScrollBar.getUnitIncrement(1));
    }

    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
        this.setRowHeight(Globals.prefs.getInt("tableRowPadding") + GUIGlobals.CURRENTFONT.getSize());
    }

    public void ensureVisible(int n) {
        JScrollBar jScrollBar = this.pane.getVerticalScrollBar();
        int n2 = n * this.getRowHeight();
        if (n2 < jScrollBar.getValue() || n2 > jScrollBar.getValue() + jScrollBar.getVisibleAmount() && !this.showingFloatSearch) {
            this.scrollToCenter(n, 1);
        }
    }

    public void scrollToCenter(int n, int n2) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, n2, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        int n3 = (rectangle2.width - rectangle.width) / 2;
        int n4 = (rectangle2.height - rectangle.height) / 2;
        if (rectangle.x < n3) {
            n3 = -n3;
        }
        if (rectangle.y < n4) {
            n4 = -n4;
        }
        rectangle.translate(n3, n4);
        jViewport.scrollRectToVisible(rectangle);
        this.revalidate();
        this.repaint();
    }

    public static void updateRenderers() {
        defRenderer = new GeneralRenderer(Globals.prefs.getColor("tableBackground"), Globals.prefs.getColor("tableText"));
        Color color = defRenderer.getTableCellRendererComponent(new JTable(), "", true, false, 0, 0).getBackground();
        reqRenderer = new GeneralRenderer(Globals.prefs.getColor("tableReqFieldBackground"), Globals.prefs.getColor("tableText"));
        optRenderer = new GeneralRenderer(Globals.prefs.getColor("tableOptFieldBackground"), Globals.prefs.getColor("tableText"));
        incRenderer = new IncompleteRenderer();
        compRenderer = new CompleteRenderer(Globals.prefs.getColor("tableBackground"));
        grayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("grayedOutBackground"));
        veryGrayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("veryGrayedOutBackground"));
        grayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("grayedOutBackground"), Globals.prefs.getColor("grayedOutText"), MainTable.mixColors(Globals.prefs.getColor("grayedOutBackground"), color));
        veryGrayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("veryGrayedOutBackground"), Globals.prefs.getColor("veryGrayedOutText"), MainTable.mixColors(Globals.prefs.getColor("veryGrayedOutBackground"), color));
        markedRenderers = new GeneralRenderer[6];
        markedNumberRenderers = new CompleteRenderer[6];
        for (int i = 0; i < 6; ++i) {
            Color color2 = Globals.prefs.getColor("markedEntryBackground" + i);
            MainTable.markedRenderers[i] = new GeneralRenderer(color2, Globals.prefs.getColor("tableText"), MainTable.mixColors(Globals.prefs.getColor("markedEntryBackground" + i), color));
            MainTable.markedNumberRenderers[i] = new CompleteRenderer(color2);
        }
    }

    private static Color mixColors(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    private TableComparatorChooser<BibtexEntry> createTableComparatorChooser(JTable jTable, SortedList<BibtexEntry> sortedList, Object object) {
        TableComparatorChooser<BibtexEntry> tableComparatorChooser = TableComparatorChooser.install(jTable, sortedList, object);
        tableComparatorChooser.addSortActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainTable.this.refreshSorting();
            }
        });
        return tableComparatorChooser;
    }

    @Override
    public void setUI(TableUI tableUI) {
        super.setUI(tableUI);
        TransferHandler transferHandler = this.getTransferHandler();
        this.setTransferHandler(null);
        this.setTransferHandler(transferHandler);
    }

    public Comparator<BibtexEntry> getComparatorForColumn(int n) {
        List<Comparator> list = this.comparatorChooser.getComparatorsForColumn(n);
        return list.size() == 0 ? null : list.get(0);
    }

    public int getSortingColumn(int n) {
        List<Integer> list = this.comparatorChooser.getSortingColumns();
        if (list.size() <= n) {
            return -1;
        }
        return list.get(n);
    }

    public PersistenceTableColumnListener getTableColumnListener() {
        return this.tableColumnListener;
    }

    public SortedList<BibtexEntry> getSortedForTable() {
        return this.sortedForTable;
    }

    static {
        MainTable.updateRenderers();
    }

    static class CompleteRenderer
    extends GeneralRenderer {
        public CompleteRenderer(Color color) {
            super(color);
        }

        void setNumber(int n) {
            super.setValue(String.valueOf(n + 1));
        }

        @Override
        protected void setValue(Object object) {
        }
    }

    static class IncompleteRenderer
    extends GeneralRenderer {
        public IncompleteRenderer() {
            super(Globals.prefs.getColor("incompleteEntryBackground"));
            super.setToolTipText(Globals.lang("This entry is incomplete"));
        }

        void setNumber(int n) {
            super.setValue(String.valueOf(n + 1));
        }

        @Override
        protected void setValue(Object object) {
        }
    }
}

