/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryComparator;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.TransferableBibtexEntry;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class SearchResultsDialog {
    private final JabRefFrame frame;
    private JDialog diag;
    private final String[] fields = new String[]{"author", "title", "year", "journal"};
    private final int FILE_COL = 0;
    private final int URL_COL = 1;
    private final int PAD = 2;
    private final JLabel fileLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    private final JLabel urlLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
    private final Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private EventTableModel<BibtexEntry> model;
    private final EventList<BibtexEntry> entries = new BasicEventList<BibtexEntry>();
    private SortedList<BibtexEntry> sortedEntries;
    private final HashMap<BibtexEntry, BasePanel> entryHome = new HashMap();
    private JTable entryTable;
    private final JSplitPane contentPane = new JSplitPane(0);
    private PreviewPanel preview;

    public SearchResultsDialog(JabRefFrame jabRefFrame, String string) {
        this.frame = jabRefFrame;
        this.init(string);
    }

    private void init(String string) {
        this.diag = new JDialog(this.frame, string, false);
        int n = Globals.prefs.getInt("activePreview");
        this.preview = new PreviewPanel(null, new MetaData(), n == 0 ? Globals.prefs.get("preview0") : Globals.prefs.get("preview1"));
        this.sortedEntries = new SortedList<BibtexEntry>(this.entries, new EntryComparator(false, true, "author"));
        this.model = new EventTableModel<BibtexEntry>(this.sortedEntries, new EntryTableFormat());
        this.entryTable = new JTable(this.model);
        GeneralRenderer generalRenderer = new GeneralRenderer(Color.white);
        this.entryTable.setDefaultRenderer(JLabel.class, generalRenderer);
        this.entryTable.setDefaultRenderer(String.class, generalRenderer);
        this.setWidths();
        TableComparatorChooser<BibtexEntry> tableComparatorChooser = TableComparatorChooser.install(this.entryTable, this.sortedEntries, AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser(tableComparatorChooser);
        JScrollPane jScrollPane = new JScrollPane(this.entryTable);
        final EventSelectionModel<BibtexEntry> eventSelectionModel = new EventSelectionModel<BibtexEntry>(this.sortedEntries);
        this.entryTable.setSelectionModel(eventSelectionModel);
        eventSelectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.entryTable.addMouseListener(new TableClickListener());
        this.contentPane.setTopComponent(jScrollPane);
        this.contentPane.setBottomComponent(this.preview);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchResultsDialog.this.diag.dispose();
            }
        };
        ActionMap actionMap = this.contentPane.getActionMap();
        InputMap inputMap = this.contentPane.getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.entryTable.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!eventSelectionModel.getSelected().isEmpty()) {
                    BibtexEntry[] bibtexEntryArray = eventSelectionModel.getSelected().toArray(new BibtexEntry[eventSelectionModel.getSelected().size()]);
                    TransferableBibtexEntry transferableBibtexEntry = new TransferableBibtexEntry(bibtexEntryArray);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableBibtexEntry, SearchResultsDialog.this.frame.basePanel());
                    SearchResultsDialog.this.frame.output(Globals.lang("Copied") + ' ' + (bibtexEntryArray.length > 1 ? bibtexEntryArray.length + " " + Globals.lang("entries") : "1 " + Globals.lang("entry") + '.'));
                }
            }
        });
        this.diag.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                SearchResultsDialog.this.contentPane.setDividerLocation(0.5);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Globals.prefs.putInt("searchDialogWidth", ((SearchResultsDialog)SearchResultsDialog.this).diag.getSize().width);
                Globals.prefs.putInt("searchDialogHeight", ((SearchResultsDialog)SearchResultsDialog.this).diag.getSize().height);
            }
        });
        this.diag.getContentPane().add((Component)this.contentPane, "Center");
        this.diag.setSize(new Dimension(Globals.prefs.getInt("searchDialogWidth"), Globals.prefs.getInt("searchDialogHeight")));
        this.diag.setLocationRelativeTo(this.frame);
    }

    public void setVisible(boolean bl) {
        this.diag.setVisible(bl);
    }

    public void selectFirstEntry() {
        if (this.entryTable.getRowCount() > 0) {
            this.entryTable.setRowSelectionInterval(0, 0);
        } else {
            this.contentPane.setDividerLocation(1.0);
        }
    }

    public synchronized void clear() {
        this.entries.clear();
        this.entryHome.clear();
    }

    private void setupComparatorChooser(TableComparatorChooser<BibtexEntry> tableComparatorChooser) {
        int n;
        List<Comparator> list = tableComparatorChooser.getComparatorsForColumn(0);
        list.clear();
        list = tableComparatorChooser.getComparatorsForColumn(1);
        list.clear();
        for (n = 2; n < 2; ++n) {
            list = tableComparatorChooser.getComparatorsForColumn(n);
            list.clear();
            if (n == 0) {
                list.add(new IconComparator(new String[]{"file"}));
                continue;
            }
            if (n != 1) continue;
            list.add(new IconComparator(new String[]{"url"}));
        }
        for (n = 2; n < 2 + this.fields.length; ++n) {
            list = tableComparatorChooser.getComparatorsForColumn(n);
            list.clear();
            list.add(new FieldComparator(this.fields[n - 2]));
        }
        this.sortedEntries.getReadWriteLock().writeLock().lock();
        tableComparatorChooser.appendComparator(2, 0, false);
        this.sortedEntries.getReadWriteLock().writeLock().unlock();
    }

    private void setWidths() {
        int n;
        TableColumnModel tableColumnModel = this.entryTable.getColumnModel();
        for (n = 0; n < 2; ++n) {
            if (this.frame.basePanel().tableFormat.isRankingColumn(n)) {
                tableColumnModel.getColumn(n).setPreferredWidth(35);
                tableColumnModel.getColumn(n).setMinWidth(35);
                tableColumnModel.getColumn(n).setMaxWidth(35);
                continue;
            }
            tableColumnModel.getColumn(n).setPreferredWidth(19);
            tableColumnModel.getColumn(n).setMinWidth(19);
            tableColumnModel.getColumn(n).setMaxWidth(19);
        }
        for (n = 0; n < this.fields.length; ++n) {
            int n2 = BibtexFields.getFieldLength(this.fields[n]);
            tableColumnModel.getColumn(n + 2).setPreferredWidth(n2);
        }
    }

    public synchronized void addEntries(List<BibtexEntry> list, BasePanel basePanel) {
        for (BibtexEntry bibtexEntry : list) {
            this.entries.add(bibtexEntry);
            this.entryHome.put(bibtexEntry, basePanel);
        }
    }

    public synchronized void addEntry(BibtexEntry bibtexEntry, BasePanel basePanel) {
        this.entries.add(bibtexEntry);
        this.entryHome.put(bibtexEntry, basePanel);
    }

    private class EntryTableFormat
    implements AdvancedTableFormat<BibtexEntry> {
        private EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2 + SearchResultsDialog.this.fields.length;
        }

        @Override
        public String getColumnName(int n) {
            if (n >= 2) {
                return StringUtil.nCase(SearchResultsDialog.this.fields[n - 2]);
            }
            return "";
        }

        @Override
        public Object getColumnValue(BibtexEntry bibtexEntry, int n) {
            if (n < 2) {
                switch (n) {
                    case 0: {
                        String string = bibtexEntry.getField("file");
                        if (string != null) {
                            FileListTableModel fileListTableModel = new FileListTableModel();
                            fileListTableModel.setContent(string);
                            SearchResultsDialog.this.fileLabel.setToolTipText(fileListTableModel.getToolTipHTMLRepresentation());
                            if (fileListTableModel.getRowCount() > 0) {
                                SearchResultsDialog.this.fileLabel.setIcon(fileListTableModel.getEntry(0).getType().getIcon());
                            }
                            return SearchResultsDialog.this.fileLabel;
                        }
                        return null;
                    }
                    case 1: {
                        String string = bibtexEntry.getField("url");
                        if (string != null) {
                            SearchResultsDialog.this.urlLabel.setToolTipText(string);
                            return SearchResultsDialog.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String string = SearchResultsDialog.this.fields[n - 2];
            if ((string.equals("author") || string.equals("editor")) && SearchResultsDialog.this.frame.basePanel() != null) {
                return ((SearchResultsDialog)SearchResultsDialog.this).frame.basePanel().tableFormat.formatName(bibtexEntry.getField(string));
            }
            return bibtexEntry.getField(string);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n < 2) {
                return JLabel.class;
            }
            return String.class;
        }

        @Override
        public Comparator<?> getColumnComparator(int n) {
            return null;
        }
    }

    private class EntrySelectionListener
    implements ListEventListener<BibtexEntry> {
        private EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<BibtexEntry> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                BibtexEntry bibtexEntry = (BibtexEntry)listEvent.getSourceList().get(0);
                BasePanel basePanel = (BasePanel)SearchResultsDialog.this.entryHome.get(bibtexEntry);
                SearchResultsDialog.this.preview.setMetaData(basePanel.metaData());
                SearchResultsDialog.this.preview.setEntry(bibtexEntry);
                SearchResultsDialog.this.contentPane.setDividerLocation(0.5);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchResultsDialog.this.preview.scrollRectToVisible(SearchResultsDialog.this.toRect);
                    }
                });
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
                return;
            }
            int n = SearchResultsDialog.this.entryTable.rowAtPoint(mouseEvent.getPoint());
            if (mouseEvent.getClickCount() == 2) {
                BibtexEntry bibtexEntry = (BibtexEntry)SearchResultsDialog.this.model.getElementAt(n);
                BasePanel basePanel = (BasePanel)SearchResultsDialog.this.entryHome.get(bibtexEntry);
                SearchResultsDialog.this.frame.showBasePanel(basePanel);
                basePanel.highlightEntry(bibtexEntry);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.processPopupTrigger(mouseEvent);
                return;
            }
            int n = SearchResultsDialog.this.entryTable.columnAtPoint(mouseEvent.getPoint());
            int n2 = SearchResultsDialog.this.entryTable.rowAtPoint(mouseEvent.getPoint());
            if (n < 2) {
                BibtexEntry bibtexEntry = (BibtexEntry)SearchResultsDialog.this.sortedEntries.get(n2);
                BasePanel basePanel = (BasePanel)SearchResultsDialog.this.entryHome.get(bibtexEntry);
                switch (n) {
                    case 0: {
                        String string = bibtexEntry.getField("file");
                        if (string == null) break;
                        FileListTableModel fileListTableModel = new FileListTableModel();
                        fileListTableModel.setContent(string);
                        if (fileListTableModel.getRowCount() == 0) {
                            return;
                        }
                        FileListEntry fileListEntry = fileListTableModel.getEntry(0);
                        new ExternalFileMenuItem(SearchResultsDialog.this.frame, bibtexEntry, "", fileListEntry.getLink(), null, basePanel.metaData(), fileListEntry.getType()).actionPerformed(null);
                        break;
                    }
                    case 1: {
                        String string = bibtexEntry.getField("url");
                        try {
                            if (string == null) break;
                            Util.openExternalViewer(basePanel.metaData(), string, "url");
                            break;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        }

        public void processPopupTrigger(MouseEvent mouseEvent) {
            BibtexEntry bibtexEntry = (BibtexEntry)SearchResultsDialog.this.sortedEntries.get(SearchResultsDialog.this.entryTable.rowAtPoint(mouseEvent.getPoint()));
            BasePanel basePanel = (BasePanel)SearchResultsDialog.this.entryHome.get(bibtexEntry);
            int n = SearchResultsDialog.this.entryTable.columnAtPoint(mouseEvent.getPoint());
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n2 = 0;
            if (n == 0) {
                String string = bibtexEntry.getField("file");
                FileListTableModel fileListTableModel = new FileListTableModel();
                fileListTableModel.setContent(string);
                for (int i = 0; i < fileListTableModel.getRowCount(); ++i) {
                    FileListEntry fileListEntry = fileListTableModel.getEntry(i);
                    String string2 = fileListEntry.getDescription();
                    if (string2 == null || string2.trim().isEmpty()) {
                        string2 = fileListEntry.getLink();
                    }
                    jPopupMenu.add(new ExternalFileMenuItem(basePanel.frame(), bibtexEntry, string2, fileListEntry.getLink(), (Icon)fileListEntry.getType().getIcon(), basePanel.metaData(), fileListEntry.getType()));
                    ++n2;
                }
            }
            if (n2 > 0) {
                jPopupMenu.show(SearchResultsDialog.this.entryTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

