/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JTabbedPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;

public class SortTabsAction
extends MnemonicAwareAction
implements Comparator<String> {
    private final JabRefFrame frame;

    public SortTabsAction(JabRefFrame jabRefFrame) {
        this.putValue("Name", "Sort tabs");
        this.putValue("ShortDescription", Globals.lang("Rearrange tabs alphabetically by title"));
        this.frame = jabRefFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = this.frame.getTabbedPane();
        TreeMap<String, BasePanel> treeMap = new TreeMap<String, BasePanel>(this);
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            BasePanel object = (BasePanel)jTabbedPane.getComponent(i);
            treeMap.put(jTabbedPane.getTitleAt(i), object);
        }
        jTabbedPane.removeAll();
        for (String string : treeMap.keySet()) {
            BasePanel basePanel = (BasePanel)treeMap.get(string);
            jTabbedPane.addTab(string, basePanel);
        }
    }

    @Override
    public int compare(String string, String string2) {
        return string.toLowerCase().compareTo(string2.toLowerCase());
    }
}

