/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class WaitForSaveOperation
implements ActionListener {
    private final JabRefFrame frame;
    private final JDialog diag;
    private final Timer t = new Timer(500, this);
    private boolean cancelled = false;

    public WaitForSaveOperation(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        JButton jButton = new JButton(Globals.lang("Cancel"));
        JProgressBar jProgressBar = new JProgressBar(0);
        jProgressBar.setIndeterminate(true);
        jProgressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag = new JDialog(jabRefFrame, Globals.lang("Please wait..."), true);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addGlue();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WaitForSaveOperation.this.cancelled = true;
                WaitForSaveOperation.this.t.stop();
                WaitForSaveOperation.this.diag.dispose();
            }
        });
        JLabel jLabel = new JLabel(Globals.lang("Waiting for save operation to finish") + "...");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)jLabel, "North");
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.getContentPane().add((Component)jProgressBar, "Center");
        this.diag.pack();
    }

    public void show() {
        this.diag.setLocationRelativeTo(this.frame);
        this.t.start();
        this.diag.setVisible(true);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        for (int i = 0; i < this.frame.baseCount(); ++i) {
            if (!this.frame.baseAt(i).isSaving()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.t.stop();
            this.diag.dispose();
        }
    }
}

