/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.nativeext;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.WString;
import net.sf.jabref.Globals;
import net.sf.jabref.logic.util.OS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PinToTaskbar {
    private static final Log LOGGER = LogFactory.getLog(PinToTaskbar.class);

    public static void enablePinToTaskbar() {
        if (OS.isWindows7OrLater()) {
            PinToTaskbar.setCurrentProcessExplicitAppUserModelID("JabRef." + Globals.BUILD_INFO.getVersion());
        } else {
            LOGGER.info("Does not support pin to taskbar.");
        }
    }

    private static void setCurrentProcessExplicitAppUserModelID(String string) {
        if (PinToTaskbar.SetCurrentProcessExplicitAppUserModelID(new WString(string)).longValue() != 0L) {
            throw new RuntimeException("unable to set current process explicit AppUserModelID to: " + string);
        }
    }

    private static native NativeLong SetCurrentProcessExplicitAppUserModelID(WString var0);

    static {
        if (OS.WINDOWS) {
            Native.register("shell32");
            LOGGER.info("Registered Shell32 DLL");
        }
    }
}

