/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.help.MyEditorKit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HelpContent
extends JTextPane {
    private static final Log log = LogFactory.getLog(HelpContent.class);
    private final JScrollPane pane = new JScrollPane(this, 20, 30);
    private final Stack<URL> history;
    private final Stack<URL> forw;
    private final JabRefPreferences prefs;

    public HelpContent(JabRefPreferences jabRefPreferences) {
        this.pane.setDoubleBuffered(true);
        this.prefs = jabRefPreferences;
        this.history = new Stack();
        this.forw = new Stack();
        this.setEditorKitForContentType("text/html", new MyEditorKit());
        this.setContentType("text/html");
        this.setText("");
        this.setEditable(false);
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getDescription().startsWith("#")) {
                    HelpContent.this.scrollToReference(hyperlinkEvent.getDescription().substring(1));
                }
            }
        };
        this.addHyperlinkListener(hyperlinkListener);
    }

    public boolean back() {
        if (!this.history.empty()) {
            URL uRL = this.history.pop();
            this.forw.push(this.getPage());
            this.setPageOnly(uRL);
        }
        return !this.history.empty();
    }

    public boolean forward() {
        if (!this.forw.empty()) {
            URL uRL = this.forw.pop();
            this.history.push(this.getPage());
            this.setPageOnly(uRL);
        }
        return !this.forw.empty();
    }

    public void reset() {
        this.forw.removeAllElements();
        this.history.removeAllElements();
    }

    public void setPage(String string, Class clazz) {
        String string2;
        String string3;
        int n = string.indexOf(35);
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = "";
        }
        String string4 = this.prefs.get("language") + '/';
        if (string4.equals("en/")) {
            string4 = "";
        }
        URL uRL = this.getPage();
        try {
            URL uRL2 = clazz.getResource("/help/" + string4 + string3);
            if (uRL2 == null) {
                uRL2 = clazz.getResource("/help/" + string3);
            }
            if (uRL2 == null) {
                log.error("Could not find html-help for file '" + string3 + "'.");
                return;
            }
            this.setPageOnly(new URL(uRL2.toString() + '#' + string2));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.forw.removeAllElements();
        if (uRL != null) {
            this.history.push(uRL);
        }
    }

    @Override
    public void setPage(URL uRL) {
        File file = new File(uRL.getPath());
        this.setPage(file.getName(), JabRef.class);
    }

    private void setPageOnly(URL uRL) {
        try {
            super.setPage(uRL);
        }
        catch (IOException iOException) {
            if (uRL == null) {
                System.out.println("Error: Help file not set");
            }
            System.out.println("Error: Help file not found '" + uRL.getFile() + '\'');
        }
    }

    public JComponent getPane() {
        return this.pane;
    }
}

