/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ParserResult;

public class BibtexImporter
extends ImportFormat {
    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return BibtexParser.isRecognizedFormat(new InputStreamReader(inputStream));
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        ParserResult parserResult = BibtexParser.parse(new InputStreamReader(inputStream));
        return new ArrayList<BibtexEntry>(parserResult.getDatabase().getEntries());
    }

    @Override
    public String getFormatName() {
        return "BibTeX";
    }

    @Override
    public String getExtensions() {
        return "bib";
    }
}

