/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.BibtexString;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.UnknownEntryType;
import net.sf.jabref.imports.FieldContentParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BibtexParser {
    private static final Log LOGGER = LogFactory.getLog(BibtexParser.class);
    private final PushbackReader pushbackReader;
    private BibtexDatabase database;
    private HashMap<String, BibtexEntryType> entryTypes;
    private boolean eof = false;
    private int line = 1;
    private final FieldContentParser fieldContentParser = new FieldContentParser();
    private ParserResult parserResult;
    private static final Integer LOOKAHEAD = 64;
    private final boolean autoDoubleBraces;

    public BibtexParser(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (Globals.prefs == null) {
            Globals.prefs = JabRefPreferences.getInstance();
        }
        this.autoDoubleBraces = Globals.prefs.getBoolean("autoDoubleBraces");
        this.pushbackReader = new PushbackReader(reader, LOOKAHEAD);
    }

    public static ParserResult parse(Reader reader) throws IOException {
        BibtexParser bibtexParser = new BibtexParser(reader);
        return bibtexParser.parse();
    }

    public static Collection<BibtexEntry> fromString(String string) {
        StringReader stringReader = new StringReader(string);
        BibtexParser bibtexParser = new BibtexParser(stringReader);
        try {
            return bibtexParser.parse().getDatabase().getEntries();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BibtexEntry singleFromString(String string) {
        Collection<BibtexEntry> collection = BibtexParser.fromString(string);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    public static boolean isRecognizedFormat(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Pattern pattern = Pattern.compile("@[a-zA-Z]*\\s*\\{");
        while ((string = bufferedReader.readLine()) != null) {
            if (pattern.matcher(string).find()) {
                return true;
            }
            if (!string.startsWith("This file was created with JabRef")) continue;
            return true;
        }
        return false;
    }

    private void skipWhitespace() throws IOException {
        int n;
        do {
            if ((n = this.read()) != -1 && n != 65535) continue;
            this.eof = true;
            return;
        } while (Character.isWhitespace((char)n));
        this.unread(n);
    }

    private String skipAndRecordWhitespace(int n) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (n != 32) {
            stringBuilder.append((char)n);
        }
        while (true) {
            if ((n2 = this.read()) == -1 || n2 == 65535) {
                this.eof = true;
                return stringBuilder.toString();
            }
            if (!Character.isWhitespace((char)n2)) break;
            if (n2 == 32) continue;
            stringBuilder.append((char)n2);
        }
        this.unread(n2);
        return stringBuilder.toString();
    }

    public ParserResult parse() throws IOException {
        if (this.parserResult != null) {
            return this.parserResult;
        }
        this.database = new BibtexDatabase();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.entryTypes = new HashMap();
        this.parserResult = new ParserResult(this.database, null, this.entryTypes);
        String string = this.readJabRefVersionNumber();
        if (string != null) {
            this.parserResult.setJabrefVersion(string);
            this.setMajorMinorVersions();
        }
        this.skipWhitespace();
        try {
            boolean bl;
            while (!this.eof && (bl = this.consumeUncritically('@'))) {
                Object object;
                boolean bl2;
                this.skipWhitespace();
                String string2 = this.parseTextToken();
                BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string2);
                boolean bl3 = bl2 = bibtexEntryType != null;
                if (!bl2) {
                    if (string2.toLowerCase().equals("preamble")) {
                        this.database.setPreamble(this.parsePreamble());
                    } else if (string2.toLowerCase().equals("string")) {
                        object = this.parseString();
                        try {
                            this.database.addString((BibtexString)object);
                        }
                        catch (KeyCollisionException keyCollisionException) {
                            this.parserResult.addWarning(Globals.lang("Duplicate string name") + ": " + ((BibtexString)object).getName());
                        }
                    } else if (string2.toLowerCase().equals("comment")) {
                        Object object2;
                        object = this.parseBracketedTextExactly();
                        String string3 = ((StringBuffer)object).toString().replaceAll("[\\x0d\\x0a]", "");
                        if (string3.substring(0, Math.min(string3.length(), "jabref-meta: ".length())).equals("jabref-meta: ") || string3.substring(0, Math.min(string3.length(), "bibkeeper-meta: ".length())).equals("bibkeeper-meta: ")) {
                            object2 = string3.substring(0, "jabref-meta: ".length()).equals("jabref-meta: ") ? string3.substring("jabref-meta: ".length()) : string3.substring("bibkeeper-meta: ".length());
                            int n = ((String)object2).indexOf(58);
                            if (n > 0) {
                                hashMap.put(((String)object2).substring(0, n), ((String)object2).substring(n + 1));
                            }
                        } else if (string3.substring(0, Math.min(string3.length(), "jabref-entrytype: ".length())).equals("jabref-entrytype: ")) {
                            object2 = CustomEntryType.parseEntryType(string3);
                            this.entryTypes.put(((CustomEntryType)object2).getName().toLowerCase(), (BibtexEntryType)object2);
                        } else {
                            LOGGER.info(Globals.lang("Dropped comment from database") + ":" + string3);
                        }
                    } else {
                        bibtexEntryType = new UnknownEntryType(string2.toLowerCase());
                        bl2 = true;
                    }
                }
                if (bl2) {
                    try {
                        object = this.parseEntry(bibtexEntryType);
                        boolean bl4 = this.database.insertEntry((BibtexEntry)object);
                        if (bl4) {
                            this.parserResult.addDuplicateKey(((BibtexEntry)object).getCiteKey());
                        } else if (((BibtexEntry)object).getCiteKey() == null || ((BibtexEntry)object).getCiteKey().equals("")) {
                            this.parserResult.addWarning(Globals.lang("empty BibTeX key") + ": " + ((BibtexEntry)object).getAuthorTitleYear(40) + " (" + Globals.lang("grouping may not work for this entry") + ")");
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("Could not parse entry", iOException);
                        this.parserResult.addWarning(Globals.lang("Error occured when parsing entry") + ": '" + iOException.getMessage() + "'. " + Globals.lang("Skipped entry."));
                    }
                }
                this.skipWhitespace();
            }
            this.checkEntryTypes(this.parserResult);
            this.parserResult.setMetaData(new MetaData(hashMap, this.database));
            return this.parserResult;
        }
        catch (KeyCollisionException keyCollisionException) {
            throw new IOException("Duplicate ID in bibtex file: " + keyCollisionException.toString());
        }
    }

    private int peek() throws IOException {
        int n = this.read();
        this.unread(n);
        return n;
    }

    private int read() throws IOException {
        int n = this.pushbackReader.read();
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    private void unread(int n) throws IOException {
        if (n == 10) {
            --this.line;
        }
        this.pushbackReader.unread(n);
    }

    private BibtexString parseString() throws IOException {
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        String string = this.parseTextToken();
        this.skipWhitespace();
        this.consume('=');
        String string2 = this.parseFieldContent(string);
        this.consume('}', ')');
        String string3 = IdGenerator.next();
        return new BibtexString(string3, string, string2);
    }

    private String parsePreamble() throws IOException {
        return this.parseBracketedText().toString();
    }

    private BibtexEntry parseEntry(BibtexEntryType bibtexEntryType) throws IOException {
        String string;
        String string2 = IdGenerator.next();
        BibtexEntry bibtexEntry = new BibtexEntry(string2, bibtexEntryType);
        this.skipWhitespace();
        this.consume('{', '(');
        int n = this.peek();
        if (n != 10 && n != 13) {
            this.skipWhitespace();
        }
        if ((string = this.parseKey()) != null && string.equals("")) {
            string = null;
        }
        bibtexEntry.setField("bibtexkey", string);
        this.skipWhitespace();
        while ((n = this.peek()) != 125 && n != 41) {
            if (n == 44) {
                this.consume(',');
            }
            this.skipWhitespace();
            n = this.peek();
            if (n == 125 || n == 41) break;
            this.parseField(bibtexEntry);
        }
        this.consume('}', ')');
        return bibtexEntry;
    }

    private void parseField(BibtexEntry bibtexEntry) throws IOException {
        String string = this.parseTextToken().toLowerCase();
        this.skipWhitespace();
        this.consume('=');
        String string2 = this.parseFieldContent(string);
        if (Globals.prefs.putBracesAroundCapitals(string)) {
            string2 = Util.removeBracesAroundCapitals(string2);
        }
        if (string2.length() > 0) {
            if (bibtexEntry.getField(string) == null) {
                bibtexEntry.setField(string, string2);
            } else if (string.equals("author") || string.equals("editor")) {
                bibtexEntry.setField(string, bibtexEntry.getField(string) + " and " + string2);
            }
        }
    }

    private String parseFieldContent(String string) throws IOException {
        int n;
        this.skipWhitespace();
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = this.peek()) != 44 && n != 125 && n != 41) {
            CharSequence charSequence;
            if (this.eof) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n == 34) {
                charSequence = this.parseQuotedFieldExactly();
                stringBuilder.append(this.fieldContentParser.format((StringBuffer)charSequence));
            } else if (n == 123) {
                charSequence = this.parseBracketedTextExactly();
                stringBuilder.append(this.fieldContentParser.format((StringBuffer)charSequence, string));
            } else if (Character.isDigit((char)n)) {
                charSequence = this.parseTextToken();
                stringBuilder.append((String)charSequence);
            } else if (n == 35) {
                this.consume('#');
            } else {
                charSequence = this.parseTextToken();
                if (((String)charSequence).length() == 0) {
                    throw new IOException("Error in line " + this.line + " or above: " + "Empty text token.\nThis could be caused " + "by a missing comma between two fields.");
                }
                stringBuilder.append("#").append((String)charSequence).append("#");
            }
            this.skipWhitespace();
        }
        if (this.autoDoubleBraces) {
            while (stringBuilder.length() > 1 && stringBuilder.charAt(0) == '{' && stringBuilder.charAt(stringBuilder.length() - 1) == '}') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.deleteCharAt(0);
            }
            while (this.hasNegativeBraceCount(stringBuilder.toString())) {
                stringBuilder.insert(0, '{');
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }

    private boolean hasNegativeBraceCount(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '{') {
                ++n;
            } else if (string.charAt(i) == '}') {
                --n;
            }
            if (n >= 0) continue;
            return true;
        }
        return false;
    }

    private String parseTextToken() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(20);
        while (true) {
            if ((n = this.read()) == -1) {
                this.eof = true;
                return stringBuilder.toString();
            }
            if (!Character.isLetterOrDigit((char)n) && n != 58 && n != 45 && n != 95 && n != 42 && n != 43 && n != 46 && n != 47 && n != 39) break;
            stringBuilder.append((char)n);
        }
        this.unread(n);
        return stringBuilder.toString();
    }

    private String fixKey() throws IOException {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        do {
            c = (char)this.read();
            stringBuilder.append(c);
        } while (c != ',' && c != '\n' && c != '=' && ++n < LOOKAHEAD);
        this.unread(c);
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        switch (c) {
            case '=': {
                stringBuilder = stringBuilder.reverse();
                boolean bl = false;
                for (int i = 0; i < stringBuilder.length(); ++i) {
                    c = stringBuilder.charAt(i);
                    if (!bl && c == ' ') continue;
                    bl = true;
                    this.unread(c);
                    if (c != ' ' && c != '\n') continue;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int j = i; j < stringBuilder.length(); ++j) {
                        c = stringBuilder.charAt(j);
                        if (Character.isWhitespace(c)) continue;
                        stringBuilder2.append(c);
                    }
                    this.parserResult.addWarning(Globals.lang("Line %0: Found corrupted BibTeX-key.", String.valueOf(this.line)));
                    stringBuilder = stringBuilder2.reverse();
                }
                break;
            }
            case ',': {
                this.parserResult.addWarning(Globals.lang("Line %0: Found corrupted BibTeX-key (contains whitespaces).", String.valueOf(this.line)));
            }
            case '\n': {
                this.parserResult.addWarning(Globals.lang("Line %0: Found corrupted BibTeX-key (comma missing).", String.valueOf(this.line)));
                break;
            }
            default: {
                this.unreadBuffer(stringBuilder);
                return "";
            }
        }
        return this.removeWhitespaces(stringBuilder).toString();
    }

    private StringBuilder removeWhitespaces(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuilder2.append(c);
        }
        return stringBuilder2;
    }

    private void unreadBuffer(StringBuilder stringBuilder) throws IOException {
        for (int i = stringBuilder.length() - 1; i >= 0; --i) {
            this.unread(stringBuilder.charAt(i));
        }
    }

    private String parseKey() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(20);
        while (true) {
            if ((n = this.read()) == -1) {
                this.eof = true;
                return stringBuilder.toString();
            }
            if (Character.isWhitespace((char)n) || !Character.isLetterOrDigit((char)n) && n != 58 && (n == 35 || n == 123 || n == 125 || n == 65533 || n == 126 || n == 65533 || n == 44 || n == 61)) break;
            stringBuilder.append((char)n);
        }
        if (Character.isWhitespace((char)n)) {
            return stringBuilder.toString() + this.fixKey();
        }
        if (n == 44) {
            this.unread(n);
            return stringBuilder.toString();
        }
        if (n == 61) {
            return stringBuilder.toString();
        }
        throw new IOException("Error in line " + this.line + ":" + "Character '" + (char)n + "' is not " + "allowed in bibtex keys.");
    }

    private StringBuffer parseBracketedText() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.consume('{');
        int n = 0;
        while (this.peek() != 125 || n != 0) {
            int n2 = this.read();
            if (n2 == -1 || n2 == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n2 == 123) {
                ++n;
            } else if (n2 == 125) {
                --n;
            }
            if (Character.isWhitespace((char)n2)) {
                String string = this.skipAndRecordWhitespace(n2);
                if (!string.equals("") && !string.equals("\n\t")) {
                    string = string.replaceAll("\t", "");
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append((char)n2);
        }
        this.consume('}');
        return stringBuffer;
    }

    private StringBuffer parseBracketedTextExactly() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.consume('{');
        int n = 0;
        while (this.peek() != 125 || n != 0) {
            int n2 = this.read();
            if (n2 == -1 || n2 == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n2 == 123) {
                ++n;
            } else if (n2 == 125) {
                --n;
            }
            stringBuffer.append((char)n2);
        }
        this.consume('}');
        return stringBuffer;
    }

    private StringBuffer parseQuotedFieldExactly() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.consume('\"');
        int n = 0;
        while (this.peek() != 34 || n != 0) {
            int n2 = this.read();
            if (n2 == -1 || n2 == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (n2 == 123) {
                ++n;
            } else if (n2 == 125) {
                --n;
            }
            stringBuffer.append((char)n2);
        }
        this.consume('\"');
        return stringBuffer;
    }

    private void consume(char c) throws IOException {
        int n = this.read();
        if (n != c) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + c + " but received " + (char)n);
        }
    }

    private boolean consumeUncritically(char c) throws IOException {
        int n;
        while ((n = this.read()) != c && n != -1 && n != 65535) {
        }
        if (n == -1 || n == 65535) {
            this.eof = true;
        }
        return n == c;
    }

    private void consume(char c, char c2) throws IOException {
        int n = this.read();
        if (n != c && n != c2) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + c + " or " + c2 + " but received " + n);
        }
    }

    private void checkEntryTypes(ParserResult parserResult) {
        for (BibtexEntry bibtexEntry : this.database.getEntries()) {
            if (!(bibtexEntry.getType() instanceof UnknownEntryType)) continue;
            BibtexEntryType bibtexEntryType = this.entryTypes.get(bibtexEntry.getType().getName().toLowerCase());
            if (bibtexEntryType != null) {
                BibtexEntryType bibtexEntryType2 = bibtexEntryType;
                bibtexEntry.setType(bibtexEntryType2);
                continue;
            }
            parserResult.addWarning(Globals.lang("unknown entry type") + ": " + bibtexEntry.getType().getName() + ":" + bibtexEntry.getField("bibtexkey") + " . " + Globals.lang("Type set to 'other'") + ".");
            bibtexEntry.setType(BibtexEntryTypes.OTHER);
        }
    }

    private String readJabRefVersionNumber() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = 0;
        while (bl) {
            int n2 = this.peek();
            stringBuilder.append((char)n2);
            if (n == 0 && (Character.isWhitespace((char)n2) || n2 == 37)) {
                this.read();
            } else if (n2 == "This file was created with JabRef".charAt(n)) {
                ++n;
                this.read();
            } else {
                return null;
            }
            if (n != "This file was created with JabRef".length()) continue;
            bl = false;
            StringBuilder stringBuilder2 = new StringBuilder();
            while ((n2 = this.read()) != 10 && n2 != -1) {
                stringBuilder2.append((char)n2);
            }
            String string = stringBuilder2.toString().trim();
            if (Pattern.compile("[1-9]+\\.[1-9A-Za-z ]+\\.").matcher(string).matches()) {
                return string.substring(0, string.length() - 1);
            }
            if (!Pattern.compile("[1-9]+\\.[1-9]\\.[1-9A-Za-z ]+\\.").matcher(string).matches()) continue;
            return string.substring(0, string.length() - 1);
        }
        return null;
    }

    private void setMajorMinorVersions() {
        String string = this.parserResult.getJabrefVersion();
        Pattern pattern = Pattern.compile("([0-9]+)\\.([0-9]+).*");
        Pattern pattern2 = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+).*");
        Matcher matcher = pattern.matcher(string);
        Matcher matcher2 = pattern2.matcher(string);
        if (matcher.matches() && matcher.groupCount() >= 2) {
            this.parserResult.setJabrefMajorVersion(Integer.parseInt(matcher.group(1)));
            this.parserResult.setJabrefMinorVersion(Integer.parseInt(matcher.group(2)));
        }
        if (matcher2.matches() && matcher2.groupCount() >= 3) {
            this.parserResult.setJabrefMinor2Version(Integer.parseInt(matcher2.group(3)));
        }
    }

    private class NoLabelException
    extends Exception {
        public NoLabelException(String string) {
            super(string);
        }
    }
}

