/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class BiomailImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Biomail";
    }

    @Override
    public String getCLIId() {
        return "biomail";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("BioMail");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        Object object;
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 3) continue;
            if (string.substring(0, 6).equals("PMID- ")) {
                stringBuilder.append("::").append(string);
                continue;
            }
            object = string.substring(0, 6);
            if (((String)object).indexOf(" ") > 0) {
                stringBuilder.append(" ## ");
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append("EOLEOL");
            stringBuilder.append(string.trim());
        }
        object = stringBuilder.toString().split("::");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : object) {
            String[] stringArray = string2.split(" ## ");
            if (stringArray.length == 0) {
                stringArray = string2.split("\n");
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            hashMap.clear();
            for (String string7 : stringArray) {
                String[] stringArray2;
                System.out.println(">>>" + string7 + "<<<");
                if (string7.length() <= 2) continue;
                String string8 = string7.substring(0, 6);
                String string9 = string7.substring(6);
                string9 = string9.trim();
                if (string8.equals("PT  - ")) {
                    string3 = "article";
                    continue;
                }
                if (string8.equals("TY  - ")) {
                    if (!"CONF".equals(string9)) continue;
                    string3 = "inproceedings";
                    continue;
                }
                if (string8.equals("JO  - ")) {
                    hashMap.put("booktitle", string9);
                    continue;
                }
                if (string8.equals("FAU - ")) {
                    stringArray2 = string9.replaceAll("EOLEOL", " and ");
                    if (!"".equals(string6)) {
                        string6 = string6 + " and " + (String)stringArray2;
                        continue;
                    }
                    string6 = stringArray2;
                    continue;
                }
                if (string8.equals("AU  - ")) {
                    stringArray2 = string9.replaceAll("EOLEOL", " and ").replaceAll(" ", ", ");
                    if (!"".equals(string5)) {
                        string5 = string5 + " and " + (String)stringArray2;
                        continue;
                    }
                    string5 = stringArray2;
                    continue;
                }
                if (string8.equals("TI  - ")) {
                    hashMap.put("title", string9.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string8.equals("TA  - ")) {
                    hashMap.put("journal", string9.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string8.equals("AB  - ")) {
                    hashMap.put("abstract", string9.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string8.equals("PG  - ")) {
                    string4 = string9.replaceAll("-", "--");
                    continue;
                }
                if (string8.equals("IP  - ")) {
                    hashMap.put("number", string9);
                    continue;
                }
                if (string8.equals("DP  - ")) {
                    stringArray2 = string9.split(" ");
                    hashMap.put("year", stringArray2[0]);
                    continue;
                }
                if (string8.equals("VI  - ")) {
                    hashMap.put("volume", string9);
                    continue;
                }
                if (!string8.equals("AID - ") || !"[doi]".equals((stringArray2 = string9.split(" "))[1])) continue;
                hashMap.put("doi", stringArray2[0]);
                hashMap.put("url", "http://dx.doi.org/" + stringArray2[0]);
            }
            if (!"".equals(string4)) {
                hashMap.put("pages", string4);
            }
            if (!"".equals(string6)) {
                hashMap.put("author", string6);
            } else if (!"".equals(string5)) {
                hashMap.put("author", string5);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string3));
            bibtexEntry.setField(hashMap);
            if (hashMap.get("author") == null && hashMap.get("title") == null) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

