/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class CopacImporter
extends ImportFormat {
    private static final Pattern copacPattern = Pattern.compile("^\\s*TI- ");

    @Override
    public String getFormatName() {
        return "Copac";
    }

    @Override
    public String getCLIId() {
        return "cpc";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (!copacPattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        Object object;
        if (inputStream == null) {
            throw new IOException("No stream given.");
        }
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        LinkedList<String> linkedList = new LinkedList<String>();
        Object object2 = new StringBuffer();
        while ((object = bufferedReader.readLine()) != null) {
            if (((String)object).length() < 4) continue;
            String string = ((String)object).substring(0, 4);
            if (string.equals("    ")) {
                ((StringBuffer)object2).append(" ").append(((String)object).trim());
                continue;
            }
            if (((String)object).substring(0, 4).equals("TI- ")) {
                if (((StringBuffer)object2).length() > 0) {
                    linkedList.add(((StringBuffer)object2).toString());
                }
                object2 = new StringBuffer();
            }
            ((StringBuffer)object2).append('\n').append((String)object);
        }
        if (((StringBuffer)object2).length() > 0) {
            linkedList.add(((StringBuffer)object2).toString());
        }
        object = new LinkedList();
        for (String string : linkedList) {
            String[] stringArray;
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", BibtexEntryTypes.BOOK);
            for (String string2 : stringArray = string.split("\n")) {
                String string3 = string2.trim();
                if (string3.length() < 4) continue;
                String string4 = string3.substring(0, 4);
                if (string4.equals("TI- ")) {
                    this.setOrAppend(bibtexEntry, "title", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("AU- ")) {
                    this.setOrAppend(bibtexEntry, "author", string3.substring(4).trim(), " and ");
                    continue;
                }
                if (string4.equals("PY- ")) {
                    this.setOrAppend(bibtexEntry, "year", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("PU- ")) {
                    this.setOrAppend(bibtexEntry, "publisher", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("SE- ")) {
                    this.setOrAppend(bibtexEntry, "series", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("IS- ")) {
                    this.setOrAppend(bibtexEntry, "isbn", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("KW- ")) {
                    this.setOrAppend(bibtexEntry, "keywords", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("NT- ")) {
                    this.setOrAppend(bibtexEntry, "note", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("PD- ")) {
                    this.setOrAppend(bibtexEntry, "physicaldimensions", string3.substring(4).trim(), ", ");
                    continue;
                }
                if (string4.equals("DT- ")) {
                    this.setOrAppend(bibtexEntry, "documenttype", string3.substring(4).trim(), ", ");
                    continue;
                }
                this.setOrAppend(bibtexEntry, string4.substring(0, 2), string3.substring(4).trim(), ", ");
            }
            object.add(bibtexEntry);
        }
        return object;
    }

    private void setOrAppend(BibtexEntry bibtexEntry, String string, String string2, String string3) {
        String string4 = bibtexEntry.getField(string);
        if (string4 != null) {
            bibtexEntry.setField(string, string4 + string3 + string2);
        } else {
            bibtexEntry.setField(string, string2);
        }
    }
}

