/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.UnitFormatter;
import net.sf.jabref.util.Util;

public class DOItoBibTeXFetcher
implements EntryFetcher {
    private static final String URL_PATTERN = "http://dx.doi.org/%s";
    private final CaseKeeper caseKeeper = new CaseKeeper();
    private final UnitFormatter unitFormatter = new UnitFormatter();

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        BibtexEntry bibtexEntry = this.getEntryFromDOI(string, outputPrinter);
        if (bibtexEntry != null) {
            importInspector.addEntry(bibtexEntry);
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "DOI to BibTeX";
    }

    @Override
    public String getKeyName() {
        return "DOItoBibTeX";
    }

    @Override
    public String getHelpPage() {
        return "DOItoBibTeXHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    private BibtexEntry getEntryFromDOI(String string, OutputPrinter outputPrinter) {
        String string2;
        String string3;
        URLConnection uRLConnection;
        URL uRL;
        String string4;
        try {
            string4 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        String string5 = String.format(URL_PATTERN, string4);
        try {
            uRL = new URL(string5);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        uRLConnection.setRequestProperty("Accept", "application/x-bibtex");
        try {
            string3 = Util.getResultsWithEncoding(uRLConnection, "UTF8");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (outputPrinter != null) {
                outputPrinter.showMessage(Globals.lang("Unknown DOI: '%0'.", string), Globals.lang("Get BibTeX entry from DOI"), 1);
            }
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        string3 = string3.replaceAll("(pages=\\{[0-9]+)\u2013([0-9]+\\})", "$1--$2");
        BibtexEntry bibtexEntry = BibtexParser.singleFromString(string3);
        if (bibtexEntry != null && (string2 = bibtexEntry.getField("title")) != null) {
            if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                string2 = this.unitFormatter.format(string2);
            }
            if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                string2 = this.caseKeeper.format(string2);
            }
            bibtexEntry.setField("title", string2);
        }
        return bibtexEntry;
    }
}

