/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.imports.EntryFromExternalFileCreator;
import net.sf.jabref.imports.EntryFromFileCreator;
import net.sf.jabref.imports.EntryFromPDFCreator;
import net.sf.jabref.undo.UndoableInsertEntry;

public final class EntryFromFileCreatorManager {
    private final List<EntryFromFileCreator> entryCreators = new ArrayList<EntryFromFileCreator>(10);

    public EntryFromFileCreatorManager() {
        ExternalFileType[] externalFileTypeArray;
        this.entryCreators.add(new EntryFromPDFCreator());
        for (ExternalFileType externalFileType : externalFileTypeArray = JabRefPreferences.getInstance().getExternalFileTypeSelection()) {
            if (this.hasSpecialisedCreatorForExternalFileType(externalFileType)) continue;
            this.entryCreators.add(new EntryFromExternalFileCreator(externalFileType));
        }
    }

    private boolean hasSpecialisedCreatorForExternalFileType(ExternalFileType externalFileType) {
        for (EntryFromFileCreator entryFromFileCreator : this.entryCreators) {
            if (entryFromFileCreator.getExternalFileType() == null || entryFromFileCreator.getExternalFileType().getExtension() == null || !entryFromFileCreator.getExternalFileType().getExtension().equals(externalFileType.getExtension())) continue;
            return true;
        }
        return false;
    }

    public EntryFromFileCreator getEntryCreator(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        for (EntryFromFileCreator entryFromFileCreator : this.entryCreators) {
            if (!entryFromFileCreator.accept(file)) continue;
            return entryFromFileCreator;
        }
        return null;
    }

    public List<String> addEntrysFromFiles(List<File> list, BibtexDatabase bibtexDatabase, BibtexEntryType bibtexEntryType, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        this.addEntriesFromFiles(list, bibtexDatabase, null, bibtexEntryType, bl, null, linkedList);
        return linkedList;
    }

    public int addEntriesFromFiles(List<File> list, BibtexDatabase bibtexDatabase, BasePanel basePanel, BibtexEntryType bibtexEntryType, boolean bl, ChangeListener changeListener, List<String> list2) {
        int n = 0;
        CompoundEdit compoundEdit = new CompoundEdit();
        for (File file : list) {
            EntryFromFileCreator entryFromFileCreator = this.getEntryCreator(file);
            if (entryFromFileCreator != null) {
                BibtexEntry bibtexEntry = entryFromFileCreator.createEntry(file, bl);
                if (bibtexEntry == null) {
                    list2.add("Problem importing " + file.getPath() + ": Entry could not be created.");
                    continue;
                }
                if (bibtexEntryType != null) {
                    bibtexEntry.setType(bibtexEntryType);
                }
                if (bibtexEntry.getId() == null) {
                    bibtexEntry.setId(IdGenerator.next());
                }
                if (bibtexDatabase.getEntryById(bibtexEntry.getId()) == null) {
                    if (bibtexDatabase.insertEntry(bibtexEntry)) {
                        list2.add("Problem importing " + file.getPath() + ": Insert into BibtexDatabase failed.");
                    } else {
                        ++n;
                        if (basePanel != null) {
                            compoundEdit.addEdit(new UndoableInsertEntry(bibtexDatabase, bibtexEntry, basePanel));
                        }
                    }
                }
            } else {
                list2.add("Problem importing " + file.getPath() + ": Unknown filetype.");
            }
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(this));
        }
        System.out.println("count = " + n);
        if (n > 0 && basePanel != null) {
            System.out.println("adding edit");
            compoundEdit.end();
            basePanel.undoManager.addEdit(compoundEdit);
        }
        return n;
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (EntryFromFileCreator entryFromFileCreator : EntryFromFileCreatorManager.this.entryCreators) {
                    if (!entryFromFileCreator.accept(file)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "All external files";
            }
        };
    }

    public List<FileFilter> getFileFilterList() {
        ArrayList<FileFilter> arrayList = new ArrayList<FileFilter>();
        arrayList.add(this.getFileFilter());
        for (FileFilter fileFilter : this.entryCreators) {
            arrayList.add(fileFilter);
        }
        return arrayList;
    }
}

