/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class FreeCiteImporter
extends ImportFormat {
    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string = new Scanner(inputStream).useDelimiter("\\A").next();
        return this.importEntries(string, outputPrinter);
    }

    public List<BibtexEntry> importEntries(String string, OutputPrinter outputPrinter) {
        Object object;
        URLConnection uRLConnection;
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String string3 = "citation=" + string2;
        try {
            URL uRL = new URL("http://freecite.library.brown.edu/citations/create");
            uRLConnection = uRL.openConnection();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            uRLConnection.setRequestProperty("accept", "text/xml");
            uRLConnection.setDoOutput(true);
            object = new OutputStreamWriter(uRLConnection.getOutputStream());
            ((Writer)object).write(string3);
            ((OutputStreamWriter)object).flush();
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang("Unable to connect to freecite online service."));
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        object = new ArrayList();
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(uRLConnection.getInputStream());
            while (xMLStreamReader.hasNext()) {
                if (xMLStreamReader.getEventType() == 1 && xMLStreamReader.getLocalName().equals("citation")) {
                    String string4;
                    xMLStreamReader.nextTag();
                    StringBuilder stringBuilder = new StringBuilder();
                    BibtexEntry bibtexEntry = new BibtexEntry();
                    BibtexEntryType bibtexEntryType = BibtexEntryTypes.INPROCEEDINGS;
                    while (xMLStreamReader.getEventType() != 2 || !xMLStreamReader.getLocalName().equals("citation")) {
                        if (xMLStreamReader.getEventType() == 1) {
                            CharSequence charSequence;
                            string4 = xMLStreamReader.getLocalName();
                            if (string4.equals("authors")) {
                                charSequence = new StringBuilder();
                                xMLStreamReader.nextTag();
                                while (xMLStreamReader.getEventType() == 1) {
                                    assert (xMLStreamReader.getLocalName().equals("author"));
                                    String string5 = xMLStreamReader.getElementText();
                                    if (((StringBuilder)charSequence).length() == 0) {
                                        ((StringBuilder)charSequence).append(string5);
                                    } else {
                                        ((StringBuilder)charSequence).append(" and ");
                                        ((StringBuilder)charSequence).append(string5);
                                    }
                                    assert (xMLStreamReader.getEventType() == 2);
                                    assert (xMLStreamReader.getLocalName().equals("author"));
                                    xMLStreamReader.nextTag();
                                }
                                bibtexEntry.setField("author", ((StringBuilder)charSequence).toString());
                            } else if (string4.equals("journal")) {
                                bibtexEntryType = BibtexEntryTypes.ARTICLE;
                                bibtexEntry.setField(string4, xMLStreamReader.getElementText());
                            } else if (string4.equals("tech")) {
                                bibtexEntryType = BibtexEntryTypes.TECHREPORT;
                                bibtexEntry.setField("number", xMLStreamReader.getElementText());
                            } else if (string4.equals("doi") || string4.equals("institution") || string4.equals("location") || string4.equals("number") || string4.equals("note") || string4.equals("title") || string4.equals("pages") || string4.equals("publisher") || string4.equals("volume") || string4.equals("year")) {
                                bibtexEntry.setField(string4, xMLStreamReader.getElementText());
                            } else if (string4.equals("booktitle")) {
                                charSequence = xMLStreamReader.getElementText();
                                if (((String)charSequence).startsWith("In ")) {
                                    charSequence = ((String)charSequence).substring(3);
                                }
                                bibtexEntry.setField("booktitle", (String)charSequence);
                            } else if (!string4.equals("raw_string")) {
                                stringBuilder.append(string4);
                                stringBuilder.append(":");
                                stringBuilder.append(xMLStreamReader.getElementText());
                                stringBuilder.append(Globals.NEWLINE);
                            }
                        }
                        xMLStreamReader.next();
                    }
                    if (stringBuilder.length() > 0) {
                        string4 = bibtexEntry.getField("note");
                        string4 = string4 != null ? string4.concat(Globals.NEWLINE).concat(stringBuilder.toString()) : stringBuilder.toString();
                        bibtexEntry.setField("note", string4);
                    }
                    bibtexEntry.setType(bibtexEntryType);
                    bibtexEntry = LabelPatternUtil.makeLabel(JabRef.jrf.basePanel().metaData(), JabRef.jrf.basePanel().database(), bibtexEntry);
                    object.add(bibtexEntry);
                }
                xMLStreamReader.next();
            }
            xMLStreamReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return object;
    }

    @Override
    public String getFormatName() {
        return "text citations";
    }
}

