/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.gui.FetcherPreviewDialog;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PreviewEntryFetcher;
import net.sf.jabref.net.URLDownload;

public class GoogleScholarFetcher
implements PreviewEntryFetcher {
    private boolean hasRunConfig = false;
    private static final int MAX_ENTRIES_TO_LOAD = 50;
    private static final String QUERY_MARKER = "___QUERY___";
    private static final String URL_START = "http://scholar.google.com";
    private static final String URL_SETTING = "http://scholar.google.com/scholar_settings";
    private static final String URL_SETPREFS = "http://scholar.google.com/scholar_setprefs";
    private static final String SEARCH_URL = "http://scholar.google.com/scholar?q=___QUERY___&amp;hl=en&amp;btnG=Search";
    private static final Pattern BIBTEX_LINK_PATTERN = Pattern.compile("<a href=\"([^\"]*)\"[^>]*>[A-Za-z ]*BibTeX");
    private static final Pattern TITLE_START_PATTERN = Pattern.compile("<div class=\"gs_ri\">");
    private static final Pattern LINK_PATTERN = Pattern.compile("<h3 class=\"gs_rt\"><a href=\"([^\"]*)\">");
    private static final Pattern TITLE_END_PATTERN = Pattern.compile("<div class=\"gs_fl\">");
    private final HashMap<String, String> entryLinks = new HashMap();
    private boolean stopFetching = false;
    private static final Pattern inputPattern = Pattern.compile("<input type=([^ ]+) name=([^ ]+) value=([^> ]+)");

    @Override
    public int getWarningLimit() {
        return 10;
    }

    @Override
    public int getPreferredPreviewHeight() {
        return 100;
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        return false;
    }

    @Override
    public boolean processQueryGetPreview(String string, FetcherPreviewDialog fetcherPreviewDialog, OutputPrinter outputPrinter) {
        this.entryLinks.clear();
        this.stopFetching = false;
        try {
            if (!this.hasRunConfig) {
                this.runConfig();
                this.hasRunConfig = true;
            }
            Map<String, JLabel> map = this.getCitations(string);
            for (String string2 : map.keySet()) {
                fetcherPreviewDialog.addEntry(string2, map.get(string2));
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            outputPrinter.showMessage(Globals.lang("Error fetching from Google Scholar"));
            return false;
        }
    }

    @Override
    public void getEntries(Map<String, Boolean> map, ImportInspector importInspector) {
        boolean bl;
        int n = 0;
        int n2 = 0;
        for (String string : map.keySet()) {
            bl = map.get(string);
            if (!bl) continue;
            ++n;
        }
        if (n == 0) {
            return;
        }
        for (String string : map.keySet()) {
            if (this.stopFetching) break;
            importInspector.setProgress(n2, n);
            bl = map.get(string);
            if (!bl) continue;
            ++n2;
            try {
                BibtexEntry bibtexEntry = this.downloadEntry(string);
                importInspector.addEntry(bibtexEntry);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public String getTitle() {
        return "Google Scholar";
    }

    @Override
    public String getKeyName() {
        return "Google Scholar";
    }

    @Override
    public String getHelpPage() {
        return "GoogleScholarHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    private void save(String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        bufferedWriter.write(string2);
        bufferedWriter.close();
    }

    private void runConfig() throws IOException {
        try {
            new URLDownload(new URL(URL_START)).downloadToString();
            String string = new URLDownload(new URL(URL_SETTING)).downloadToString();
            HashMap<String, String> hashMap = GoogleScholarFetcher.getFormElements(string);
            hashMap.put("scis", "yes");
            hashMap.put("scisf", "4");
            hashMap.put("num", String.valueOf(50));
            StringBuilder stringBuilder = new StringBuilder("http://scholar.google.com/scholar_setprefs?");
            Iterator<String> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                stringBuilder.append(string2).append("=").append(hashMap.get(string2));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("&");
            }
            stringBuilder.append("&submit=");
            new URLDownload(new URL(stringBuilder.toString())).downloadToString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    private Map<String, JLabel> getCitations(String string) throws IOException {
        LinkedHashMap<String, JLabel> linkedHashMap = new LinkedHashMap<String, JLabel>();
        try {
            String string2;
            String string3 = SEARCH_URL.replace(QUERY_MARKER, URLEncoder.encode(string, "UTF-8"));
            for (int i = 1; (string2 = this.getCitationsFromUrl(string3, linkedHashMap)) != null && i < 2; ++i) {
                string3 = string2;
                if (!this.stopFetching) continue;
            }
            return linkedHashMap;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private String getCitationsFromUrl(String string, Map<String, JLabel> map) throws IOException {
        URL uRL = new URL(string);
        String string2 = new URLDownload(uRL).downloadToString();
        Matcher matcher = BIBTEX_LINK_PATTERN.matcher(string2);
        int n = 0;
        while (matcher.find()) {
            String string3 = matcher.group(1).replaceAll("&amp;", "&");
            String string4 = string2.substring(n, matcher.start());
            Matcher matcher2 = TITLE_START_PATTERN.matcher(string4);
            Matcher matcher3 = TITLE_END_PATTERN.matcher(string4);
            boolean bl = matcher2.find();
            boolean bl2 = matcher3.find();
            String string5 = bl && bl2 ? (matcher2.end() < matcher3.start() ? string4.substring(matcher2.end(), matcher3.start()) : string4) : string3;
            string5 = string5.replaceAll("\\[PDF\\]", "");
            JLabel jLabel = new JLabel("<html>" + string5 + "</html>");
            map.put(string3, jLabel);
            Matcher matcher4 = LINK_PATTERN.matcher(string5);
            if (matcher4.find()) {
                this.entryLinks.put(string3, matcher4.group(1));
            }
            n = matcher.end();
        }
        return null;
    }

    private BibtexEntry downloadEntry(String string) throws IOException {
        try {
            URL uRL = new URL(URL_START + string);
            String string2 = new URLDownload(uRL).downloadToString();
            BibtexParser bibtexParser = new BibtexParser(new StringReader(string2));
            ParserResult parserResult = bibtexParser.parse();
            if (parserResult != null && parserResult.getDatabase() != null) {
                Collection<BibtexEntry> collection = parserResult.getDatabase().getEntries();
                if (collection.size() == 1) {
                    String string3;
                    String string4;
                    BibtexEntry bibtexEntry = collection.iterator().next();
                    boolean bl = true;
                    if (bl) {
                        bibtexEntry.setField("bibtexkey", null);
                    }
                    if (bibtexEntry.getField("url") == null && (string4 = this.entryLinks.get(string)) != null) {
                        bibtexEntry.setField("url", string4);
                    }
                    if ((string4 = bibtexEntry.getField("title")) != null && !(string3 = string4.replaceAll("<.?i>([^<]*)</i>", "$1")).equals(string4)) {
                        bibtexEntry.setField("title", string3);
                    }
                    return bibtexEntry;
                }
                if (collection.size() == 0) {
                    System.out.println("No entry found! (" + string + ")");
                    return null;
                }
                System.out.println(collection.size() + " entries found! (" + string + ")");
                return null;
            }
            System.out.println("Parser failed! (" + string + ")");
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private static HashMap<String, String> getFormElements(String string) {
        Matcher matcher = inputPattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group(2);
            if (string3.length() > 2 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if ((string2 = matcher.group(3)).length() > 2 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }
}

