/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.imports.ImportFileFilter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportMenuItem;

public class ImportFormats {
    private static JFileChooser createImportFileChooser(String string) {
        SortedSet<ImportFormat> sortedSet = Globals.importFormatReader.getImportFormats();
        String string2 = Globals.prefs.get("lastUsedImport");
        ImportFileFilter importFileFilter = null;
        JFileChooser jFileChooser = new JFileChooser(string);
        TreeSet<ImportFileFilter> treeSet = new TreeSet<ImportFileFilter>();
        for (ImportFormat comparable : sortedSet) {
            ImportFileFilter importFileFilter2 = new ImportFileFilter(comparable);
            treeSet.add(importFileFilter2);
            if (!comparable.getFormatName().equals(string2)) continue;
            importFileFilter = importFileFilter2;
        }
        for (ImportFileFilter importFileFilter3 : treeSet) {
            jFileChooser.addChoosableFileFilter(importFileFilter3);
        }
        if (importFileFilter != null) {
            jFileChooser.setFileFilter(importFileFilter);
        } else {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        return jFileChooser;
    }

    public static AbstractAction getImportAction(JabRefFrame jabRefFrame, boolean bl) {
        class ImportAction
        extends MnemonicAwareAction {
            private final JabRefFrame frame;
            private final boolean openInNew;

            public ImportAction(JabRefFrame jabRefFrame, boolean bl) {
                this.frame = jabRefFrame;
                this.openInNew = bl;
                this.putValue("Name", bl ? "Import into new database" : "Import into current database");
                this.putValue("AcceleratorKey", bl ? Globals.prefs.getKey("Import into new database") : Globals.prefs.getKey("Import into current database"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = ImportFormats.createImportFileChooser(Globals.prefs.get("workingDirectory"));
                jFileChooser.showOpenDialog(this.frame);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                FileFilter fileFilter = jFileChooser.getFileFilter();
                ImportFormat importFormat = null;
                if (fileFilter instanceof ImportFileFilter) {
                    importFormat = ((ImportFileFilter)fileFilter).getImportFormat();
                }
                try {
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("File not found") + ": '" + file.getName() + "'.", Globals.lang("Import"), 0);
                        return;
                    }
                    ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, this.openInNew, importFormat);
                    importMenuItem.automatedImport(new String[]{file.getAbsolutePath()});
                    if (importFormat != null) {
                        Globals.prefs.put("lastUsedImport", importFormat.getFormatName());
                    } else {
                        Globals.prefs.put("lastUsedImport", "__all");
                    }
                    Globals.prefs.put("importWorkingDirectory", file.getParent());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return new ImportAction(jabRefFrame, bl);
    }
}

