/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

public class ImportInspectionCommandLine
implements ImportInspector {
    private final List<BibtexEntry> entries = new LinkedList<BibtexEntry>();
    private final OutputPrinter status = new OutputPrinter(){

        @Override
        public void setStatus(String string) {
            System.out.println(string);
        }

        @Override
        public void showMessage(Object object, String string, int n) {
            System.out.println(string + ": " + object);
        }

        @Override
        public void showMessage(String string) {
            System.out.println(string);
        }
    };

    @Override
    public void addEntry(BibtexEntry bibtexEntry) {
        this.entries.add(bibtexEntry);
    }

    @Override
    public void setProgress(int n, int n2) {
        this.status.setStatus(Globals.lang("Progress: %0 of %1", String.valueOf(n), String.valueOf(n2)));
    }

    public Collection<BibtexEntry> query(String string, EntryFetcher entryFetcher) {
        this.entries.clear();
        if (entryFetcher.processQuery(string, this, this.status)) {
            return this.entries;
        }
        return null;
    }

    @Override
    public void toFront() {
    }
}

