/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

public class JSTORFetcher
implements EntryFetcher {
    private static final int MAX_CITATIONS = 200;
    private static final String COOKIE_TICKET = "Jstor_Ticket";
    private static final String URL_TICKET = "http://www.jstor.org/search";
    private static final String COOKIE_CITATIONS = "Jstor_citations0";
    private static final String URL_BIBTEX = "http://www.jstor.org/browse/citations.txt?exportFormat=bibtex&exportAction=Display&frame=noframe&dpi=3&config=jstor&viewCitations=1&View=View";

    @Override
    public String getHelpPage() {
        return "JSTOR.html";
    }

    @Override
    public String getKeyName() {
        return "JSTOR";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "JSTOR";
    }

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        try {
            String string2 = this.openTicket();
            String string3 = this.getCitations(string2, string);
            Collection<BibtexEntry> collection = this.getBibtexEntries(string2, string3);
            if (collection.size() == 0) {
                outputPrinter.showMessage(Globals.lang("No entries found for the search string '%0'", string), Globals.lang("Search JSTOR"), 1);
                return false;
            }
            for (BibtexEntry bibtexEntry : collection) {
                importInspector.addEntry(bibtexEntry);
            }
            return true;
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang("Error while fetching from JSTOR") + ": " + iOException.getMessage());
            return false;
        }
    }

    private Collection<BibtexEntry> getBibtexEntries(String string, String string2) throws IOException {
        try {
            URL uRL = new URL(URL_BIBTEX);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("Cookie", string + "; " + string2);
            uRLConnection.connect();
            BibtexParser bibtexParser = new BibtexParser(new BufferedReader(new InputStreamReader(uRLConnection.getInputStream())));
            return bibtexParser.parse().getDatabase().getEntries();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private String openTicket() throws IOException {
        URL uRL = new URL(URL_TICKET);
        URLConnection uRLConnection = uRL.openConnection();
        return JSTORFetcher.getCookie(COOKIE_TICKET, uRLConnection);
    }

    private String getCitations(String string, String string2) throws IOException {
        String string3;
        try {
            string3 = "http://www.jstor.org/search/BasicResults?hp=200&si=1&gw=jtx&jtxsi=1&jcpsi=1&artsi=1&Query=" + URLEncoder.encode(string2, "UTF-8") + "&wc=on&citationAction=saveAll";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        URL uRL = new URL(string3);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Cookie", string);
        return JSTORFetcher.getCookie(COOKIE_CITATIONS, uRLConnection);
    }

    private static String getCookie(String string, URLConnection uRLConnection) {
        int n = 0;
        while (true) {
            String string2 = uRLConnection.getHeaderFieldKey(n);
            String string3 = uRLConnection.getHeaderField(n);
            if (string2 == null && string3 == null) break;
            if (string2 != null && string2.equals("Set-Cookie") && string3.startsWith(string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "; ");
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!string4.startsWith(string)) continue;
                    return string4;
                }
            }
            ++n;
        }
        return null;
    }
}

