/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.msbib.MSBibDatabase;
import org.w3c.dom.Document;

public class MsBibImporter
extends ImportFormat {
    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        Document document;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            return false;
        }
        return document == null || document.getDocumentElement().getTagName().contains("Sources");
    }

    public String getCommandLineId() {
        return "msbib";
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        MSBibDatabase mSBibDatabase = new MSBibDatabase();
        return mSBibDatabase.importEntries(inputStream);
    }

    @Override
    public String getFormatName() {
        return "MSBib";
    }
}

