/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.DOItoBibTeXFetcher;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.util.DOIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;

public class PdfContentImporter
extends ImportFormat {
    private static final Log LOGGER = LogFactory.getLog(PdfContentImporter.class);
    private static final DOItoBibTeXFetcher doiToBibTeXFetcher = new DOItoBibTeXFetcher();
    private String[] split;
    private int i;
    private String curString;
    private String year = null;

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return false;
    }

    private String removeNonLettersAtEnd(String string) {
        if ((string = string.trim()).length() == 0) {
            return string;
        }
        char c = string.charAt(string.length() - 1);
        while (!Character.isLetter(c) && c != ')' && (string = string.substring(0, string.length() - 1)).length() > 0) {
            c = string.charAt(string.length() - 1);
        }
        return string;
    }

    private String streamlineNames(String string) {
        String string2;
        if (string.contains(",")) {
            String[] stringArray = string.split(",");
            string2 = "";
            boolean bl = true;
            for (String string3 : stringArray) {
                String string4 = this.removeNonLettersAtEnd(string3);
                if (string4.indexOf("and") == 0) {
                    string4 = string4.substring(3).trim();
                } else {
                    int n = string4.indexOf(" and ");
                    if (n >= 0) {
                        String string5 = string4.substring(0, n);
                        string2 = string2.concat(" and ").concat(this.removeNonLettersAtEnd(string5));
                        string4 = string4.substring(n + 5);
                    }
                }
                if (string4.equals("")) continue;
                if (string4.equalsIgnoreCase("et al.")) {
                    string4 = "others";
                }
                if (bl) {
                    bl = false;
                } else {
                    string2 = string2.concat(" and ");
                }
                string2 = string2.concat(string4);
            }
        } else {
            String[] stringArray = string.split(" ");
            if (stringArray.length == 0) {
                return "";
            }
            boolean bl = false;
            boolean bl2 = true;
            int n = 0;
            string2 = "";
            do {
                if (!bl) {
                    if (stringArray[n].equalsIgnoreCase("and")) continue;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        string2 = string2.concat(" and ");
                    }
                    if (stringArray[n].equalsIgnoreCase("et") && stringArray.length > n + 1 && stringArray[n + 1].equalsIgnoreCase("al.")) {
                        string2 = string2.concat("others");
                        break;
                    }
                    string2 = string2.concat(stringArray[n]).concat(" ");
                    bl = true;
                    continue;
                }
                if (stringArray[n].contains(".")) {
                    string2 = string2.concat(stringArray[n]).concat(" ");
                    continue;
                }
                string2 = string2.concat(this.removeNonLettersAtEnd(stringArray[n]));
                if (stringArray[n].length() > 0 && Character.isLowerCase(stringArray[n].charAt(0))) {
                    string2 = string2.concat(" ");
                    continue;
                }
                bl = false;
            } while (++n < stringArray.length);
        }
        return string2;
    }

    private String streamlineTitle(String string) {
        return this.removeNonLettersAtEnd(string);
    }

    private boolean isYear(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        PDDocument pDDocument;
        final ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>(1);
        try {
            pDDocument = PDDocument.load(inputStream);
        }
        catch (IOException iOException) {
            LOGGER.error("Could not load document", iOException);
            return arrayList;
        }
        try {
            String string;
            Object object;
            if (pDDocument.isEncrypted()) {
                LOGGER.error(Globals.lang("Encrypted documents are not supported"));
            }
            PDFTextStripper pDFTextStripper = new PDFTextStripper();
            pDFTextStripper.setStartPage(1);
            pDFTextStripper.setEndPage(1);
            pDFTextStripper.setSortByPosition(true);
            pDFTextStripper.setParagraphEnd(System.getProperty("line.separator"));
            StringWriter stringWriter = new StringWriter();
            pDFTextStripper.writeText(pDDocument, (Writer)stringWriter);
            String string2 = stringWriter.toString();
            String string3 = DOIUtil.getDOI(string2);
            if (string3.length() < string2.length()) {
                object = new ImportInspector(){

                    @Override
                    public void toFront() {
                    }

                    @Override
                    public void setProgress(int n, int n2) {
                    }

                    @Override
                    public void addEntry(BibtexEntry bibtexEntry) {
                        arrayList.add(bibtexEntry);
                    }
                };
                doiToBibTeXFetcher.processQuery(string3, (ImportInspector)object, outputPrinter);
                if (arrayList.size() != 0) {
                    ArrayList<BibtexEntry> arrayList2 = arrayList;
                    return arrayList2;
                }
            }
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            BibtexEntryType bibtexEntryType = BibtexEntryTypes.INPROCEEDINGS;
            String string15 = System.getProperty("line.separator");
            this.split = string2.split(string15);
            this.proceedToNextNonEmptyLine();
            if (this.i >= this.split.length) {
                ArrayList<BibtexEntry> arrayList3 = arrayList;
                return arrayList3;
            }
            this.curString = this.split[this.i];
            ++this.i;
            if (this.curString.length() > 4) {
                this.extractYear();
                if (this.curString.contains("Conference")) {
                    this.fillCurStringWithNonEmptyLines();
                    string8 = this.curString;
                    this.curString = "";
                } else {
                    string = this.curString.toLowerCase();
                    if (string.contains("copyright")) {
                        this.fillCurStringWithNonEmptyLines();
                        string14 = this.curString;
                        this.curString = "";
                    }
                }
            }
            this.fillCurStringWithNonEmptyLines();
            String string16 = this.streamlineTitle(this.curString);
            this.curString = "";
            object = null;
            while (this.i < this.split.length && !this.split[this.i].equals("")) {
                this.curString = this.streamlineNames(this.split[this.i]);
                if (object == null) {
                    object = this.curString;
                } else if (!this.curString.equals("")) {
                    object = ((String)object).concat(" and ").concat(this.curString);
                }
                ++this.i;
            }
            this.curString = "";
            ++this.i;
            while (this.i < this.split.length) {
                this.curString = this.split[this.i];
                if (this.curString.length() >= "Abstract".length() && this.curString.substring(0, "Abstract".length()).equalsIgnoreCase("Abstract")) {
                    this.curString = this.curString.length() == "Abstract".length() ? "" : this.curString.substring("Abstract".length() + 1).trim().concat(string15);
                    ++this.i;
                    while (this.i < this.split.length && !this.split[this.i].equals("")) {
                        this.curString = this.curString.concat(this.split[this.i]).concat(string15);
                        ++this.i;
                    }
                    string6 = this.curString;
                    ++this.i;
                    continue;
                }
                if (this.curString.length() >= "Keywords".length() && this.curString.substring(0, "Keywords".length()).equalsIgnoreCase("Keywords")) {
                    this.curString = this.curString.length() == "Keywords".length() ? "" : this.curString.substring("Keywords".length() + 1).trim();
                    ++this.i;
                    this.fillCurStringWithNonEmptyLines();
                    string7 = this.removeNonLettersAtEnd(this.curString);
                    continue;
                }
                string = this.curString.toLowerCase();
                int n = string.indexOf("technical");
                if (n >= 0) {
                    bibtexEntryType = BibtexEntryTypes.TECHREPORT;
                    n = this.curString.trim().lastIndexOf(32);
                    if (n >= 0) {
                        string12 = this.curString.substring(n + 1);
                    }
                }
                ++this.i;
                this.proceedToNextNonEmptyLine();
            }
            this.i = this.split.length - 1;
            while (this.i >= 0) {
                this.readLastBlock();
                this.extractYear();
                int n = this.curString.indexOf("(Eds.)");
                if (n >= 0 && string14 == null) {
                    string14 = "Springer";
                    string4 = this.streamlineNames(this.curString.substring(0, n - 1));
                    this.curString = this.curString.substring(n + "(Eds.)".length() + 2);
                    String[] stringArray = this.curString.split(", ");
                    if (stringArray.length < 4) continue;
                    string8 = stringArray[0];
                    String string17 = stringArray[1];
                    int n2 = string17.lastIndexOf(32);
                    string10 = string17.substring(0, n2);
                    string11 = string17.substring(n2 + 1);
                    string13 = stringArray[2].substring(4);
                    if (stringArray[3].length() < 4) continue;
                    this.year = stringArray[3].substring(0, 4);
                    continue;
                }
                if (string9 == null) {
                    n = this.curString.indexOf("DOI");
                    if (n < 0) {
                        n = this.curString.indexOf("doi");
                    }
                    if (n >= 0) {
                        int n3;
                        char c = this.curString.charAt(n += 3);
                        if (c == ':' || c == ' ') {
                            ++n;
                        }
                        string9 = (n3 = this.curString.indexOf(32, n)) > 0 ? this.curString.substring(n, n3) : this.curString.substring(n);
                    }
                }
                if (string14 != null || !this.curString.contains("IEEE")) continue;
                string14 = "IEEE";
                if (string8 != null || (n = this.curString.indexOf(36)) <= 0) continue;
                n -= 2;
                while (n >= 0 && this.curString.charAt(n) != ' ') {
                    --n;
                }
                if (n <= 0) continue;
                string8 = this.curString.substring(0, n);
            }
            BibtexEntry bibtexEntry = new BibtexEntry();
            bibtexEntry.setType(bibtexEntryType);
            if (object != null) {
                bibtexEntry.setField("author", (String)object);
            }
            if (string4 != null) {
                bibtexEntry.setField("editor", string4);
            }
            if (string5 != null) {
                bibtexEntry.setField("institution", string5);
            }
            if (string6 != null) {
                bibtexEntry.setField("abstract", string6);
            }
            if (string7 != null) {
                bibtexEntry.setField("keywords", string7);
            }
            if (string16 != null) {
                bibtexEntry.setField("title", string16);
            }
            if (string8 != null) {
                bibtexEntry.setField("booktitle", string8);
            }
            if (string9 != null) {
                bibtexEntry.setField("doi", string9);
            }
            if (string10 != null) {
                bibtexEntry.setField("series", string10);
            }
            if (string11 != null) {
                bibtexEntry.setField("volume", string11);
            }
            if (string12 != null) {
                bibtexEntry.setField("number", string12);
            }
            if (string13 != null) {
                bibtexEntry.setField("pages", string13);
            }
            if (this.year != null) {
                bibtexEntry.setField("year", this.year);
            }
            if (string14 != null) {
                bibtexEntry.setField("publisher", string14);
            }
            bibtexEntry.setField("review", string2);
            arrayList.add(bibtexEntry);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (noClassDefFoundError.getMessage().equals("org/bouncycastle/jce/provider/BouncyCastleProvider")) {
                outputPrinter.showMessage(Globals.lang("Java Bouncy Castle library not found. Please download and install it. For more information see http://www.bouncycastle.org/."));
            } else {
                LOGGER.error("Could not find class", noClassDefFoundError);
            }
        }
        finally {
            pDDocument.close();
        }
        return arrayList;
    }

    private void extractYear() {
        if (this.year != null) {
            return;
        }
        Pattern pattern = Pattern.compile("\\d\\d\\d\\d");
        Matcher matcher = pattern.matcher(this.curString);
        if (matcher.find()) {
            this.year = this.curString.substring(matcher.start(), matcher.end());
        }
    }

    private void proceedToNextNonEmptyLine() {
        while (this.i < this.split.length && this.split[this.i].trim().equals("")) {
            ++this.i;
        }
    }

    private void fillCurStringWithNonEmptyLines() {
        this.curString = this.curString.trim();
        while (this.i < this.split.length && !this.split[this.i].equals("")) {
            String string = this.split[this.i].trim();
            if (!string.equals("")) {
                if (this.curString.length() > 0) {
                    this.curString = this.curString.concat(" ");
                }
                this.curString = this.curString.concat(this.split[this.i]);
            }
            ++this.i;
        }
        this.proceedToNextNonEmptyLine();
    }

    private void readLastBlock() {
        while (this.i >= 0 && this.split[this.i].trim().equals("")) {
            --this.i;
        }
        int n = this.i;
        while (this.i >= 0 && !this.split[this.i].equals("")) {
            --this.i;
        }
        this.curString = "";
        for (int i = this.i + 1; i <= n; ++i) {
            this.curString = this.curString.concat(this.split[i].trim());
            if (i == n) continue;
            this.curString = this.curString.concat(" ");
        }
    }

    @Override
    public String getFormatName() {
        return "PDFcontent";
    }
}

