/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.util.XMPUtil;

public class PdfXmpImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return Globals.lang("XMP-annotated PDF");
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        return XMPUtil.readXMP(inputStream);
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return XMPUtil.hasMetadata(inputStream);
    }

    public String getCommandLineId() {
        return "xmp";
    }
}

