/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.util.MonthUtil;

public class RisImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "RIS";
    }

    @Override
    public String getCLIId() {
        return "ris";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("TY  - .*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String[] stringArray;
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        for (String string2 : stringArray = stringBuilder.toString().replaceAll("\u2013", "-").replaceAll("\u2014", "--").replaceAll("\u2015", "--").split("ER  -.*\\n")) {
            String string3;
            Object object3;
            Serializable serializable;
            if (string2.trim().length() == 0) continue;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = string2.split("\n");
            for (int i = 0; i < stringArray2.length; ++i) {
                Object object2;
                serializable = new StringBuilder(stringArray2[i]);
                boolean bl = false;
                while (!bl && i < stringArray2.length - 1) {
                    if (stringArray2[i + 1].length() >= 6 && !stringArray2[i + 1].substring(2, 6).equals("  - ")) {
                        if (((StringBuilder)serializable).length() > 0 && !Character.isWhitespace(((StringBuilder)serializable).charAt(((StringBuilder)serializable).length() - 1)) && !Character.isWhitespace(stringArray2[i + 1].charAt(0))) {
                            ((StringBuilder)serializable).append(' ');
                        }
                        ((StringBuilder)serializable).append(stringArray2[i + 1]);
                        ++i;
                        continue;
                    }
                    bl = true;
                }
                object3 = ((StringBuilder)serializable).toString();
                if (((String)object3).length() < 6) continue;
                string3 = ((String)object3).substring(0, 2);
                String string10 = ((String)object3).substring(6).trim();
                if (string3.equals("TY")) {
                    string4 = string10.equals("BOOK") ? "book" : (string10.equals("JOUR") || string10.equals("MGZN") ? "article" : (string10.equals("THES") ? "phdthesis" : (string10.equals("UNPB") ? "unpublished" : (string10.equals("RPRT") ? "techreport" : (string10.equals("CONF") ? "inproceedings" : (string10.equals("CHAP") ? "incollection" : "other"))))));
                } else if (string3.equals("T1") || string3.equals("TI")) {
                    object2 = hashMap.get("title");
                    if (object2 == null) {
                        hashMap.put("title", string10);
                    } else if (((String)object2).endsWith(":") || ((String)object2).endsWith(".") || ((String)object2).endsWith("?")) {
                        hashMap.put("title", (String)object2 + " " + string10);
                    } else {
                        hashMap.put("title", (String)object2 + ": " + string10);
                    }
                } else if (string3.equals("T2") || string3.equals("T3") || string3.equals("BT")) {
                    hashMap.put("booktitle", string10);
                } else if (string3.equals("AU") || string3.equals("A1")) {
                    string5 = string5.equals("") ? string10 : string5 + " and " + string10;
                } else if (string3.equals("A2")) {
                    string6 = string6.equals("") ? string10 : string6 + " and " + string10;
                } else if (string3.equals("JA") || string3.equals("JF") || string3.equals("JO")) {
                    if (string4.equals("inproceedings")) {
                        hashMap.put("booktitle", string10);
                    } else {
                        hashMap.put("journal", string10);
                    }
                } else if (string3.equals("SP")) {
                    string7 = string10;
                } else if (string3.equals("PB")) {
                    if (string4.equals("phdthesis")) {
                        hashMap.put("school", string10);
                    } else {
                        hashMap.put("publisher", string10);
                    }
                } else if (string3.equals("AD") || string3.equals("CY")) {
                    hashMap.put("address", string10);
                } else if (string3.equals("EP")) {
                    string8 = string10;
                } else if (string3.equals("SN")) {
                    hashMap.put("issn", string10);
                } else if (string3.equals("VL")) {
                    hashMap.put("volume", string10);
                } else if (string3.equals("IS")) {
                    hashMap.put("number", string10);
                } else if (string3.equals("N2") || string3.equals("AB")) {
                    object2 = hashMap.get("abstract");
                    if (object2 == null) {
                        hashMap.put("abstract", string10);
                    } else {
                        hashMap.put("abstract", (String)object2 + "\n" + string10);
                    }
                } else if (string3.equals("UR")) {
                    hashMap.put("url", string10);
                } else if ((string3.equals("Y1") || string3.equals("PY")) && string10.length() >= 4) {
                    object2 = string10.split("/");
                    hashMap.put("year", object2[0]);
                    if (((String[])object2).length > 1 && object2[1].length() > 0) {
                        try {
                            int n = Integer.parseInt(object2[1]);
                            MonthUtil.Month month = MonthUtil.getMonthByNumber(n);
                            if (month.isValid()) {
                                hashMap.put("month", month.bibtexFormat);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (string3.equals("KW")) {
                    if (!hashMap.containsKey("keywords")) {
                        hashMap.put("keywords", string10);
                    } else {
                        object2 = hashMap.get("keywords");
                        hashMap.put("keywords", (String)object2 + ", " + string10);
                    }
                } else if (string3.equals("U1") || string3.equals("U2") || string3.equals("N1")) {
                    if (string9.length() > 0) {
                        string9 = string9 + "\n";
                    }
                    string9 = string9 + string10;
                } else if (string3.equals("ID")) {
                    hashMap.put("refid", string10);
                } else if (string3.equals("M3") && ((String)(object2 = string10)).startsWith("doi:")) {
                    object2 = ((String)object2).replaceAll("(?i)doi:", "").trim();
                    hashMap.put("doi", (String)object2);
                }
                if (string5.length() > 0) {
                    string5 = AuthorList.fixAuthor_lastNameFirst(string5);
                    hashMap.put("author", string5);
                }
                if (string6.length() > 0) {
                    string6 = AuthorList.fixAuthor_lastNameFirst(string6);
                    hashMap.put("editor", string6);
                }
                if (string9.length() > 0) {
                    hashMap.put("comment", string9);
                }
                hashMap.put("pages", string7 + "--" + string8);
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string4));
            serializable = new ArrayList();
            for (Object object3 : hashMap.keySet()) {
                string3 = (String)hashMap.get(object3);
                if (string3 != null && string3.trim().length() != 0) continue;
                ((ArrayList)serializable).add(object3);
            }
            Iterator<Object> iterator = ((ArrayList)serializable).iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                hashMap.remove(object3);
            }
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

