/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class SPIRESBibtexFilterReader
extends FilterReader {
    private final BufferedReader in;
    private String line;
    private int pos;
    private boolean pre;

    SPIRESBibtexFilterReader(Reader reader) {
        super(reader);
        this.in = new BufferedReader(reader);
        this.pos = -1;
        this.pre = false;
    }

    private String readpreLine() throws IOException {
        String string;
        do {
            if ((string = this.in.readLine()) == null) {
                return null;
            }
            if (string.equals("<pre>")) {
                this.pre = true;
                string = this.in.readLine();
            }
            if (!string.equals("</pre>")) continue;
            this.pre = false;
        } while (!this.pre);
        return string;
    }

    private String fixBibkey(String string) {
        if (string == null) {
            return null;
        }
        if (string.matches("@Article\\{.*,")) {
            return string.replace(' ', '_');
        }
        return string;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < 0) {
            this.line = this.fixBibkey(this.readpreLine());
            this.pos = 0;
            if (this.line == null) {
                return -1;
            }
        }
        if (this.pos >= this.line.length()) {
            this.pos = -1;
            return 10;
        }
        return this.line.charAt(this.pos++);
    }
}

