/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class SilverPlatterImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "SilverPlatter";
    }

    @Override
    public String getCLIId() {
        return "silverplatter";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("Record.*INSPEC.*");
        while ((string = bufferedReader.readLine()) != null) {
            if (pattern.matcher(string).find()) {
                return false;
            }
            if (string.length() < 5 || !string.substring(0, 5).equals("TI:  ")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 2) {
                stringBuilder.append("__::__").append(string);
                continue;
            }
            stringBuilder.append("__NEWFIELD__").append(string);
        }
        bufferedReader.close();
        String[] stringArray = stringBuilder.toString().split("__::__");
        String string2 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            int n;
            if (string3.trim().length() < 6) continue;
            hashMap.clear();
            String[] stringArray2 = string3.split("__NEWFIELD__");
            Object object = stringArray2;
            int n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                String string4;
                String string5;
                String string6 = object[n];
                if (string6.length() < 6) continue;
                String string7 = string6.substring(0, 2);
                String string8 = string6.substring(5);
                if (string7.equals("TI")) {
                    hashMap.put("title", string8);
                    continue;
                }
                if (string7.equals("AU")) {
                    if (string8.trim().endsWith("(ed)")) {
                        String string9 = string8.trim();
                        string9 = string9.substring(0, string9.length() - 4);
                        hashMap.put("editor", AuthorList.fixAuthor_lastNameFirst(string9.replaceAll(",-", ", ").replaceAll(";", " and ")));
                        continue;
                    }
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(string8.replaceAll(",-", ", ").replaceAll(";", " and ")));
                    continue;
                }
                if (string7.equals("AB")) {
                    hashMap.put("abstract", string8);
                    continue;
                }
                if (string7.equals("DE")) {
                    String string10 = string8.replaceAll("-;", ",").toLowerCase();
                    hashMap.put("keywords", string10.substring(0, string10.length() - 1));
                    continue;
                }
                if (string7.equals("SO")) {
                    int n3 = string8.indexOf(".");
                    if (n3 < 0) continue;
                    string5 = string8.substring(0, n3);
                    hashMap.put("journal", string5.replaceAll("-", " "));
                    string8 = string8.substring(n3);
                    n3 = string8.indexOf(";");
                    if (n3 < 5) continue;
                    string4 = string8.substring(n3 - 5, n3).trim();
                    hashMap.put("year", string4);
                    string8 = string8.substring(n3);
                    n3 = string8.indexOf(":");
                    if (n3 < 0) continue;
                    String string11 = string8.substring(n3 + 1).trim();
                    hashMap.put("pages", string11);
                    hashMap.put("volume", string8.substring(1, n3));
                    continue;
                }
                if (string7.equals("PB")) {
                    int n4 = string8.indexOf(":");
                    if (n4 < 0) continue;
                    string5 = string8.substring(0, n4);
                    hashMap.put("publisher", string5.replaceAll("-", " ").trim());
                    string8 = string8.substring(n4);
                    n4 = string8.indexOf(", ");
                    if (n4 + 2 >= string8.length()) continue;
                    string4 = string8.substring(n4 + 2).trim();
                    try {
                        Integer.parseInt(string4);
                        hashMap.put("year", string4);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string7.equals("AF")) {
                    hashMap.put("school", string8.trim());
                    continue;
                }
                if (!string7.equals("DT")) continue;
                if ((string8 = string8.trim()).equals("Monograph")) {
                    string2 = "book";
                    continue;
                }
                if (string8.startsWith("Dissertation")) {
                    string2 = "phdthesis";
                    continue;
                }
                if (string8.toLowerCase().contains("journal")) {
                    string2 = "article";
                    continue;
                }
                if (string8.equals("Contribution") || string8.equals("Chapter")) {
                    string2 = "incollection";
                    bl = true;
                    continue;
                }
                string2 = string8.replaceAll(" ", "");
            }
            if (bl && (object = hashMap.get("title")) != null) {
                String string12 = ((String)object).trim();
                n = string12.indexOf("\" in ");
                int n5 = string12.lastIndexOf(" ");
                if (n > 1) {
                    hashMap.put("title", string12.substring(1, n));
                }
                if (n5 > n) {
                    hashMap.put("pages", string12.substring(n5).replaceAll("-", "--"));
                }
            }
            object = new BibtexEntry("__ID", Globals.getEntryType(string2));
            ((BibtexEntry)object).setField(hashMap);
            arrayList.add((BibtexEntry)object);
        }
        return arrayList;
    }
}

