/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import net.sf.jabref.BibtexEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TextAnalyzer {
    private final BibtexEntry be = null;
    private static final Log LOGGER = LogFactory.getLog(TextAnalyzer.class);

    public TextAnalyzer(String string) {
        this.guessBibtexFields(string);
    }

    public BibtexEntry getEntry() {
        return this.be;
    }

    private void guessBibtexFields(String string) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        TreeSet<Substring> treeSet = new TreeSet<Substring>();
        string = "  " + string + "  ";
        String string2 = null;
        String string3 = "(\\s|\\()\\d\\d\\d\\d(\\.|,|\\))";
        String[] stringArray = this.getMatches(string, string3);
        if (stringArray.length == 1) {
            string2 = this.clean(stringArray[0]);
            n4 = string.indexOf(string2);
            treeSet.add(new Substring("year", n4, n4 + string2.length()));
            LOGGER.info("Guessing 'year': '" + string2 + "'");
        } else if (stringArray.length > 1) {
            n4 = -1;
            int n5 = -1;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                n2 = Integer.parseInt(stringArray[n3].trim());
                if (n2 == n5 || n2 >= 2500) continue;
                if (n4 == -1) {
                    n4 = n3;
                    n5 = n2;
                    continue;
                }
                if (n5 < 2050 && n2 < 2050) {
                    n4 = -1;
                    break;
                }
                if (n5 < 2050 || n2 >= 2050) continue;
                n4 = n3;
                n5 = n2;
            }
            if (n4 >= 0) {
                string2 = this.clean(stringArray[n4]);
                n3 = string.indexOf(string2);
                treeSet.add(new Substring("year", n3, n3 + string2.length()));
                LOGGER.info("Guessing 'year': '" + string2 + "'");
            }
        }
        String string4 = "\\s(\\d{1,4})( ??)-( ??)(\\d{1,4})(\\.|,|\\s)";
        stringArray = this.getMatches(string, string4);
        if (stringArray.length == 1) {
            String string5 = this.clean(stringArray[0].replaceAll("-|( - )", "--"));
            n3 = string.indexOf(stringArray[0]);
            treeSet.add(new Substring("pages", n3, n3 + string2.length()));
            LOGGER.info("Guessing 'pages': '" + string5 + "'");
        } else if (stringArray.length > 1) {
            n3 = -1;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String[] stringArray2 = this.clean(stringArray[n2].replaceAll("\\s", "")).split("-");
                int n6 = Integer.parseInt(stringArray2[0]);
                n = Integer.parseInt(stringArray2[1]);
                if (n - n6 <= 3) continue;
                n3 = n2;
                break;
            }
            if (n3 >= 0) {
                String string6 = this.clean(stringArray[n3].replaceAll("-|( - )", "--"));
                n2 = string.indexOf(stringArray[n3]);
                LOGGER.info("Guessing 'pages': '" + string6 + "'");
                treeSet.add(new Substring("pages", n2, n2 + string6.length()));
            }
        }
        String string7 = "(,|\\.|\\n)\\s??([a-zA-Z\\. ]{8,30}+)((.){0,2})((vol\\.|Vol\\.|Volume|volume))??\\s??(\\d{1,3})(\\.|,|\\s|:)";
        stringArray = this.getMatches(string, string7);
        if (stringArray.length > 0) {
            stringArray[0] = stringArray[0].trim();
            n = stringArray[0].lastIndexOf(32);
            if (n > 0) {
                String string8 = this.clean(stringArray[0].substring(n + 1));
                LOGGER.info("Guessing 'volume': '" + string8 + "'");
                String string9 = this.clean(stringArray[0].substring(0, n));
                n = string9.lastIndexOf(32);
                if (n > 0 && (((String)(object = string9.substring(n + 1).toLowerCase())).equals("volume") || ((String)object).equals("vol") || ((String)object).equals("v"))) {
                    string9 = this.clean(string9.substring(0, n));
                }
                n = string.indexOf(string9);
                treeSet.add(new Substring("journal", n, n + string9.length()));
                LOGGER.info("Guessing 'journal': '" + string9 + "'");
            }
        }
        object = new Vector<String>();
        int n7 = 0;
        for (Substring object2 : treeSet) {
            Substring object3 = object2;
            if (object3.begin() - n7 > 10) {
                LOGGER.info("... " + string.substring(n7, object3.begin()));
                ((Vector)object).add(this.clean(string.substring(n7, object3.begin())));
            }
            n7 = object3.end();
        }
        if (string.length() - n7 > 10) {
            ((Vector)object).add(this.clean(string.substring(n7)));
        }
        LOGGER.info("Free parts:");
        Iterator iterator = ((Vector)object).iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            LOGGER.info(": '" + string5 + "'");
        }
    }

    private String[] getMatches(String string, String string2) {
        int n = 0;
        String[] stringArray = string.split(string2);
        if (stringArray.length < 2) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray3 = string.split(string2, i + 2);
            stringArray2[i] = string.substring(n + stringArray3[i].length(), string.length() - stringArray3[i + 1].length());
            n += stringArray3[i].length() + stringArray2[i].length();
        }
        return stringArray2;
    }

    private String clean(String string) {
        char c;
        boolean bl = false;
        int n = 0;
        int n2 = string.length() - 1;
        while (!bl && n < string.length()) {
            c = string.charAt(n);
            if (Character.isWhitespace(c) || c == '.' || c == ',' || c == '(' || c == ':' || c == ')') {
                ++n;
                continue;
            }
            bl = true;
        }
        bl = false;
        while (!bl && n2 > n) {
            c = string.charAt(n2);
            if (Character.isWhitespace(c) || c == '.' || c == ',' || c == ')' || c == ':' || c == '(') {
                --n2;
                continue;
            }
            bl = true;
        }
        return string.substring(n, Math.min(n2 + 1, string.length()));
    }

    private class Substring
    implements Comparable<Substring> {
        final int begin;
        final int end;

        public Substring(String string, int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        public int begin() {
            return this.begin;
        }

        public int end() {
            return this.end;
        }

        @Override
        public int compareTo(Substring substring) {
            return new Integer(this.begin).compareTo(substring.begin());
        }
    }
}

