/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.journals.UndoableAbbreviator;
import net.sf.jabref.undo.NamedCompound;

public class AbbreviateAction
extends AbstractWorker {
    private final BasePanel panel;
    private String message = "";
    private final boolean iso;

    public AbbreviateAction(BasePanel basePanel, boolean bl) {
        this.panel = basePanel;
        this.iso = bl;
    }

    @Override
    public void init() {
        this.panel.output("Abbreviating...");
    }

    @Override
    public void run() {
        BibtexEntry[] bibtexEntryArray = this.panel.getSelectedEntries();
        if (bibtexEntryArray == null) {
            return;
        }
        UndoableAbbreviator undoableAbbreviator = new UndoableAbbreviator(Globals.journalAbbrev, this.iso);
        NamedCompound namedCompound = new NamedCompound("Abbreviate journal names");
        int n = 0;
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            if (undoableAbbreviator.abbreviate(this.panel.database(), bibtexEntry, "journal", namedCompound)) {
                ++n;
            }
            if (!undoableAbbreviator.abbreviate(this.panel.database(), bibtexEntry, "journaltitle", namedCompound)) continue;
            ++n;
        }
        if (n > 0) {
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
            this.panel.markBaseChanged();
            this.message = Globals.lang("Abbreviated %0 journal names.", String.valueOf(n));
        } else {
            this.message = Globals.lang("No journal names could be abbreviated.");
        }
    }

    @Override
    public void update() {
        this.panel.output(this.message);
    }
}

