/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.journals.logic.Abbreviation;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;
import net.sf.jabref.undo.UndoableFieldChange;

public class JournalAbbreviationsUtil {
    private static final String TOOLTIP_TEXT = "<HTML>" + Globals.lang("Switches between full and abbreviated journal name if the journal name is known.") + "<BR>" + Globals.lang("To set up, go to <B>Tools -> Manage journal abbreviations</B>") + ".</HTML>";

    public static JComponent getNameSwitcher(final EntryEditor entryEditor, final FieldEditor fieldEditor, final UndoManager undoManager) {
        JButton jButton = new JButton(Globals.lang("Toggle abbreviation"));
        jButton.setToolTipText(TOOLTIP_TEXT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = fieldEditor.getText();
                if (Globals.journalAbbrev.isKnownName(string2) && (string = this.toggleAbbreviation(string2)) != null) {
                    fieldEditor.setText(string);
                    entryEditor.storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
                    undoManager.addEdit(new UndoableFieldChange(entryEditor.getEntry(), fieldEditor.getFieldName(), string2, string));
                }
            }

            public String toggleAbbreviation(String string) {
                return Globals.journalAbbrev.getNextAbbreviation(string).or(string);
            }
        });
        return jButton;
    }

    public static TableModel getTableModel(JournalAbbreviationRepository journalAbbreviationRepository) {
        Object[][] objectArray = new Object[journalAbbreviationRepository.size()][2];
        int n = 0;
        for (Abbreviation abbreviation : journalAbbreviationRepository.getAbbreviations()) {
            objectArray[n][0] = abbreviation.getName();
            objectArray[n][1] = abbreviation.getIsoAbbreviation();
            ++n;
        }
        return new DefaultTableModel(objectArray, new Object[]{Globals.lang("Full name"), Globals.lang("Abbreviation")}){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }
}

