/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.journals.logic.Abbreviation;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;
import net.sf.jabref.undo.UndoableFieldChange;

public class UndoableAbbreviator {
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private final boolean isoAbbreviationStyle;

    public UndoableAbbreviator(JournalAbbreviationRepository journalAbbreviationRepository, boolean bl) {
        this.journalAbbreviationRepository = journalAbbreviationRepository;
        this.isoAbbreviationStyle = bl;
    }

    public boolean abbreviate(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry, String string, CompoundEdit compoundEdit) {
        String string2 = bibtexEntry.getField(string);
        if (string2 == null) {
            return false;
        }
        String string3 = string2;
        if (bibtexDatabase != null) {
            string2 = bibtexDatabase.resolveForStrings(string2);
        }
        if (!this.journalAbbreviationRepository.isKnownName(string2)) {
            return false;
        }
        String string4 = this.getAbbreviatedName(this.journalAbbreviationRepository.getAbbreviation(string2).get());
        if (string4.equals(string3)) {
            return false;
        }
        bibtexEntry.setField(string, string4);
        compoundEdit.addEdit(new UndoableFieldChange(bibtexEntry, string, string3, string4));
        return true;
    }

    private String getAbbreviatedName(Abbreviation abbreviation) {
        if (this.isoAbbreviationStyle) {
            return abbreviation.getIsoAbbreviation();
        }
        return abbreviation.getMedlineAbbreviation();
    }
}

