/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals.logic;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Abbreviation
implements Comparable<Abbreviation> {
    private final String name;
    private final String abbreviation;

    public Abbreviation(String string, String string2) {
        this.name = Preconditions.checkNotNull(string).trim();
        this.abbreviation = Preconditions.checkNotNull(string2).trim();
    }

    public String getName() {
        return this.name;
    }

    public String getIsoAbbreviation() {
        String string = ";";
        if (this.abbreviation.contains(string)) {
            String[] stringArray = this.abbreviation.split(string);
            return stringArray[0].trim();
        }
        return this.abbreviation;
    }

    public String getMedlineAbbreviation() {
        return this.getIsoAbbreviation().replaceAll("\\.", " ").replaceAll("  ", " ").trim();
    }

    public boolean hasIsoAndMedlineAbbreviationsAreSame() {
        return this.getIsoAbbreviation().equals(this.getMedlineAbbreviation());
    }

    @Override
    public int compareTo(Abbreviation abbreviation) {
        return this.name.compareTo(abbreviation.name);
    }

    public String getNext(String string) {
        String string2 = string.trim();
        if (this.getMedlineAbbreviation().equals(string2)) {
            return this.getName();
        }
        if (this.getName().equals(string2)) {
            return this.getIsoAbbreviation();
        }
        return this.getMedlineAbbreviation();
    }

    public String toString() {
        return String.format("Abbreviation{name=%s, iso=%s, medline=%s}", this.name, this.getIsoAbbreviation(), this.getMedlineAbbreviation());
    }

    public String toPropertiesLine() {
        return String.format("%s = %s", this.name, this.getAbbreviation());
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Abbreviation abbreviation = (Abbreviation)object;
        return Objects.equal(this.name, abbreviation.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

