/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals.logic;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.sf.jabref.journals.logic.Abbreviation;
import net.sf.jabref.journals.logic.JournalAbbreviationRepository;

public class AbbreviationParser {
    private final List<Abbreviation> abbreviations = new LinkedList<Abbreviation>();

    public void readJournalListFromResource(String string) {
        URL uRL = Preconditions.checkNotNull(JournalAbbreviationRepository.class.getResource(Preconditions.checkNotNull(string)));
        try {
            this.readJournalList(new InputStreamReader(uRL.openStream()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readJournalListFromFile(File file) throws FileNotFoundException {
        this.readJournalList(new FileReader(Preconditions.checkNotNull(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readJournalList(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.addLine(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void addLine(String string) {
        if (string.startsWith("#")) {
            return;
        }
        String[] stringArray = string.split("=");
        if (stringArray.length == 2) {
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            if (string2.length() <= 0 || string3.length() <= 0) {
                return;
            }
            Abbreviation abbreviation = new Abbreviation(string2, string3);
            this.abbreviations.add(abbreviation);
        }
    }

    public List<Abbreviation> getAbbreviations() {
        return new LinkedList<Abbreviation>(this.abbreviations);
    }
}

