/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.export.layout.format.XMLChars;
import net.sf.jabref.mods.PageNumbers;
import net.sf.jabref.mods.PersonName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MODSEntry {
    private String entryType = "mods";
    private String id;
    private List<PersonName> authors = null;
    private String issuance = "monographic";
    private PageNumbers pages = null;
    private String publisher = null;
    private String date = null;
    private String title = null;
    private String number;
    private String volume;
    private String genre = null;
    private final Set<String> handledExtensions;
    private MODSEntry host;
    private final Map<String, String> extensionFields = new HashMap<String, String>();
    private static final String BIBTEX = "bibtex_";
    private final boolean CHARFORMAT = false;

    private MODSEntry() {
        this.handledExtensions = new HashSet<String>();
    }

    public MODSEntry(BibtexEntry bibtexEntry) {
        this();
        this.handledExtensions.add("bibtex_publisher");
        this.handledExtensions.add("bibtex_title");
        this.handledExtensions.add("bibtex_bibtexkey");
        this.handledExtensions.add("bibtex_author");
        this.populateFromBibtex(bibtexEntry);
    }

    private void populateFromBibtex(BibtexEntry bibtexEntry) {
        XMLChars xMLChars = new XMLChars();
        if (bibtexEntry.getField("title") != null) {
            this.title = bibtexEntry.getField("title");
        }
        if (bibtexEntry.getField("publisher") != null) {
            this.publisher = bibtexEntry.getField("publisher");
        }
        if (bibtexEntry.getField("bibtexkey") != null) {
            this.id = bibtexEntry.getField("bibtexkey");
        }
        if (bibtexEntry.getField("place") != null) {
            String string = null;
            string = bibtexEntry.getField("place");
        }
        this.date = this.getDate(bibtexEntry);
        this.genre = this.getMODSgenre(bibtexEntry);
        if (bibtexEntry.getField("author") != null) {
            this.authors = this.getAuthors(bibtexEntry.getField("author"));
        }
        if (bibtexEntry.getType() == BibtexEntryTypes.ARTICLE || bibtexEntry.getType() == BibtexEntryTypes.INPROCEEDINGS) {
            this.host = new MODSEntry();
            this.host.entryType = "relatedItem";
            this.host.title = bibtexEntry.getField("booktitle");
            this.host.publisher = bibtexEntry.getField("publisher");
            this.host.number = bibtexEntry.getField("number");
            if (bibtexEntry.getField("pages") != null) {
                this.host.volume = bibtexEntry.getField("volume");
            }
            this.host.issuance = "continuing";
            if (bibtexEntry.getField("pages") != null) {
                this.host.pages = new PageNumbers(bibtexEntry.getField("pages"));
            }
        }
        this.populateExtensionFields(bibtexEntry);
    }

    private void populateExtensionFields(BibtexEntry bibtexEntry) {
        for (String string : bibtexEntry.getAllFields()) {
            String string2 = bibtexEntry.getField(string);
            string = BIBTEX + string;
            this.extensionFields.put(string, string2);
        }
    }

    private List<PersonName> getAuthors(String string) {
        LinkedList<PersonName> linkedList = new LinkedList<PersonName>();
        XMLChars xMLChars = new XMLChars();
        if (!string.contains(" and ")) {
            linkedList.add(new PersonName(string));
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split(" and ")) {
                linkedList.add(new PersonName(string2));
            }
        }
        return linkedList;
    }

    private String getDate(BibtexEntry bibtexEntry) {
        String string = "";
        if (bibtexEntry.getField("year") != null) {
            string = string + bibtexEntry.getField("year");
        }
        if (bibtexEntry.getField("month") != null) {
            string = string + '-' + bibtexEntry.getField("month");
        }
        return string;
    }

    private String getMODSgenre(BibtexEntry bibtexEntry) {
        return bibtexEntry.getType().getName();
    }

    private Node getDOMrepresentation() {
        Element element = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            element = this.getDOMrepresentation(documentBuilder.newDocument());
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return element;
    }

    public Element getDOMrepresentation(Document document) {
        try {
            Object object;
            Object object2;
            Element element;
            Object object4;
            Element element2 = document.createElement(this.entryType);
            element2.setAttribute("version", "3.0");
            if (this.title != null) {
                object4 = document.createElement("titleInfo");
                Element object32 = document.createElement("title");
                object32.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(this.title)));
                object4.appendChild(object32);
                element2.appendChild((Node)object4);
            }
            if (this.authors != null) {
                for (PersonName personName : this.authors) {
                    element = document.createElement("name");
                    element.setAttribute("type", "personal");
                    if (personName.getSurname() != null) {
                        object2 = document.createElement("namePart");
                        object2.setAttribute("type", "family");
                        object2.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(personName.getSurname())));
                        element.appendChild((Node)object2);
                    }
                    if (personName.getGivenNames() != null) {
                        object2 = document.createElement("namePart");
                        object2.setAttribute("type", "given");
                        object2.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(personName.getGivenNames())));
                        element.appendChild((Node)object2);
                    }
                    object2 = document.createElement("role");
                    object = document.createElement("roleTerm");
                    object.setAttribute("type", "text");
                    object.appendChild(document.createTextNode("author"));
                    object2.appendChild((Node)object);
                    element.appendChild((Node)object2);
                    element2.appendChild(element);
                }
            }
            object4 = document.createElement("originInfo");
            element2.appendChild((Node)object4);
            if (this.publisher != null) {
                Element element3 = document.createElement("publisher");
                element3.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(this.publisher)));
                object4.appendChild(element3);
            }
            if (this.date != null) {
                Element element4 = document.createElement("dateIssued");
                element4.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(this.date)));
                object4.appendChild(element4);
            }
            Element element5 = document.createElement("issuance");
            element5.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(this.issuance)));
            object4.appendChild(element5);
            if (this.id != null) {
                element = document.createElement("identifier");
                element.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(this.id)));
                element2.appendChild(element);
                element2.setAttribute("ID", this.id);
            }
            element = document.createElement("typeOfResource");
            object2 = "text";
            element.appendChild(document.createTextNode(this.stripNonValidXMLCharacters((String)object2)));
            element2.appendChild(element);
            if (this.genre != null) {
                object = document.createElement("genre");
                object.setAttribute("authority", "marc");
                object.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(this.genre)));
                element2.appendChild((Node)object);
            }
            if (this.host != null) {
                object = this.host.getDOMrepresentation(document);
                object.setAttribute("type", "host");
                element2.appendChild((Node)object);
            }
            if (this.pages != null) {
                element2.appendChild(this.pages.getDOMrepresentation(document));
            }
            for (Map.Entry entry : this.extensionFields.entrySet()) {
                Element element6 = document.createElement("extension");
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (this.handledExtensions.contains(string)) continue;
                Element element7 = document.createElement(string);
                element7.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(string2)));
                element6.appendChild(element7);
                element2.appendChild(element6);
            }
            return element2;
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
            throw new Error(exception);
        }
    }

    private String stripNonValidXMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || string != null && string.isEmpty()) {
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMSource dOMSource = new DOMSource(this.getDOMrepresentation());
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return stringWriter.toString();
    }
}

