/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.msbib;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.export.layout.format.XMLChars;
import net.sf.jabref.mods.PageNumbers;
import net.sf.jabref.mods.PersonName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MSBibEntry {
    private String sourceType = "Misc";
    private String bibTexEntry = null;
    private String tag = null;
    private final String GUID;
    private int LCID = -1;
    private List<PersonName> authors = null;
    private List<PersonName> bookAuthors = null;
    private List<PersonName> editors = null;
    private List<PersonName> translators = null;
    private List<PersonName> producerNames = null;
    private List<PersonName> composers = null;
    private List<PersonName> conductors = null;
    private List<PersonName> performers = null;
    private List<PersonName> writers = null;
    private List<PersonName> directors = null;
    private List<PersonName> compilers = null;
    private List<PersonName> interviewers = null;
    private List<PersonName> interviewees = null;
    private List<PersonName> inventors = null;
    private List<PersonName> counsels = null;
    private String title = null;
    private String year = null;
    private String month = null;
    private String day = null;
    private String shortTitle = null;
    private String comments = null;
    private PageNumbers pages = null;
    private String volume = null;
    private String numberOfVolumes = null;
    private String edition = null;
    private String standardNumber = null;
    private String publisher = null;
    private String address = null;
    private String bookTitle = null;
    private String chapterNumber = null;
    private String journalName = null;
    private String issue = null;
    private String periodicalTitle = null;
    private String conferenceName = null;
    private String department = null;
    private String institution = null;
    private String thesisType = null;
    private String internetSiteTitle = null;
    private String dateAccessed = null;
    private String url = null;
    private String productionCompany = null;
    private String publicationTitle = null;
    private String medium = null;
    private String albumTitle = null;
    private String recordingNumber = null;
    private String theater = null;
    private String distributor = null;
    private String broadcastTitle = null;
    private String broadcaster = null;
    private String station = null;
    private String type = null;
    private String patentNumber = null;
    private String court = null;
    private String reporter = null;
    private String caseNumber = null;
    private String abbreviatedCaseNumber = null;
    private String bibTex_Series = null;
    private String bibTex_Abstract = null;
    private String bibTex_KeyWords = null;
    private String bibTex_CrossRef = null;
    private String bibTex_HowPublished = null;
    private String bibTex_Affiliation = null;
    private String bibTex_Contents = null;
    private String bibTex_Copyright = null;
    private String bibTex_Price = null;
    private String bibTex_Size = null;
    private String bibTex_InType = null;
    private String bibTex_Paper = null;
    private final String BIBTEX = "BIBTEX_";
    private final String MSBIB = "msbib-";
    private final String bcol = "b:";

    private MSBibEntry() {
        this.GUID = null;
    }

    public MSBibEntry(BibtexEntry bibtexEntry) {
        this();
        this.populateFromBibtex(bibtexEntry);
    }

    public MSBibEntry(Element element, String string) {
        this();
        this.populateFromXml(element, string);
    }

    private String getFromXml(String string, Element element) {
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            string2 = nodeList.item(0).getTextContent();
        }
        return string2;
    }

    private void populateFromXml(Element element, String string) {
        String string2 = null;
        this.sourceType = this.getFromXml(string + "SourceType", element);
        this.tag = this.getFromXml(string + "Tag", element);
        string2 = this.getFromXml(string + "LCID", element);
        if (string2 != null) {
            try {
                this.LCID = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                this.LCID = -1;
            }
        }
        this.title = this.getFromXml(string + "Title", element);
        this.year = this.getFromXml(string + "Year", element);
        this.month = this.getFromXml(string + "Month", element);
        this.day = this.getFromXml(string + "Day", element);
        this.shortTitle = this.getFromXml(string + "ShortTitle", element);
        this.comments = this.getFromXml(string + "Comments", element);
        string2 = this.getFromXml(string + "Pages", element);
        if (string2 != null) {
            this.pages = new PageNumbers(string2);
        }
        this.volume = this.getFromXml(string + "Volume", element);
        this.numberOfVolumes = this.getFromXml(string + "NumberVolumes", element);
        this.edition = this.getFromXml(string + "Edition", element);
        this.standardNumber = this.getFromXml(string + "StandardNumber", element);
        this.publisher = this.getFromXml(string + "Publisher", element);
        String string3 = this.getFromXml(string + "City", element);
        String string4 = this.getFromXml(string + "StateProvince", element);
        String string5 = this.getFromXml(string + "CountryRegion", element);
        this.address = "";
        if (string3 != null) {
            this.address = this.address + string3 + ", ";
        }
        if (string4 != null) {
            this.address = this.address + string4 + ' ';
        }
        if (string5 != null) {
            this.address = this.address + string5;
        }
        this.address = this.address.trim();
        if (this.address.isEmpty() || this.address.equals(",")) {
            this.address = null;
        }
        this.bookTitle = this.getFromXml(string + "BookTitle", element);
        this.chapterNumber = this.getFromXml(string + "ChapterNumber", element);
        this.journalName = this.getFromXml(string + "JournalName", element);
        this.issue = this.getFromXml(string + "Issue", element);
        this.periodicalTitle = this.getFromXml(string + "PeriodicalTitle", element);
        this.conferenceName = this.getFromXml(string + "ConferenceName", element);
        this.department = this.getFromXml(string + "Department", element);
        this.institution = this.getFromXml(string + "Institution", element);
        this.thesisType = this.getFromXml(string + "ThesisType", element);
        this.internetSiteTitle = this.getFromXml(string + "InternetSiteTitle", element);
        String string6 = this.getFromXml(string + "MonthAccessed", element);
        String string7 = this.getFromXml(string + "DayAccessed", element);
        String string8 = this.getFromXml(string + "YearAccessed", element);
        this.dateAccessed = "";
        if (string6 != null) {
            this.dateAccessed = this.dateAccessed + string6 + ' ';
        }
        if (string7 != null) {
            this.dateAccessed = this.dateAccessed + string7 + ", ";
        }
        if (string8 != null) {
            this.dateAccessed = this.dateAccessed + string8;
        }
        this.dateAccessed = this.dateAccessed.trim();
        if (this.dateAccessed.isEmpty() || this.dateAccessed.equals(",")) {
            this.dateAccessed = null;
        }
        this.url = this.getFromXml(string + "URL", element);
        this.productionCompany = this.getFromXml(string + "ProductionCompany", element);
        this.publicationTitle = this.getFromXml(string + "PublicationTitle", element);
        this.medium = this.getFromXml(string + "Medium", element);
        this.albumTitle = this.getFromXml(string + "AlbumTitle", element);
        this.recordingNumber = this.getFromXml(string + "RecordingNumber", element);
        this.theater = this.getFromXml(string + "Theater", element);
        this.distributor = this.getFromXml(string + "Distributor", element);
        this.broadcastTitle = this.getFromXml(string + "BroadcastTitle", element);
        this.broadcaster = this.getFromXml(string + "Broadcaster", element);
        this.station = this.getFromXml(string + "Station", element);
        this.type = this.getFromXml(string + "Type", element);
        this.patentNumber = this.getFromXml(string + "PatentNumber", element);
        this.court = this.getFromXml(string + "Court", element);
        this.reporter = this.getFromXml(string + "Reporter", element);
        this.caseNumber = this.getFromXml(string + "CaseNumber", element);
        this.abbreviatedCaseNumber = this.getFromXml(string + "AbbreviatedCaseNumber", element);
        this.bibTex_Series = this.getFromXml(string + "BIBTEX_" + "Series", element);
        this.bibTex_Abstract = this.getFromXml(string + "BIBTEX_" + "Abstract", element);
        this.bibTex_KeyWords = this.getFromXml(string + "BIBTEX_" + "KeyWords", element);
        this.bibTex_CrossRef = this.getFromXml(string + "BIBTEX_" + "CrossRef", element);
        this.bibTex_HowPublished = this.getFromXml(string + "BIBTEX_" + "HowPublished", element);
        this.bibTex_Affiliation = this.getFromXml(string + "BIBTEX_" + "Affiliation", element);
        this.bibTex_Contents = this.getFromXml(string + "BIBTEX_" + "Contents", element);
        this.bibTex_Copyright = this.getFromXml(string + "BIBTEX_" + "Copyright", element);
        this.bibTex_Price = this.getFromXml(string + "BIBTEX_" + "Price", element);
        this.bibTex_Size = this.getFromXml(string + "BIBTEX_" + "Size", element);
        NodeList nodeList = element.getElementsByTagName(string + "Author");
        if (nodeList.getLength() > 0) {
            this.getAuthors((Element)nodeList.item(0), string);
        }
    }

    private void populateFromBibtex(BibtexEntry bibtexEntry) {
        boolean bl;
        this.sourceType = this.getMSBibSourceType(bibtexEntry);
        if (bibtexEntry.getField("bibtexkey") != null) {
            this.tag = bibtexEntry.getField("bibtexkey");
        }
        if (bibtexEntry.getField("language") != null) {
            this.LCID = this.getLCID(bibtexEntry.getField("language"));
        }
        if (bibtexEntry.getField("title") != null) {
            this.title = bibtexEntry.getField("title");
        }
        if (bibtexEntry.getField("year") != null) {
            this.year = bibtexEntry.getField("year");
        }
        if (bibtexEntry.getField("month") != null) {
            this.month = bibtexEntry.getField("month");
        }
        if (bibtexEntry.getField("msbib-day") != null) {
            this.day = bibtexEntry.getField("msbib-day");
        }
        if (bibtexEntry.getField("msbib-shorttitle") != null) {
            this.shortTitle = bibtexEntry.getField("msbib-shorttitle");
        }
        if (bibtexEntry.getField("note") != null) {
            this.comments = bibtexEntry.getField("note");
        }
        if (bibtexEntry.getField("pages") != null) {
            this.pages = new PageNumbers(bibtexEntry.getField("pages"));
        }
        if (bibtexEntry.getField("volume") != null) {
            this.volume = bibtexEntry.getField("volume");
        }
        if (bibtexEntry.getField("msbib-numberofvolume") != null) {
            this.numberOfVolumes = bibtexEntry.getField("msbib-numberofvolume");
        }
        if (bibtexEntry.getField("edition") != null) {
            this.edition = bibtexEntry.getField("edition");
        }
        this.standardNumber = "";
        if (bibtexEntry.getField("isbn") != null) {
            this.standardNumber = this.standardNumber + " ISBN: " + bibtexEntry.getField("isbn");
        }
        if (bibtexEntry.getField("issn") != null) {
            this.standardNumber = this.standardNumber + " ISSN: " + bibtexEntry.getField("issn");
        }
        if (bibtexEntry.getField("lccn") != null) {
            this.standardNumber = this.standardNumber + " LCCN: " + bibtexEntry.getField("lccn");
        }
        if (bibtexEntry.getField("mrnumber") != null) {
            this.standardNumber = this.standardNumber + " MRN: " + bibtexEntry.getField("mrnumber");
        }
        if (bibtexEntry.getField("doi") != null) {
            this.standardNumber = this.standardNumber + " DOI: " + bibtexEntry.getField("doi");
        }
        if (this.standardNumber.isEmpty()) {
            this.standardNumber = null;
        }
        if (bibtexEntry.getField("publisher") != null) {
            this.publisher = bibtexEntry.getField("publisher");
        }
        if (bibtexEntry.getField("address") != null) {
            this.address = bibtexEntry.getField("address");
        }
        if (bibtexEntry.getField("booktitle") != null) {
            this.bookTitle = bibtexEntry.getField("booktitle");
        }
        if (bibtexEntry.getField("chapter") != null) {
            this.chapterNumber = bibtexEntry.getField("chapter");
        }
        if (bibtexEntry.getField("journal") != null) {
            this.journalName = bibtexEntry.getField("journal");
        }
        if (bibtexEntry.getField("number") != null) {
            this.issue = bibtexEntry.getField("number");
        }
        if (bibtexEntry.getField("msbib-periodical") != null) {
            this.periodicalTitle = bibtexEntry.getField("msbib-periodical");
        }
        if (bibtexEntry.getField("booktitle") != null) {
            this.conferenceName = bibtexEntry.getField("booktitle");
        }
        if (bibtexEntry.getField("school") != null) {
            this.department = bibtexEntry.getField("school");
        }
        if (bibtexEntry.getField("institution") != null) {
            this.institution = bibtexEntry.getField("institution");
        }
        if (bibtexEntry.getField("type") != null) {
            this.thesisType = bibtexEntry.getField("type");
        } else if (bibtexEntry.getType().getName().equalsIgnoreCase("techreport")) {
            this.thesisType = "Tech. rep.";
        } else if (bibtexEntry.getType().getName().equalsIgnoreCase("mastersthesis")) {
            this.thesisType = "Master's thesis";
        } else if (bibtexEntry.getType().getName().equalsIgnoreCase("phdthesis")) {
            this.thesisType = "Ph.D. dissertation";
        } else if (bibtexEntry.getType().getName().equalsIgnoreCase("unpublished")) {
            this.thesisType = "unpublished";
        }
        if ((this.sourceType.equals("InternetSite") || this.sourceType.equals("DocumentFromInternetSite")) && bibtexEntry.getField("title") != null) {
            this.internetSiteTitle = bibtexEntry.getField("title");
        }
        if (bibtexEntry.getField("msbib-accessed") != null) {
            this.dateAccessed = bibtexEntry.getField("msbib-accessed");
        }
        if (bibtexEntry.getField("url") != null) {
            this.url = bibtexEntry.getField("url");
        }
        if (bibtexEntry.getField("msbib-productioncompany") != null) {
            this.productionCompany = bibtexEntry.getField("msbib-productioncompany");
        }
        if ((this.sourceType.equals("ElectronicSource") || this.sourceType.equals("Art") || this.sourceType.equals("Misc")) && bibtexEntry.getField("title") != null) {
            this.publicationTitle = bibtexEntry.getField("title");
        }
        if (bibtexEntry.getField("msbib-medium") != null) {
            this.medium = bibtexEntry.getField("msbib-medium");
        }
        if (this.sourceType.equals("SoundRecording") && bibtexEntry.getField("title") != null) {
            this.albumTitle = bibtexEntry.getField("title");
        }
        if (bibtexEntry.getField("msbib-recordingnumber") != null) {
            this.recordingNumber = bibtexEntry.getField("msbib-recordingnumber");
        }
        if (bibtexEntry.getField("msbib-theater") != null) {
            this.theater = bibtexEntry.getField("msbib-theater");
        }
        if (bibtexEntry.getField("msbib-distributor") != null) {
            this.distributor = bibtexEntry.getField("msbib-distributor");
        }
        if (this.sourceType.equals("Interview") && bibtexEntry.getField("title") != null) {
            this.broadcastTitle = bibtexEntry.getField("title");
        }
        if (bibtexEntry.getField("msbib-broadcaster") != null) {
            this.broadcaster = bibtexEntry.getField("msbib-broadcaster");
        }
        if (bibtexEntry.getField("msbib-station") != null) {
            this.station = bibtexEntry.getField("msbib-station");
        }
        if (bibtexEntry.getField("msbib-type") != null) {
            this.type = bibtexEntry.getField("msbib-type");
        }
        if (bibtexEntry.getField("msbib-patentnumber") != null) {
            this.patentNumber = bibtexEntry.getField("msbib-patentnumber");
        }
        if (bibtexEntry.getField("msbib-court") != null) {
            this.court = bibtexEntry.getField("msbib-court");
        }
        if (bibtexEntry.getField("msbib-reporter") != null) {
            this.reporter = bibtexEntry.getField("msbib-reporter");
        }
        if (bibtexEntry.getField("msbib-casenumber") != null) {
            this.caseNumber = bibtexEntry.getField("msbib-casenumber");
        }
        if (bibtexEntry.getField("msbib-abbreviatedcasenumber") != null) {
            this.abbreviatedCaseNumber = bibtexEntry.getField("msbib-abbreviatedcasenumber");
        }
        if (bibtexEntry.getField("series") != null) {
            this.bibTex_Series = bibtexEntry.getField("series");
        }
        if (bibtexEntry.getField("abstract") != null) {
            this.bibTex_Abstract = bibtexEntry.getField("abstract");
        }
        if (bibtexEntry.getField("keywords") != null) {
            this.bibTex_KeyWords = bibtexEntry.getField("keywords");
        }
        if (bibtexEntry.getField("crossref") != null) {
            this.bibTex_CrossRef = bibtexEntry.getField("crossref");
        }
        if (bibtexEntry.getField("howpublished") != null) {
            this.bibTex_HowPublished = bibtexEntry.getField("howpublished");
        }
        if (bibtexEntry.getField("affiliation") != null) {
            this.bibTex_Affiliation = bibtexEntry.getField("affiliation");
        }
        if (bibtexEntry.getField("contents") != null) {
            this.bibTex_Contents = bibtexEntry.getField("contents");
        }
        if (bibtexEntry.getField("copyright") != null) {
            this.bibTex_Copyright = bibtexEntry.getField("copyright");
        }
        if (bibtexEntry.getField("price") != null) {
            this.bibTex_Price = bibtexEntry.getField("price");
        }
        if (bibtexEntry.getField("size") != null) {
            this.bibTex_Size = bibtexEntry.getField("size");
        }
        if (bibtexEntry.getField("intype") != null) {
            this.bibTex_InType = bibtexEntry.getField("intype");
        }
        if (bibtexEntry.getField("paper") != null) {
            this.bibTex_Paper = bibtexEntry.getField("paper");
        }
        if (bibtexEntry.getField("author") != null) {
            this.authors = this.getAuthors(bibtexEntry.getField("author"));
        }
        if (bibtexEntry.getField("editor") != null) {
            this.editors = this.getAuthors(bibtexEntry.getField("editor"));
        }
        if (bl = false) {
            this.title = this.format(this.title);
            this.bibTex_Abstract = this.format(this.bibTex_Abstract);
        }
    }

    private String format(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        XMLChars xMLChars = new XMLChars();
        string2 = xMLChars.format(string);
        return string2;
    }

    private int getLCID(String string) {
        return 0;
    }

    private String getLanguage(int n) {
        return "english";
    }

    private List<PersonName> getSpecificAuthors(String string, Element element, String string2) {
        LinkedList<PersonName> linkedList = null;
        NodeList nodeList = element.getElementsByTagName(string2 + string);
        if (nodeList.getLength() <= 0) {
            return linkedList;
        }
        if ((nodeList = ((Element)nodeList.item(0)).getElementsByTagName(string2 + "NameList")).getLength() <= 0) {
            return linkedList;
        }
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName(string2 + "Person");
        if (nodeList2.getLength() <= 0) {
            return linkedList;
        }
        linkedList = new LinkedList<PersonName>();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            NodeList nodeList3 = ((Element)nodeList2.item(i)).getElementsByTagName(string2 + "First");
            NodeList nodeList4 = ((Element)nodeList2.item(i)).getElementsByTagName(string2 + "Last");
            NodeList nodeList5 = ((Element)nodeList2.item(i)).getElementsByTagName(string2 + "Middle");
            PersonName personName = new PersonName();
            if (nodeList3.getLength() > 0) {
                personName.setFirstname(nodeList3.item(0).getTextContent());
            }
            if (nodeList5.getLength() > 0) {
                personName.setMiddlename(nodeList5.item(0).getTextContent());
            }
            if (nodeList4.getLength() > 0) {
                personName.setSurname(nodeList4.item(0).getTextContent());
            }
            linkedList.add(personName);
        }
        return linkedList;
    }

    private void getAuthors(Element element, String string) {
        this.authors = this.getSpecificAuthors("Author", element, string);
        this.bookAuthors = this.getSpecificAuthors("BookAuthor", element, string);
        this.editors = this.getSpecificAuthors("Editor", element, string);
        this.translators = this.getSpecificAuthors("Translator", element, string);
        this.producerNames = this.getSpecificAuthors("ProducerName", element, string);
        this.composers = this.getSpecificAuthors("Composer", element, string);
        this.conductors = this.getSpecificAuthors("Conductor", element, string);
        this.performers = this.getSpecificAuthors("Performer", element, string);
        this.writers = this.getSpecificAuthors("Writer", element, string);
        this.directors = this.getSpecificAuthors("Director", element, string);
        this.compilers = this.getSpecificAuthors("Compiler", element, string);
        this.interviewers = this.getSpecificAuthors("Interviewer", element, string);
        this.interviewees = this.getSpecificAuthors("Interviewee", element, string);
        this.inventors = this.getSpecificAuthors("Inventor", element, string);
        this.counsels = this.getSpecificAuthors("Counsel", element, string);
    }

    private List<PersonName> getAuthors(String string) {
        LinkedList<PersonName> linkedList = new LinkedList<PersonName>();
        if (!string.contains(" and ")) {
            linkedList.add(new PersonName(string));
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split(" and ")) {
                linkedList.add(new PersonName(string2));
            }
        }
        return linkedList;
    }

    protected String getDate(BibtexEntry bibtexEntry) {
        String string = "";
        if (bibtexEntry.getField("year") != null) {
            string = string + bibtexEntry.getField("year");
        }
        if (bibtexEntry.getField("month") != null) {
            string = string + '-' + bibtexEntry.getField("month");
        }
        return string;
    }

    private String getMSBibSourceType(BibtexEntry bibtexEntry) {
        String string = bibtexEntry.getType().getName();
        String string2 = "Misc";
        if (string.equalsIgnoreCase("book")) {
            string2 = "Book";
        } else if (string.equalsIgnoreCase("inbook")) {
            string2 = "BookSection";
            this.bibTexEntry = "inbook";
        } else if (string.equalsIgnoreCase("booklet")) {
            string2 = "BookSection";
            this.bibTexEntry = "booklet";
        } else if (string.equalsIgnoreCase("incollection")) {
            string2 = "BookSection";
            this.bibTexEntry = "incollection";
        } else if (string.equalsIgnoreCase("article")) {
            string2 = "JournalArticle";
        } else if (string.equalsIgnoreCase("inproceedings")) {
            string2 = "ConferenceProceedings";
            this.bibTexEntry = "inproceedings";
        } else if (string.equalsIgnoreCase("conference")) {
            string2 = "ConferenceProceedings";
            this.bibTexEntry = "conference";
        } else if (string.equalsIgnoreCase("proceedings")) {
            string2 = "ConferenceProceedings";
            this.bibTexEntry = "proceedings";
        } else if (string.equalsIgnoreCase("collection")) {
            string2 = "ConferenceProceedings";
            this.bibTexEntry = "collection";
        } else if (string.equalsIgnoreCase("techreport")) {
            string2 = "Report";
            this.bibTexEntry = "techreport";
        } else if (string.equalsIgnoreCase("manual")) {
            string2 = "Report";
            this.bibTexEntry = "manual";
        } else if (string.equalsIgnoreCase("mastersthesis")) {
            string2 = "Report";
            this.bibTexEntry = "mastersthesis";
        } else if (string.equalsIgnoreCase("phdthesis")) {
            string2 = "Report";
            this.bibTexEntry = "phdthesis";
        } else if (string.equalsIgnoreCase("unpublished")) {
            string2 = "Report";
            this.bibTexEntry = "unpublished";
        } else if (string.equalsIgnoreCase("patent")) {
            string2 = "Patent";
        } else if (string.equalsIgnoreCase("misc")) {
            string2 = "Misc";
        } else if (string.equalsIgnoreCase("electronic")) {
            string2 = "Misc";
            this.bibTexEntry = "electronic";
        }
        return string2;
    }

    private Node getDOMrepresentation() {
        Element element = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            element = this.getDOMrepresentation(documentBuilder.newDocument());
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return element;
    }

    private void addField(Document document, Element element, String string, String string2) {
        if (string2 == null) {
            return;
        }
        Element element2 = document.createElement("b:" + string);
        element2.appendChild(document.createTextNode(this.stripNonValidXMLCharacters(string2)));
        element.appendChild(element2);
    }

    private void addAuthor(Document document, Element element, String string, List<PersonName> list) {
        if (list == null) {
            return;
        }
        Element element2 = document.createElement("b:" + string);
        Element element3 = document.createElement("b:NameList");
        for (PersonName personName : list) {
            Element element4 = document.createElement("b:Person");
            this.addField(document, element4, "Last", personName.getSurname());
            this.addField(document, element4, "Middle", personName.getMiddlename());
            this.addField(document, element4, "First", personName.getFirstname());
            element3.appendChild(element4);
        }
        element2.appendChild(element3);
        element.appendChild(element2);
    }

    private void addAdrress(Document document, Element element, String string) {
        if (string == null) {
            return;
        }
        Pattern pattern = Pattern.compile("\\b(\\w+)\\s*[,]?\\s*(\\w+)\\s*[,]?\\s*(\\w+)\\b");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches() && matcher.groupCount() > 3) {
            this.addField(document, element, "City", matcher.group(1));
            this.addField(document, element, "StateProvince", matcher.group(2));
            this.addField(document, element, "CountryRegion", matcher.group(3));
        } else {
            this.addField(document, element, "City", string);
        }
    }

    private void addDate(Document document, Element element, String string, String string2) {
        if (string == null) {
            return;
        }
        Pattern pattern = Pattern.compile("(\\d{1,2})\\s*[.,-/]\\s*(\\d{1,2})\\s*[.,-/]\\s*(\\d{2,4})");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches() && matcher.groupCount() > 3) {
            this.addField(document, element, "Month" + string2, matcher.group(1));
            this.addField(document, element, "Day" + string2, matcher.group(2));
            this.addField(document, element, "Year" + string2, matcher.group(3));
        }
    }

    public Element getDOMrepresentation(Document document) {
        try {
            Element element = document.createElement("b:Source");
            this.addField(document, element, "SourceType", this.sourceType);
            this.addField(document, element, "BIBTEX_Entry", this.bibTexEntry);
            this.addField(document, element, "Tag", this.tag);
            this.addField(document, element, "GUID", this.GUID);
            if (this.LCID >= 0) {
                this.addField(document, element, "LCID", Integer.toString(this.LCID));
            }
            this.addField(document, element, "Title", this.title);
            this.addField(document, element, "Year", this.year);
            this.addField(document, element, "ShortTitle", this.shortTitle);
            this.addField(document, element, "Comments", this.comments);
            Element element2 = document.createElement("b:Author");
            this.addAuthor(document, element2, "Author", this.authors);
            this.addAuthor(document, element2, "BookAuthor", this.bookAuthors);
            this.addAuthor(document, element2, "Editor", this.editors);
            this.addAuthor(document, element2, "Translator", this.translators);
            this.addAuthor(document, element2, "ProducerName", this.producerNames);
            this.addAuthor(document, element2, "Composer", this.composers);
            this.addAuthor(document, element2, "Conductor", this.conductors);
            this.addAuthor(document, element2, "Performer", this.performers);
            this.addAuthor(document, element2, "Writer", this.writers);
            this.addAuthor(document, element2, "Director", this.directors);
            this.addAuthor(document, element2, "Compiler", this.compilers);
            this.addAuthor(document, element2, "Interviewer", this.interviewers);
            this.addAuthor(document, element2, "Interviewee", this.interviewees);
            this.addAuthor(document, element2, "Inventor", this.inventors);
            this.addAuthor(document, element2, "Counsel", this.counsels);
            element.appendChild(element2);
            if (this.pages != null) {
                this.addField(document, element, "Pages", this.pages.toString("-"));
            }
            this.addField(document, element, "Volume", this.volume);
            this.addField(document, element, "NumberVolumes", this.numberOfVolumes);
            this.addField(document, element, "Edition", this.edition);
            this.addField(document, element, "StandardNumber", this.standardNumber);
            this.addField(document, element, "Publisher", this.publisher);
            this.addAdrress(document, element, this.address);
            this.addField(document, element, "BookTitle", this.bookTitle);
            this.addField(document, element, "ChapterNumber", this.chapterNumber);
            this.addField(document, element, "JournalName", this.journalName);
            this.addField(document, element, "Issue", this.issue);
            this.addField(document, element, "PeriodicalTitle", this.periodicalTitle);
            this.addField(document, element, "ConferenceName", this.conferenceName);
            this.addField(document, element, "Department", this.department);
            this.addField(document, element, "Institution", this.institution);
            this.addField(document, element, "ThesisType", this.thesisType);
            this.addField(document, element, "InternetSiteTitle", this.internetSiteTitle);
            this.addDate(document, element, this.dateAccessed, "Accessed");
            this.addField(document, element, "Month", this.month);
            this.addField(document, element, "URL", this.url);
            this.addField(document, element, "ProductionCompany", this.productionCompany);
            this.addField(document, element, "PublicationTitle", this.publicationTitle);
            this.addField(document, element, "Medium", this.medium);
            this.addField(document, element, "AlbumTitle", this.albumTitle);
            this.addField(document, element, "RecordingNumber", this.recordingNumber);
            this.addField(document, element, "Theater", this.theater);
            this.addField(document, element, "Distributor", this.distributor);
            this.addField(document, element, "BroadcastTitle", this.broadcastTitle);
            this.addField(document, element, "Broadcaster", this.broadcaster);
            this.addField(document, element, "Station", this.station);
            this.addField(document, element, "Type", this.type);
            this.addField(document, element, "PatentNumber", this.patentNumber);
            this.addField(document, element, "Court", this.court);
            this.addField(document, element, "Reporter", this.reporter);
            this.addField(document, element, "CaseNumber", this.caseNumber);
            this.addField(document, element, "AbbreviatedCaseNumber", this.abbreviatedCaseNumber);
            this.addField(document, element, "BIBTEX_Series", this.bibTex_Series);
            this.addField(document, element, "BIBTEX_Abstract", this.bibTex_Abstract);
            this.addField(document, element, "BIBTEX_KeyWords", this.bibTex_KeyWords);
            this.addField(document, element, "BIBTEX_CrossRef", this.bibTex_CrossRef);
            this.addField(document, element, "BIBTEX_HowPublished", this.bibTex_HowPublished);
            this.addField(document, element, "BIBTEX_Affiliation", this.bibTex_Affiliation);
            this.addField(document, element, "BIBTEX_Contents", this.bibTex_Contents);
            this.addField(document, element, "BIBTEX_Copyright", this.bibTex_Copyright);
            this.addField(document, element, "BIBTEX_Price", this.bibTex_Price);
            this.addField(document, element, "BIBTEX_Size", this.bibTex_Size);
            this.addField(document, element, "BIBTEX_InType", this.bibTex_InType);
            this.addField(document, element, "BIBTEX_Paper", this.bibTex_Paper);
            return element;
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
            throw new Error(exception);
        }
    }

    private void parseSingleStandardNumber(String string, String string2, String string3, HashMap<String, String> hashMap) {
        Pattern pattern = Pattern.compile(':' + string + ":(.[^:]+)");
        Matcher matcher = pattern.matcher(string3);
        if (matcher.matches()) {
            hashMap.put(string2, matcher.group(1));
        }
    }

    private void parseStandardNumber(String string, HashMap<String, String> hashMap) {
        if (this.standardNumber == null) {
            return;
        }
        this.parseSingleStandardNumber("ISBN", "isbn", string, hashMap);
        this.parseSingleStandardNumber("ISSN", "issn", string, hashMap);
        this.parseSingleStandardNumber("LCCN", "lccn", string, hashMap);
        this.parseSingleStandardNumber("MRN", "mrnumber", string, hashMap);
        this.parseSingleStandardNumber("DOI", "doi", string, hashMap);
    }

    private void addAuthor(HashMap<String, String> hashMap, String string, List<PersonName> list) {
        if (list == null) {
            return;
        }
        String string2 = "";
        boolean bl = true;
        for (PersonName personName : list) {
            if (!bl) {
                string2 = string2 + " and ";
            }
            string2 = string2 + personName.getFullname();
            bl = false;
        }
        hashMap.put(string, string2);
    }

    private BibtexEntryType mapMSBibToBibtexType(String string) {
        BibtexEntryType bibtexEntryType = BibtexEntryTypes.OTHER;
        bibtexEntryType = string.equals("Book") ? BibtexEntryTypes.BOOK : (string.equals("BookSection") ? BibtexEntryTypes.INBOOK : (string.equals("JournalArticle") || string.equals("ArticleInAPeriodical") ? BibtexEntryTypes.ARTICLE : (string.equals("ConferenceProceedings") ? BibtexEntryTypes.CONFERENCE : (string.equals("Report") ? BibtexEntryTypes.TECHREPORT : (string.equals("InternetSite") || string.equals("DocumentFromInternetSite") || string.equals("ElectronicSource") || string.equals("Art") || string.equals("SoundRecording") || string.equals("Performance") || string.equals("Film") || string.equals("Interview") || string.equals("Patent") || string.equals("Case") ? BibtexEntryTypes.OTHER : BibtexEntryTypes.MISC)))));
        return bibtexEntryType;
    }

    public BibtexEntry getBibtexRepresentation() {
        BibtexEntry bibtexEntry = null;
        bibtexEntry = this.tag == null ? new BibtexEntry("__ID", this.mapMSBibToBibtexType(this.sourceType)) : new BibtexEntry(this.tag, this.mapMSBibToBibtexType(this.sourceType));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.tag != null) {
            hashMap.put("bibtexkey", this.tag);
        }
        if (this.LCID >= 0) {
            hashMap.put("language", this.getLanguage(this.LCID));
        }
        if (this.title != null) {
            hashMap.put("title", this.title);
        }
        if (this.year != null) {
            hashMap.put("year", this.year);
        }
        if (this.shortTitle != null) {
            hashMap.put("msbib-shorttitle", this.shortTitle);
        }
        if (this.comments != null) {
            hashMap.put("note", this.comments);
        }
        this.addAuthor(hashMap, "author", this.authors);
        this.addAuthor(hashMap, "msbib-bookauthor", this.bookAuthors);
        this.addAuthor(hashMap, "editor", this.editors);
        this.addAuthor(hashMap, "msbib-translator", this.translators);
        this.addAuthor(hashMap, "msbib-producername", this.producerNames);
        this.addAuthor(hashMap, "msbib-composer", this.composers);
        this.addAuthor(hashMap, "msbib-conductor", this.conductors);
        this.addAuthor(hashMap, "msbib-performer", this.performers);
        this.addAuthor(hashMap, "msbib-writer", this.writers);
        this.addAuthor(hashMap, "msbib-director", this.directors);
        this.addAuthor(hashMap, "msbib-compiler", this.compilers);
        this.addAuthor(hashMap, "msbib-interviewer", this.interviewers);
        this.addAuthor(hashMap, "msbib-interviewee", this.interviewees);
        this.addAuthor(hashMap, "msbib-inventor", this.inventors);
        this.addAuthor(hashMap, "msbib-counsel", this.counsels);
        if (this.pages != null) {
            hashMap.put("pages", this.pages.toString("--"));
        }
        if (this.volume != null) {
            hashMap.put("volume", this.volume);
        }
        if (this.numberOfVolumes != null) {
            hashMap.put("msbib-numberofvolume", this.numberOfVolumes);
        }
        if (this.edition != null) {
            hashMap.put("edition", this.edition);
        }
        if (this.edition != null) {
            hashMap.put("edition", this.edition);
        }
        this.parseStandardNumber(this.standardNumber, hashMap);
        if (this.publisher != null) {
            hashMap.put("publisher", this.publisher);
        }
        if (this.publisher != null) {
            hashMap.put("publisher", this.publisher);
        }
        if (this.address != null) {
            hashMap.put("address", this.address);
        }
        if (this.bookTitle != null) {
            hashMap.put("booktitle", this.bookTitle);
        }
        if (this.chapterNumber != null) {
            hashMap.put("chapter", this.chapterNumber);
        }
        if (this.journalName != null) {
            hashMap.put("journal", this.journalName);
        }
        if (this.issue != null) {
            hashMap.put("number", this.issue);
        }
        if (this.month != null) {
            hashMap.put("month", this.month);
        }
        if (this.periodicalTitle != null) {
            hashMap.put("organization", this.periodicalTitle);
        }
        if (this.conferenceName != null) {
            hashMap.put("organization", this.conferenceName);
        }
        if (this.department != null) {
            hashMap.put("school", this.department);
        }
        if (this.institution != null) {
            hashMap.put("institution", this.institution);
        }
        if (this.dateAccessed != null) {
            hashMap.put("msbib-accessed", this.dateAccessed);
        }
        if (this.url != null) {
            hashMap.put("url", this.url);
        }
        if (this.productionCompany != null) {
            hashMap.put("msbib-productioncompany", this.productionCompany);
        }
        if (this.medium != null) {
            hashMap.put("msbib-medium", this.medium);
        }
        if (this.recordingNumber != null) {
            hashMap.put("msbib-recordingnumber", this.recordingNumber);
        }
        if (this.theater != null) {
            hashMap.put("msbib-theater", this.theater);
        }
        if (this.distributor != null) {
            hashMap.put("msbib-distributor", this.distributor);
        }
        if (this.broadcaster != null) {
            hashMap.put("msbib-broadcaster", this.broadcaster);
        }
        if (this.station != null) {
            hashMap.put("msbib-station", this.station);
        }
        if (this.type != null) {
            hashMap.put("msbib-type", this.type);
        }
        if (this.patentNumber != null) {
            hashMap.put("msbib-patentnumber", this.patentNumber);
        }
        if (this.court != null) {
            hashMap.put("msbib-court", this.court);
        }
        if (this.reporter != null) {
            hashMap.put("msbib-reporter", this.reporter);
        }
        if (this.caseNumber != null) {
            hashMap.put("msbib-casenumber", this.caseNumber);
        }
        if (this.abbreviatedCaseNumber != null) {
            hashMap.put("msbib-abbreviatedcasenumber", this.abbreviatedCaseNumber);
        }
        if (this.bibTex_Series != null) {
            hashMap.put("series", this.bibTex_Series);
        }
        if (this.bibTex_Abstract != null) {
            hashMap.put("abstract", this.bibTex_Abstract);
        }
        if (this.bibTex_KeyWords != null) {
            hashMap.put("keywords", this.bibTex_KeyWords);
        }
        if (this.bibTex_CrossRef != null) {
            hashMap.put("crossref", this.bibTex_CrossRef);
        }
        if (this.bibTex_HowPublished != null) {
            hashMap.put("howpublished", this.bibTex_HowPublished);
        }
        if (this.bibTex_Affiliation != null) {
            hashMap.put("affiliation", this.bibTex_Affiliation);
        }
        if (this.bibTex_Contents != null) {
            hashMap.put("contents", this.bibTex_Contents);
        }
        if (this.bibTex_Copyright != null) {
            hashMap.put("copyright", this.bibTex_Copyright);
        }
        if (this.bibTex_Price != null) {
            hashMap.put("price", this.bibTex_Price);
        }
        if (this.bibTex_Size != null) {
            hashMap.put("size", this.bibTex_Size);
        }
        bibtexEntry.setField(hashMap);
        return bibtexEntry;
    }

    private String stripNonValidXMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null || string != null && string.isEmpty()) {
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMSource dOMSource = new DOMSource(this.getDOMrepresentation());
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        return stringWriter.toString();
    }
}

