/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.net;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

class Cookie {
    private final String name;
    private final String value;
    private final URI uri;
    String domain;
    private Date expires;
    private String path;
    private final DateFormat expiresFormat1 = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US);
    private final DateFormat expiresFormat2 = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US);

    public Cookie(URI uRI, String string) {
        String[] stringArray = string.split(";");
        String string2 = stringArray[0].trim();
        this.uri = uRI;
        this.name = string2.substring(0, string2.indexOf(61));
        this.value = string2.substring(string2.indexOf(61) + 1);
        this.path = "/";
        this.domain = uRI.getHost();
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = stringArray[i].trim();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.equalsIgnoreCase("domain")) {
                String string5 = uRI.getHost();
                if (string5.equals(string4)) {
                    this.domain = string4;
                    continue;
                }
                if (!string4.startsWith(".")) {
                    string4 = '.' + string4;
                }
                if (!((string5 = string5.substring(string5.indexOf(46))).equals(string4) || string5.endsWith(string4) || string4.endsWith(string5))) {
                    throw new IllegalArgumentException("Trying to set foreign cookie");
                }
                this.domain = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("path")) {
                this.path = string4;
                continue;
            }
            if (!string3.equalsIgnoreCase("expires")) continue;
            try {
                this.expires = this.expiresFormat1.parse(string4);
                continue;
            }
            catch (ParseException parseException) {
                try {
                    this.expires = this.expiresFormat2.parse(string4);
                    continue;
                }
                catch (ParseException parseException2) {
                    throw new IllegalArgumentException("Bad date format in header: " + string4);
                }
            }
        }
    }

    public boolean hasExpired() {
        if (this.expires == null) {
            return false;
        }
        Date date = new Date();
        return date.after(this.expires);
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean matches(URI uRI) {
        if (this.hasExpired()) {
            return false;
        }
        String string = uRI.getPath();
        if (string == null) {
            string = "/";
        }
        return string.startsWith(this.path);
    }

    public String toString() {
        return this.name + '=' + this.value;
    }
}

