/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jabref.net.Cookie;

class CookieHandlerImpl
extends CookieHandler {
    private final List<Cookie> cache = new LinkedList<Cookie>();

    CookieHandlerImpl() {
    }

    @Override
    public void put(URI uRI, Map<String, List<String>> map) throws IOException {
        List<String> list = map.get("Set-Cookie");
        if (list != null) {
            for (String string : list) {
                Cookie cookie = new Cookie(uRI, string);
                Iterator<Cookie> iterator = this.cache.iterator();
                while (iterator.hasNext()) {
                    Cookie cookie2 = iterator.next();
                    if (!cookie.domain.equals(cookie2.domain) || !cookie.getName().equals(cookie2.getName())) continue;
                    iterator.remove();
                    break;
                }
                this.cache.add(cookie);
            }
        }
    }

    @Override
    public Map<String, List<String>> get(URI uRI, Map<String, List<String>> map) throws IOException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = this.cache.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((Cookie)object).hasExpired()) {
                object2.remove();
                continue;
            }
            if (!((Cookie)object).matches(uRI)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((Cookie)object).toString());
        }
        object2 = new HashMap<String, List<String>>(map);
        if (stringBuilder.length() > 0) {
            object = Collections.singletonList(stringBuilder.toString());
            object2.put("Cookie", object);
        }
        return Collections.unmodifiableMap(object2);
    }
}

