/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.net;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import net.sf.jabref.Globals;
import net.sf.jabref.net.CookieHandlerImpl;

public class URLDownload {
    private final URL source;

    public static URLDownload buildMonitoredDownload(final Component component, URL uRL) {
        return new URLDownload(uRL){

            @Override
            protected InputStream monitorInputStream(InputStream inputStream) {
                return new ProgressMonitorInputStream(component, "Downloading " + this.getSource().toString(), inputStream);
            }
        };
    }

    public URLDownload(URL uRL) {
        this.source = uRL;
        URLDownload.setCookieHandler();
    }

    URL getSource() {
        return this.source;
    }

    private static void setCookieHandler() {
        try {
            if (CookieHandler.getDefault() == null) {
                CookieHandler.setDefault(new CookieHandlerImpl());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String determineMimeType() throws IOException {
        URLConnection uRLConnection = this.openConnection();
        try {
            String string = uRLConnection.getContentType();
            return string;
        }
        finally {
            try {
                uRLConnection.getInputStream().close();
            }
            catch (IOException iOException) {}
        }
    }

    private URLConnection openConnection() throws IOException {
        URLConnection uRLConnection = this.source.openConnection();
        uRLConnection.setRequestProperty("User-Agent", "JabRef");
        uRLConnection.connect();
        return uRLConnection;
    }

    public String downloadToString() throws IOException {
        return this.downloadToString(Globals.prefs.get("defaultEncoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadToString(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.openConnection().getInputStream());
        StringWriter stringWriter = new StringWriter();
        try {
            this.copy(bufferedInputStream, stringWriter, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
            try {
                ((Writer)stringWriter).close();
            }
            catch (Exception exception) {}
        }
        return ((Object)stringWriter).toString();
    }

    private void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        String string2;
        InputStream inputStream2 = this.monitorInputStream(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string2 = bufferedReader.readLine()) != null) {
            writer.write(string2);
            writer.write("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadToFile(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.openConnection().getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.copy(bufferedInputStream, bufferedOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {}
            try {
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        InputStream inputStream2 = this.monitorInputStream(inputStream);
        byte[] byArray = new byte[512];
        while ((n = inputStream2.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    protected InputStream monitorInputStream(InputStream inputStream) {
        return inputStream;
    }

    public String toString() {
        return "URLDownload{source=" + this.source + '}';
    }
}

