/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

class AdvancedCiteDialog {
    private static boolean defaultInPar = true;
    private boolean okPressed = false;
    private final JDialog diag;
    private final JRadioButton inPar = new JRadioButton(Globals.lang("Cite selected entries"));
    private final JRadioButton inText = new JRadioButton(Globals.lang("Cite selected entries with in-text citation"));
    private final JTextField pageInfo = new JTextField(15);
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));

    public AdvancedCiteDialog(JabRefFrame jabRefFrame) {
        this.diag = new JDialog(jabRefFrame, Globals.lang("Cite special"), true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.inPar);
        buttonGroup.add(this.inText);
        if (defaultInPar) {
            this.inPar.setSelected(true);
        } else {
            this.inText.setSelected(true);
        }
        this.inPar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                defaultInPar = AdvancedCiteDialog.this.inPar.isSelected();
            }
        });
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.append((Component)this.inPar, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.inText, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(Globals.lang("Extra information (e.g. page number)") + ":");
        defaultFormBuilder.append(this.pageInfo);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedCiteDialog.this.okPressed = true;
                AdvancedCiteDialog.this.diag.dispose();
            }
        };
        this.ok.addActionListener(abstractAction);
        this.pageInfo.addActionListener(abstractAction);
        this.inPar.addActionListener(abstractAction);
        this.inText.addActionListener(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedCiteDialog.this.okPressed = false;
                AdvancedCiteDialog.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction2);
        defaultFormBuilder.getPanel().getInputMap(2).put(Globals.prefs.getKey("Close dialog"), "close");
        defaultFormBuilder.getPanel().getActionMap().put("close", abstractAction2);
    }

    public void showDialog() {
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    public boolean cancelled() {
        return !this.okPressed;
    }

    public String getPageInfo() {
        return this.pageInfo.getText().trim();
    }

    public boolean isInParenthesisCite() {
        return this.inPar.isSelected();
    }
}

